/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Iterator;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.GraphOperation;
import org.tensorflow.GraphOperationBuilder;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.TensorFlow;

public final class Graph
implements ExecutionEnvironment,
AutoCloseable {
    private final Object nativeHandleLock = new Object();
    private long nativeHandle;
    private int refcount = 0;

    public Graph() {
        this.nativeHandle = Graph.allocate();
    }

    Graph(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == 0L) {
                return;
            }
            while (this.refcount > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Graph.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphOperation operation(String name) {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            long oph = Graph.operation(this.nativeHandle, name);
            if (oph == 0L) {
                return null;
            }
            return new GraphOperation(this, oph);
        }
    }

    public Iterator<Operation> operations() {
        return new OperationIterator(this);
    }

    @Override
    public GraphOperationBuilder opBuilder(String type, String name) {
        return new GraphOperationBuilder(this, type, name);
    }

    public void importGraphDef(byte[] graphDef) throws IllegalArgumentException {
        this.importGraphDef(graphDef, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importGraphDef(byte[] graphDef, String prefix) throws IllegalArgumentException {
        if (graphDef == null || prefix == null) {
            throw new IllegalArgumentException("graphDef and prefix cannot be null");
        }
        Object object = this.nativeHandleLock;
        synchronized (object) {
            Graph.importGraphDef(this.nativeHandle, graphDef, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toGraphDef() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            return Graph.toGraphDef(this.nativeHandle);
        }
    }

    public Output<?>[] addGradients(String prefix, Output<?>[] y, Output<?>[] x, Output<?>[] dx) {
        Output[] dy = new Output[x.length];
        long[] yHandles = new long[y.length];
        int[] yIndices = new int[y.length];
        long[] xHandles = new long[x.length];
        int[] xIndices = new int[x.length];
        long[] dxHandles = null;
        int[] dxIndices = null;
        try (Reference ref = this.ref();){
            long[] dyHandlesAndIndices;
            int ndy;
            int i;
            for (i = 0; i < y.length; ++i) {
                yHandles[i] = y[i].getUnsafeNativeHandle();
                yIndices[i] = y[i].index();
            }
            for (i = 0; i < x.length; ++i) {
                xHandles[i] = x[i].getUnsafeNativeHandle();
                xIndices[i] = x[i].index();
            }
            if (dx != null && dx.length > 0) {
                dxHandles = new long[dx.length];
                dxIndices = new int[dx.length];
                for (i = 0; i < dx.length; ++i) {
                    dxHandles[i] = dx[i].getUnsafeNativeHandle();
                    dxIndices[i] = dx[i].index();
                }
            }
            if ((ndy = (dyHandlesAndIndices = Graph.addGradients(ref.nativeHandle(), prefix, yHandles, yIndices, xHandles, xIndices, dxHandles, dxIndices)).length >> 1) != dy.length) {
                throw new IllegalStateException(String.valueOf(ndy) + " gradients were added to the graph when " + dy.length + " were expected");
            }
            int i2 = 0;
            int j = ndy;
            while (i2 < ndy) {
                GraphOperation op = new GraphOperation(this, dyHandlesAndIndices[i2]);
                dy[i2] = new Output(op, (int)dyHandlesAndIndices[j]);
                ++i2;
                ++j;
            }
        }
        return dy;
    }

    public Output<?>[] addGradients(Output<?> y, Output<?>[] x) {
        return this.addGradients(null, new Output[]{y}, x, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] buildSubgraph(WhileSubgraphBuilder subgraphBuilder, long subgraphHandle, long[] inputHandles, int[] inputIndices, long[] outputHandles, int[] outputIndices) {
        Graph subgraph = new Graph(subgraphHandle);
        int ninputs = inputHandles.length;
        int noutputs = outputHandles.length;
        Output[] inputs = new Output[ninputs];
        Output[] outputs = new Output[noutputs];
        long[] outputHandlesAndIndices = new long[noutputs * 2];
        Object object = subgraph.nativeHandleLock;
        synchronized (object) {
            try (Reference ref = subgraph.ref();){
                GraphOperation op;
                int i;
                for (i = 0; i < ninputs; ++i) {
                    op = new GraphOperation(subgraph, inputHandles[i]);
                    inputs[i] = op.output(inputIndices[i]);
                }
                for (i = 0; i < noutputs; ++i) {
                    op = new GraphOperation(subgraph, outputHandles[i]);
                    outputs[i] = op.output(outputIndices[i]);
                }
                subgraphBuilder.buildSubgraph(subgraph, inputs, outputs);
                i = 0;
                int j = noutputs;
                while (i < noutputs) {
                    outputHandlesAndIndices[i] = outputs[i].getUnsafeNativeHandle();
                    outputHandlesAndIndices[j] = outputs[i].index();
                    ++i;
                    ++j;
                }
            }
            return outputHandlesAndIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output<?>[] whileLoop(Output<?>[] inputs, WhileSubgraphBuilder cgBuilder, WhileSubgraphBuilder bgBuilder, String name) {
        int ninputs = inputs.length;
        long[] inputHandles = new long[ninputs];
        int[] inputIndices = new int[ninputs];
        Output[] outputs = new Output[ninputs];
        Object object = this.nativeHandleLock;
        synchronized (object) {
            try (Reference ref = this.ref();){
                for (int i = 0; i < ninputs; ++i) {
                    inputHandles[i] = inputs[i].getUnsafeNativeHandle();
                    inputIndices[i] = inputs[i].index();
                }
                long[] outputHandlesAndIndices = Graph.whileLoop(this.nativeHandle, inputHandles, inputIndices, name, cgBuilder, bgBuilder);
                int i = 0;
                int j = ninputs;
                while (i < ninputs) {
                    GraphOperation op = new GraphOperation(this, outputHandlesAndIndices[i]);
                    outputs[i] = op.output((int)outputHandlesAndIndices[j]);
                    ++i;
                    ++j;
                }
            }
            return outputs;
        }
    }

    Reference ref() {
        return new Reference();
    }

    private static native long allocate();

    private static native void delete(long var0);

    private static native long operation(long var0, String var2);

    private static native long[] nextOperation(long var0, int var2);

    private static native void importGraphDef(long var0, byte[] var2, String var3) throws IllegalArgumentException;

    private static native byte[] toGraphDef(long var0);

    private static native long[] addGradients(long var0, String var2, long[] var3, int[] var4, long[] var5, int[] var6, long[] var7, int[] var8);

    private static native long[] whileLoop(long var0, long[] var2, int[] var3, String var4, WhileSubgraphBuilder var5, WhileSubgraphBuilder var6);

    static {
        TensorFlow.init();
    }

    private static final class OperationIterator
    implements Iterator<Operation> {
        private final Graph graph;
        private Operation operation;
        private int position;

        OperationIterator(Graph g) {
            this.graph = g;
            this.operation = null;
            this.position = 0;
            this.advance();
        }

        private final void advance() {
            this.operation = null;
            try (Reference reference = this.graph.ref();){
                long[] nativeReturn = Graph.nextOperation(reference.nativeHandle(), this.position);
                if (nativeReturn != null && nativeReturn[0] != 0L) {
                    this.operation = new GraphOperation(this.graph, nativeReturn[0]);
                    this.position = (int)nativeReturn[1];
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.operation != null;
        }

        @Override
        public Operation next() {
            Operation rhett = this.operation;
            this.advance();
            return rhett;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is unsupported.");
        }
    }

    class Reference
    implements AutoCloseable {
        private boolean active;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Reference() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                boolean bl = this.active = Graph.this.nativeHandle != 0L;
                if (!this.active) {
                    throw new IllegalStateException("close() has been called on the Graph");
                }
                this.active = true;
                Graph.this.refcount++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                if (--Graph.this.refcount == 0) {
                    Graph.this.nativeHandleLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long nativeHandle() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                return this.active ? Graph.this.nativeHandle : 0L;
            }
        }
    }

    public static interface WhileSubgraphBuilder {
        public void buildSubgraph(Graph var1, Output<?>[] var2, Output<?>[] var3);
    }
}

