/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.TensorFlow;

public final class Server
implements AutoCloseable {
    private long nativeHandle;
    private int numJoining;

    public Server(byte[] serverDef) {
        this.nativeHandle = Server.allocate(serverDef);
    }

    public synchronized void start() {
        Server.start(this.nativeHandle);
    }

    public synchronized void stop() {
        Server.stop(this.nativeHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        long handle = 0L;
        Server server = this;
        synchronized (server) {
            handle = this.nativeHandle;
            if (handle != 0L) {
                ++this.numJoining;
            }
        }
        try {
            Server.join(handle);
        }
        finally {
            server = this;
            synchronized (server) {
                if (handle != 0L) {
                    --this.numJoining;
                }
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized void close() throws InterruptedException {
        this.stop();
        while (this.numJoining > 0) {
            this.wait();
        }
        Server.delete(this.nativeHandle);
        this.nativeHandle = 0L;
    }

    private static native long allocate(byte[] var0);

    private static native void start(long var0);

    private static native void stop(long var0);

    private static native void join(long var0);

    private static native void delete(long var0);

    static {
        TensorFlow.init();
    }
}

