/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.signal.BatchFft;
import org.tensorflow.op.signal.BatchFft2d;
import org.tensorflow.op.signal.BatchFft3d;
import org.tensorflow.op.signal.BatchIfft;
import org.tensorflow.op.signal.BatchIfft2d;
import org.tensorflow.op.signal.BatchIfft3d;
import org.tensorflow.op.signal.Fft;
import org.tensorflow.op.signal.Fft2d;
import org.tensorflow.op.signal.Fft3d;
import org.tensorflow.op.signal.Ifft;
import org.tensorflow.op.signal.Ifft2d;
import org.tensorflow.op.signal.Ifft3d;
import org.tensorflow.op.signal.Irfft;
import org.tensorflow.op.signal.Irfft2d;
import org.tensorflow.op.signal.Irfft3d;
import org.tensorflow.op.signal.Rfft;
import org.tensorflow.op.signal.Rfft2d;
import org.tensorflow.op.signal.Rfft3d;

public final class SignalOps {
    private final Scope scope;

    SignalOps(Scope scope) {
        this.scope = scope;
    }

    public BatchIfft batchIfft(Operand<?> input) {
        return BatchIfft.create(this.scope, input);
    }

    public <T> Ifft2d<T> ifft2d(Operand<T> input) {
        return Ifft2d.create(this.scope, input);
    }

    public <T> Ifft3d<T> ifft3d(Operand<T> input) {
        return Ifft3d.create(this.scope, input);
    }

    public <T> Fft2d<T> fft2d(Operand<T> input) {
        return Fft2d.create(this.scope, input);
    }

    public <T> Ifft<T> ifft(Operand<T> input) {
        return Ifft.create(this.scope, input);
    }

    public Irfft2d irfft2d(Operand<?> input, Operand<Integer> fftLength) {
        return Irfft2d.create(this.scope, input, fftLength);
    }

    public Rfft2d rfft2d(Operand<Float> input, Operand<Integer> fftLength) {
        return Rfft2d.create(this.scope, input, fftLength);
    }

    public Rfft rfft(Operand<Float> input, Operand<Integer> fftLength) {
        return Rfft.create(this.scope, input, fftLength);
    }

    public BatchIfft3d batchIfft3d(Operand<?> input) {
        return BatchIfft3d.create(this.scope, input);
    }

    public Irfft3d irfft3d(Operand<?> input, Operand<Integer> fftLength) {
        return Irfft3d.create(this.scope, input, fftLength);
    }

    public Rfft3d rfft3d(Operand<Float> input, Operand<Integer> fftLength) {
        return Rfft3d.create(this.scope, input, fftLength);
    }

    public BatchFft3d batchFft3d(Operand<?> input) {
        return BatchFft3d.create(this.scope, input);
    }

    public <T> Fft<T> fft(Operand<T> input) {
        return Fft.create(this.scope, input);
    }

    public BatchFft2d batchFft2d(Operand<?> input) {
        return BatchFft2d.create(this.scope, input);
    }

    public <T> Fft3d<T> fft3d(Operand<T> input) {
        return Fft3d.create(this.scope, input);
    }

    public BatchIfft2d batchIfft2d(Operand<?> input) {
        return BatchIfft2d.create(this.scope, input);
    }

    public BatchFft batchFft(Operand<?> input) {
        return BatchFft.create(this.scope, input);
    }

    public Irfft irfft(Operand<?> input, Operand<Integer> fftLength) {
        return Irfft.create(this.scope, input, fftLength);
    }
}

