/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MapPeek
extends PrimitiveOp
implements Iterable<Operand<Object>> {
    private List<Output<?>> values;

    public static MapPeek create(Scope scope, Operand<Long> key, Operand<Integer> indices, List<Class<?>> dtypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("MapPeek", scope.makeOpName("MapPeek"));
        opBuilder.addInput(key.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] dtypesArray = new DataType[dtypes.size()];
        for (int i = 0; i < dtypesArray.length; ++i) {
            dtypesArray[i] = DataType.fromClass(dtypes.get(i));
        }
        opBuilder.setAttr("dtypes", dtypesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.capacity != null) {
                    opBuilder.setAttr("capacity", opts.capacity);
                }
                if (opts.memoryLimit != null) {
                    opBuilder.setAttr("memory_limit", opts.memoryLimit);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new MapPeek(opBuilder.build());
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options memoryLimit(Long memoryLimit) {
        return new Options().memoryLimit(memoryLimit);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public List<Output<?>> values() {
        return this.values;
    }

    @Override
    public Iterator<Operand<Object>> iterator() {
        return this.values.iterator();
    }

    private MapPeek(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int valuesLength = operation.outputListLength("values");
        this.values = Arrays.asList(operation.outputList(outputIdx, valuesLength));
        outputIdx += valuesLength;
    }

    public static class Options {
        private Long capacity;
        private Long memoryLimit;
        private String container;
        private String sharedName;

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options memoryLimit(Long memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

