/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Placeholder<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> Placeholder<T> create(Scope scope, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("Placeholder", scope.makeOpName("Placeholder"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.shape == null) continue;
                opBuilder.setAttr("shape", opts.shape);
            }
        }
        return new Placeholder<T>(opBuilder.build());
    }

    public static Options shape(Shape shape) {
        return new Options().shape(shape);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Placeholder(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Shape shape;

        public Options shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        private Options() {
        }
    }
}

