/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RaggedGather<T extends Number, U>
extends PrimitiveOp {
    private List<Output<T>> outputNestedSplits;
    private Output<U> outputDenseValues;

    public static <T extends Number, U, V extends Number> RaggedGather<T, U> create(Scope scope, Iterable<Operand<T>> paramsNestedSplits, Operand<U> paramsDenseValues, Operand<V> indices, Long OUTPUTRAGGEDRANK) {
        OperationBuilder opBuilder = scope.env().opBuilder("RaggedGather", scope.makeOpName("RaggedGather"));
        opBuilder.addInputList(Operands.asOutputs(paramsNestedSplits));
        opBuilder.addInput(paramsDenseValues.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("OUTPUT_RAGGED_RANK", OUTPUTRAGGEDRANK);
        return new RaggedGather<T, U>(opBuilder.build());
    }

    public List<Output<T>> outputNestedSplits() {
        return this.outputNestedSplits;
    }

    public Output<U> outputDenseValues() {
        return this.outputDenseValues;
    }

    private RaggedGather(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputNestedSplitsLength = operation.outputListLength("output_nested_splits");
        this.outputNestedSplits = Arrays.asList(operation.outputList(outputIdx, outputNestedSplitsLength));
        outputIdx += outputNestedSplitsLength;
        this.outputDenseValues = operation.output(outputIdx++);
    }
}

