/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.summary;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ImageSummary
extends PrimitiveOp
implements Operand<String> {
    private Output<String> summary;

    public static <T extends Number> ImageSummary create(Scope scope, Operand<String> tag, Operand<T> tensor, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ImageSummary", scope.makeOpName("ImageSummary"));
        opBuilder.addInput(tag.asOutput());
        opBuilder.addInput(tensor.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxImages != null) {
                    opBuilder.setAttr("max_images", opts.maxImages);
                }
                if (opts.badColor == null) continue;
                opBuilder.setAttr("bad_color", opts.badColor);
            }
        }
        return new ImageSummary(opBuilder.build());
    }

    public static Options maxImages(Long maxImages) {
        return new Options().maxImages(maxImages);
    }

    public static Options badColor(Tensor<?> badColor) {
        return new Options().badColor(badColor);
    }

    public Output<String> summary() {
        return this.summary;
    }

    @Override
    public Output<String> asOutput() {
        return this.summary;
    }

    private ImageSummary(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.summary = operation.output(outputIdx++);
    }

    public static class Options {
        private Long maxImages;
        private Tensor<?> badColor;

        public Options maxImages(Long maxImages) {
            this.maxImages = maxImages;
            return this;
        }

        public Options badColor(Tensor<?> badColor) {
            this.badColor = badColor;
            return this;
        }

        private Options() {
        }
    }
}

