/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse;

import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.DoubleNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.DoubleSparseSlice;
import org.tensorflow.ndarray.index.Index;

public class DoubleSparseNdArray
extends AbstractSparseNdArray<Double, DoubleNdArray>
implements DoubleNdArray {
    protected DoubleSparseNdArray(LongNdArray indices, DoubleNdArray values, double defaultValue, DimensionalSpace dimensions) {
        super(indices, values, defaultValue, dimensions);
    }

    DoubleSparseNdArray(LongNdArray indices, DoubleNdArray values, DimensionalSpace dimensions) {
        this(indices, values, 0.0, dimensions);
    }

    DoubleSparseNdArray(DoubleDataBuffer dataBuffer, DimensionalSpace dimensions) {
        this(dataBuffer, 0.0, dimensions);
    }

    DoubleSparseNdArray(DoubleDataBuffer dataBuffer, double defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
        this.write(dataBuffer);
    }

    DoubleSparseNdArray(DimensionalSpace dimensions) {
        this(0.0, dimensions);
    }

    DoubleSparseNdArray(double defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
    }

    public static DoubleSparseNdArray create(LongNdArray indices, DoubleNdArray values, DimensionalSpace dimensions) {
        return new DoubleSparseNdArray(indices, values, dimensions);
    }

    public static DoubleSparseNdArray create(LongNdArray indices, DoubleNdArray values, double defaultValue, DimensionalSpace dimensions) {
        return new DoubleSparseNdArray(indices, values, defaultValue, dimensions);
    }

    public static DoubleSparseNdArray create(DoubleDataBuffer dataBuffer, DimensionalSpace dimensions) {
        return new DoubleSparseNdArray(dataBuffer, dimensions);
    }

    public static DoubleSparseNdArray create(DoubleDataBuffer dataBuffer, double defaultValue, DimensionalSpace dimensions) {
        return new DoubleSparseNdArray(dataBuffer, defaultValue, dimensions);
    }

    public static DoubleSparseNdArray create(DimensionalSpace dimensions) {
        return new DoubleSparseNdArray(dimensions);
    }

    public static DoubleSparseNdArray create(double defaultValue, DimensionalSpace dimensions) {
        return new DoubleSparseNdArray(defaultValue, dimensions);
    }

    public static DoubleSparseNdArray create(DoubleDataBuffer buffer, Shape shape) {
        return new DoubleSparseNdArray(buffer, DimensionalSpace.create(shape));
    }

    public static DoubleSparseNdArray create(DoubleDataBuffer buffer, double defaultValue, Shape shape) {
        return new DoubleSparseNdArray(buffer, defaultValue, DimensionalSpace.create(shape));
    }

    public static DoubleSparseNdArray create(DoubleNdArray src) {
        DoubleDataBuffer buffer = DataBuffers.ofDoubles(src.size());
        src.read(buffer);
        return new DoubleSparseNdArray(buffer, DimensionalSpace.create(src.shape()));
    }

    public static DoubleSparseNdArray create(DoubleNdArray src, double defaultValue) {
        DoubleDataBuffer buffer = DataBuffers.ofDoubles(src.size());
        src.read(buffer);
        return new DoubleSparseNdArray(buffer, defaultValue, DimensionalSpace.create(src.shape()));
    }

    @Override
    public DoubleNdArray createValues(Shape shape) {
        return NdArrays.ofDoubles(shape);
    }

    @Override
    public DoubleNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new DoubleSparseSlice(this, position, sliceDimensions);
    }

    @Override
    public double getDouble(long ... coordinates) {
        return (Double)this.getObject(coordinates);
    }

    @Override
    public DoubleNdArray setDouble(double value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleNdArray read(DataBuffer<Double> dst) {
        return this.read((DoubleDataBuffer)dst);
    }

    @Override
    public DoubleNdArray read(DoubleDataBuffer dst) {
        Object[] defaults = new Double[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write(defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            double value = ((DoubleNdArray)this.getValues()).getDouble(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public DoubleNdArray write(DoubleDataBuffer src) {
        ArrayList<long[]> indices = new ArrayList<long[]>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (long i = 0L; i < src.size(); ++i) {
            if (src.getObject(i).equals(this.getDefaultValue())) continue;
            indices.add(this.toCoordinates(this.dimensions, i));
            values.add(src.getObject(i));
        }
        long[][] indicesArray = new long[indices.size()][];
        double[] valuesArray = new double[values.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indicesArray[i] = (long[])indices.get(i);
            valuesArray[i] = (Double)values.get(i);
        }
        this.setIndices(StdArrays.ndCopyOf(indicesArray));
        this.setValues(NdArrays.vectorOf(valuesArray));
        return this;
    }

    @Override
    public DoubleNdArray write(DataBuffer<Double> src) {
        return this.write((DoubleDataBuffer)src);
    }

    @Override
    public DoubleNdArray toDense() {
        DoubleDataBuffer dataBuffer = DataBuffers.ofDoubles(this.shape().size());
        this.read(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    public DoubleNdArray fromDense(DoubleNdArray src) {
        DoubleDataBuffer buffer = DataBuffers.ofDoubles(src.size());
        src.read(buffer);
        this.write(buffer);
        return this;
    }

    @Override
    public DoubleNdArray slice(Index ... indices) {
        return (DoubleNdArray)super.slice(indices);
    }

    @Override
    public DoubleNdArray get(long ... coordinates) {
        return (DoubleNdArray)super.get(coordinates);
    }

    @Override
    public DoubleNdArray setObject(Double value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleNdArray set(NdArray<Double> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleNdArray copyTo(NdArray<Double> dst) {
        return (DoubleNdArray)super.copyTo(dst);
    }

    @Override
    public DoubleNdArray createDefaultArray() {
        return NdArrays.scalarOf((Double)this.getDefaultValue());
    }
}

