/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse.slice;

import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.ShortNdArray;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.SparseSlice;
import org.tensorflow.ndarray.index.Index;

public class ShortSparseSlice
extends SparseSlice<Short, ShortNdArray>
implements ShortNdArray {
    public ShortSparseSlice(AbstractSparseNdArray<Short, ShortNdArray> source, long sourcePosition, DimensionalSpace dimensions) {
        super(source, sourcePosition, dimensions);
    }

    @Override
    public ShortNdArray toDense() {
        ShortDataBuffer dataBuffer = DataBuffers.ofShorts(this.shape().size());
        this.read(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    @Override
    public short getShort(long ... coordinates) {
        return (Short)this.getObject(coordinates);
    }

    @Override
    public ShortNdArray setShort(short value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortNdArray setObject(Short value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortNdArray set(NdArray<Short> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortNdArray read(DataBuffer<Short> dst) {
        Object[] defaults = new Short[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write((Short[])defaults);
        AtomicLong i = new AtomicLong();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            short value = ((ShortNdArray)this.getValues()).getShort(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public ShortNdArray read(ShortDataBuffer dst) {
        return this.read((DataBuffer)dst);
    }

    @Override
    public ShortNdArray write(DataBuffer<Short> src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortNdArray write(ShortDataBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortNdArray slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    @Override
    public ShortNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new ShortSparseSlice(this.source, position + this.sourcePosition, sliceDimensions);
    }

    @Override
    public ShortNdArray get(long ... coordinates) {
        return (ShortNdArray)super.get(coordinates);
    }

    @Override
    public ShortNdArray copyTo(NdArray<Short> dst) {
        return (ShortNdArray)super.copyTo(dst);
    }

    @Override
    public ShortNdArray createDefaultArray() {
        return (ShortNdArray)this.source.getDefaultArray();
    }
}

