/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.ext;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;

public abstract class ScriptUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptUtils.class);
    public static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    public static final String FALLBACK_STATEMENT_SEPARATOR = "\n";
    public static final String DEFAULT_COMMENT_PREFIX = "--";
    public static final String DEFAULT_BLOCK_COMMENT_START_DELIMITER = "/*";
    public static final String DEFAULT_BLOCK_COMMENT_END_DELIMITER = "*/";

    private ScriptUtils() {
    }

    public static void splitSqlScript(String resource, String script, String separator, String commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) {
        ScriptUtils.checkArgument(StringUtils.isNotEmpty((String)script), "script must not be null or empty");
        ScriptUtils.checkArgument(separator != null, "separator must not be null");
        ScriptUtils.checkArgument(StringUtils.isNotEmpty((String)commentPrefix), "commentPrefix must not be null or empty");
        ScriptUtils.checkArgument(StringUtils.isNotEmpty((String)blockCommentStartDelimiter), "blockCommentStartDelimiter must not be null or empty");
        ScriptUtils.checkArgument(StringUtils.isNotEmpty((String)blockCommentEndDelimiter), "blockCommentEndDelimiter must not be null or empty");
        StringBuilder sb = new StringBuilder();
        boolean inEscape = false;
        boolean inLineComment = false;
        boolean inBlockComment = false;
        Character currentLiteralDelimiter = null;
        int compoundStatementDepth = 0;
        String lowerCaseScriptContent = script.toLowerCase();
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            boolean inCompoundStatement;
            boolean inComment;
            boolean inLiteral;
            char c = content[i];
            if (inEscape) {
                inEscape = false;
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                sb.append(c);
                continue;
            }
            if (!(inBlockComment || inLineComment || c != '\'' && c != '\"' && c != '`')) {
                if (currentLiteralDelimiter == null) {
                    currentLiteralDelimiter = Character.valueOf(c);
                } else if (currentLiteralDelimiter.charValue() == c) {
                    currentLiteralDelimiter = null;
                }
            }
            boolean bl = inLiteral = currentLiteralDelimiter != null;
            if (!inLiteral && ScriptUtils.containsSubstringAtOffset(lowerCaseScriptContent, commentPrefix, i)) {
                inLineComment = true;
            }
            if (inLineComment && c == '\n') {
                inLineComment = false;
            }
            if (!inLiteral && ScriptUtils.containsSubstringAtOffset(lowerCaseScriptContent, blockCommentStartDelimiter, i)) {
                inBlockComment = true;
            }
            if (!inLiteral && inBlockComment && ScriptUtils.containsSubstringAtOffset(lowerCaseScriptContent, blockCommentEndDelimiter, i)) {
                inBlockComment = false;
            }
            boolean bl2 = inComment = inLineComment || inBlockComment;
            if (!inLiteral && !inComment && ScriptUtils.containsSubstringAtOffset(lowerCaseScriptContent, "BEGIN", i)) {
                ++compoundStatementDepth;
            }
            if (!inLiteral && !inComment && ScriptUtils.containsSubstringAtOffset(lowerCaseScriptContent, "END", i)) {
                --compoundStatementDepth;
            }
            boolean bl3 = inCompoundStatement = compoundStatementDepth != 0;
            if (!inLiteral && !inCompoundStatement) {
                if (script.startsWith(separator, i)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += separator.length() - 1;
                    continue;
                }
                if (script.startsWith(commentPrefix, i)) {
                    int indexOfNextNewline = script.indexOf(FALLBACK_STATEMENT_SEPARATOR, i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (script.startsWith(blockCommentStartDelimiter, i)) {
                    int indexOfCommentEnd = script.indexOf(blockCommentEndDelimiter, i);
                    if (indexOfCommentEnd > i) {
                        i = indexOfCommentEnd + blockCommentEndDelimiter.length() - 1;
                        continue;
                    }
                    throw new ScriptParseException(String.format("Missing block comment end delimiter [%s].", blockCommentEndDelimiter), resource);
                }
                if (c == ' ' || c == '\n' || c == '\t') {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = ' ';
                }
            }
            sb.append(c);
        }
        if (StringUtils.isNotEmpty((String)sb.toString())) {
            statements.add(sb.toString());
        }
    }

    private static boolean containsSubstringAtOffset(String lowercaseString, String substring, int offset) {
        String lowercaseSubstring = substring.toLowerCase();
        return lowercaseString.startsWith(lowercaseSubstring, offset);
    }

    private static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(delim, i)) continue;
            return true;
        }
        return false;
    }

    public static void runInitScript(DatabaseDelegate databaseDelegate, String initScriptPath) {
        try {
            URL resource = ScriptUtils.class.getClassLoader().getResource(initScriptPath);
            if (resource == null) {
                LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
                throw new ScriptLoadException("Could not load classpath init script: " + initScriptPath + ". Resource not found.");
            }
            String scripts = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
            ScriptUtils.executeDatabaseScript(databaseDelegate, initScriptPath, scripts);
        }
        catch (IOException e) {
            LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
            throw new ScriptLoadException("Could not load classpath init script: " + initScriptPath, e);
        }
        catch (ScriptException e) {
            LOGGER.error("Error while executing init script: {}", (Object)initScriptPath, (Object)e);
            throw new UncategorizedScriptException("Error while executing init script: " + initScriptPath, e);
        }
    }

    public static void executeDatabaseScript(DatabaseDelegate databaseDelegate, String scriptPath, String script) throws ScriptException {
        ScriptUtils.executeDatabaseScript(databaseDelegate, scriptPath, script, false, false, DEFAULT_COMMENT_PREFIX, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    public static void executeDatabaseScript(DatabaseDelegate databaseDelegate, String scriptPath, String script, boolean continueOnError, boolean ignoreFailedDrops, String commentPrefix, String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) throws ScriptException {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Executing database script from " + scriptPath);
            }
            long startTime = System.currentTimeMillis();
            LinkedList<String> statements = new LinkedList<String>();
            if (separator == null) {
                separator = DEFAULT_STATEMENT_SEPARATOR;
            }
            if (!ScriptUtils.containsSqlScriptDelimiters(script, separator)) {
                separator = FALLBACK_STATEMENT_SEPARATOR;
            }
            ScriptUtils.splitSqlScript(scriptPath, script, separator, commentPrefix, blockCommentStartDelimiter, blockCommentEndDelimiter, statements);
            try (DatabaseDelegate closeableDelegate = databaseDelegate;){
                closeableDelegate.execute(statements, scriptPath, continueOnError, ignoreFailedDrops);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Executed database script from " + scriptPath + " in " + elapsedTime + " ms.");
            }
        }
        catch (Exception ex) {
            if (ex instanceof ScriptException) {
                throw (ScriptException)ex;
            }
            throw new UncategorizedScriptException("Failed to execute database script from resource [" + script + "]", ex);
        }
    }

    public static class UncategorizedScriptException
    extends RuntimeException {
        public UncategorizedScriptException(String s, Exception ex) {
            super(s, ex);
        }
    }

    public static class ScriptStatementFailedException
    extends RuntimeException {
        public ScriptStatementFailedException(String statement, int lineNumber, String scriptPath) {
            this(statement, lineNumber, scriptPath, null);
        }

        public ScriptStatementFailedException(String statement, int lineNumber, String scriptPath, Exception ex) {
            super(String.format("Script execution failed (%s:%d): %s", scriptPath, lineNumber, statement), ex);
        }
    }

    private static class ScriptParseException
    extends RuntimeException {
        public ScriptParseException(String format, String scriptPath) {
            super(String.format(format, scriptPath));
        }
    }

    public static class ScriptLoadException
    extends RuntimeException {
        public ScriptLoadException(String message) {
            super(message);
        }

        public ScriptLoadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

