/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.junit.jupiter;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.testcontainers.junit.jupiter.DockerAvailableDetector;
import org.testcontainers.junit.jupiter.EnabledIfDockerAvailable;

class EnabledIfDockerAvailableCondition
implements ExecutionCondition {
    private final DockerAvailableDetector dockerDetector = new DockerAvailableDetector();

    EnabledIfDockerAvailableCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return this.findAnnotation(context).map(this::evaluate).orElseThrow(() -> new ExtensionConfigurationException("@EnabledIfDockerAvailable not found"));
    }

    boolean isDockerAvailable() {
        return this.dockerDetector.isDockerAvailable();
    }

    private ConditionEvaluationResult evaluate(EnabledIfDockerAvailable testcontainers) {
        if (this.isDockerAvailable()) {
            return ConditionEvaluationResult.enabled((String)"Docker is available");
        }
        return ConditionEvaluationResult.disabled((String)"Docker is not available");
    }

    private Optional<EnabledIfDockerAvailable> findAnnotation(ExtensionContext context) {
        Optional current = Optional.of(context);
        while (current.isPresent()) {
            Optional enabledIfDockerAvailable = AnnotationSupport.findAnnotation((AnnotatedElement)current.get().getRequiredTestClass(), EnabledIfDockerAvailable.class);
            if (enabledIfDockerAvailable.isPresent()) {
                return enabledIfDockerAvailable;
            }
            current = current.get().getParent();
        }
        return Optional.empty();
    }
}

