/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.unitils.core.UnitilsException;
import org.unitils.dbunit.dataset.Column;
import org.unitils.dbunit.dataset.comparison.ColumnDifference;
import org.unitils.dbunit.dataset.comparison.RowDifference;

public class Row {
    private List<Column> primaryKeyColumns = new ArrayList<Column>();
    private List<Column> columns = new ArrayList<Column>();

    public Column getColumn(String columnName) {
        for (Column primaryKeyColumn : this.primaryKeyColumns) {
            if (!columnName.equalsIgnoreCase(primaryKeyColumn.getName())) continue;
            return primaryKeyColumn;
        }
        for (Column column : this.columns) {
            if (!columnName.equalsIgnoreCase(column.getName())) continue;
            return column;
        }
        return null;
    }

    public List<Column> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void addPrimaryKeyColumn(Column primaryKeyColumn) {
        Column existingColumn = this.getColumn(primaryKeyColumn.getName());
        if (existingColumn != null) {
            throw new UnitilsException("Unable to add primary column to data set row. Duplicate column name: " + primaryKeyColumn.getName());
        }
        this.primaryKeyColumns.add(primaryKeyColumn);
    }

    public void addColumn(Column column) {
        Column existingColumn = this.getColumn(column.getName());
        if (existingColumn != null) {
            throw new UnitilsException("Unable to add column to data set row. Duplicate column name: " + column.getName());
        }
        this.columns.add(column);
    }

    public boolean hasDifferentPrimaryKeyColumns(Row actualRow) {
        for (Column primaryKeyColumn : actualRow.getPrimaryKeyColumns()) {
            Column column = this.getColumn(primaryKeyColumn.getName());
            if (column == null || column.compare(primaryKeyColumn) == null) continue;
            return true;
        }
        return false;
    }

    public RowDifference compare(Row actualRow) {
        RowDifference rowDifference = new RowDifference(this, actualRow);
        this.compareColumns(this.primaryKeyColumns, actualRow, rowDifference);
        this.compareColumns(this.columns, actualRow, rowDifference);
        if (rowDifference.isMatch()) {
            return null;
        }
        return rowDifference;
    }

    protected void compareColumns(List<Column> columns, Row actualRow, RowDifference result) {
        for (Column column : columns) {
            Column actualColumn = actualRow.getColumn(column.getName());
            if (actualColumn == null) {
                result.addMissingColumn(column);
                continue;
            }
            ColumnDifference columnDifference = column.compare(actualColumn);
            if (columnDifference == null) continue;
            result.addColumnDifference(columnDifference);
        }
    }
}

