/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.datasetfactory.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.unitils.dbunit.datasetfactory.impl.DbUnitTable;

public class DbUnitDataSet
extends AbstractDataSet {
    protected Map<String, DbUnitTable> tablesPerName = new LinkedHashMap<String, DbUnitTable>(5);

    public ITable getTable(String tableName) {
        return this.getDbUnitTable(tableName);
    }

    public DbUnitTable getDbUnitTable(String tableName) {
        return this.tablesPerName.get(tableName);
    }

    public void addTable(DbUnitTable table) {
        String tableName = table.getTableMetaData().getTableName();
        this.tablesPerName.put(tableName, table);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        ITable[] tables = this.tablesPerName.values().toArray(new ITable[this.tablesPerName.size()]);
        return new DefaultTableIterator(tables, reversed);
    }
}

