/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KettleVariablesList {
    private static KettleVariablesList kettleVariablesList;
    private Map<String, String> descriptionMap = new HashMap<String, String>();
    private Map<String, String> defaultValueMap = new HashMap<String, String>();

    public static KettleVariablesList getInstance() {
        if (kettleVariablesList == null) {
            kettleVariablesList = new KettleVariablesList();
        }
        return kettleVariablesList;
    }

    public static void init() throws KettleException {
        KettleVariablesList variablesList = KettleVariablesList.getInstance();
        InputStream inputStream = variablesList.getClass().getResourceAsStream("kettle-variables.xml");
        if (inputStream == null) {
            inputStream = variablesList.getClass().getResourceAsStream("/kettle-variables.xml");
        }
        if (inputStream == null) {
            throw new KettlePluginException("Unable to find standard kettle variables definition file: kettle-variables.xml");
        }
        try {
            Document doc = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)false, (boolean)false);
            Node varsNode = XMLHandler.getSubNode((Node)doc, (String)"kettle-variables");
            int nrVars = XMLHandler.countNodes((Node)varsNode, (String)"kettle-variable");
            for (int i = 0; i < nrVars; ++i) {
                Node varNode = XMLHandler.getSubNodeByNr((Node)varsNode, (String)"kettle-variable", (int)i);
                String description = XMLHandler.getTagValue((Node)varNode, (String)"description");
                String variable = XMLHandler.getTagValue((Node)varNode, (String)"variable");
                String defaultValue = XMLHandler.getTagValue((Node)varNode, (String)"default-value");
                variablesList.getDescriptionMap().put(variable, description);
                variablesList.getDefaultValueMap().put(variable, defaultValue);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to read file 'kettle-variables.xml'", (Throwable)e);
        }
    }

    private KettleVariablesList() {
    }

    public Map<String, String> getDescriptionMap() {
        return this.descriptionMap;
    }

    public Map<String, String> getDefaultValueMap() {
        return this.defaultValueMap;
    }
}

