/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.auth;

import org.pentaho.di.core.auth.AuthenticationConsumerPluginType;
import org.pentaho.di.core.auth.AuthenticationConsumerType;
import org.pentaho.di.core.auth.NoAuthenticationAuthenticationProvider;
import org.pentaho.di.core.auth.core.AuthenticationConsumer;
import org.pentaho.di.core.auth.core.AuthenticationFactoryException;
import org.pentaho.di.core.auth.core.AuthenticationManager;
import org.pentaho.di.core.auth.core.AuthenticationProvider;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.i18n.BaseMessages;

public class AuthenticationPersistenceManager {
    private static final Class<?> PKG = AuthenticationPersistenceManager.class;
    private static final LogChannelInterface log = new LogChannel((Object)AuthenticationPersistenceManager.class.getName());

    public static AuthenticationManager getAuthenticationManager() {
        AuthenticationManager manager = new AuthenticationManager();
        manager.registerAuthenticationProvider(new NoAuthenticationAuthenticationProvider());
        for (PluginInterface plugin : PluginRegistry.getInstance().getPlugins(AuthenticationConsumerPluginType.class)) {
            try {
                Object pluginMain = PluginRegistry.getInstance().loadClass(plugin);
                if (pluginMain instanceof AuthenticationConsumerType) {
                    Class<? extends AuthenticationConsumer<?, ?>> consumerClass = ((AuthenticationConsumerType)pluginMain).getConsumerClass();
                    manager.registerConsumerClass(consumerClass);
                    continue;
                }
                throw new KettlePluginException(BaseMessages.getString(PKG, (String)"AuthenticationPersistenceManager.NotConsumerType", (Object[])new Object[]{pluginMain, AuthenticationConsumerType.class}));
            }
            catch (KettlePluginException e) {
                log.logError(e.getMessage(), (Throwable)e);
            }
            catch (AuthenticationFactoryException e) {
                log.logError(e.getMessage(), (Throwable)((Object)e));
            }
        }
        return manager;
    }

    public static void persistAuthenticationProvider(AuthenticationProvider authenticationProvider) {
    }
}

