/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.injection.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.injection.bean.BeanLevelInfo;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;

public class BeanInjectionInfo {
    private static LogChannelInterface LOG = KettleLogStore.getLogChannelInterfaceFactory().create(BeanInjectionInfo.class);
    protected final Class<?> clazz;
    private final InjectionSupported clazzAnnotation;
    private Map<String, Property> properties = new HashMap<String, Property>();
    private List<Group> groupsList = new ArrayList<Group>();
    private Map<String, Group> groupsMap = new HashMap<String, Group>();

    public static boolean isInjectionSupported(Class<?> clazz) {
        InjectionSupported annotation = clazz.getAnnotation(InjectionSupported.class);
        return annotation != null;
    }

    public BeanInjectionInfo(Class<?> clazz) {
        LOG.logDebug("Collect bean injection info for " + clazz);
        try {
            this.clazz = clazz;
            this.clazzAnnotation = clazz.getAnnotation(InjectionSupported.class);
            if (this.clazzAnnotation == null) {
                throw new RuntimeException("Injection not supported in " + clazz);
            }
            Group gr0 = new Group("");
            this.groupsList.add(gr0);
            this.groupsMap.put(gr0.getName(), gr0);
            for (String group : this.clazzAnnotation.groups()) {
                Group gr = new Group(group);
                this.groupsList.add(gr);
                this.groupsMap.put(gr.getName(), gr);
            }
            BeanLevelInfo root = new BeanLevelInfo();
            root.leafClass = clazz;
            root.init(this);
            this.properties = Collections.unmodifiableMap(this.properties);
            this.groupsList = Collections.unmodifiableList(this.groupsList);
            this.groupsMap = null;
        }
        catch (Throwable ex) {
            LOG.logError("Error bean injection info collection for " + clazz + ": " + ex.getMessage(), ex);
            throw ex;
        }
    }

    public String getLocalizationPrefix() {
        return this.clazzAnnotation.localizationPrefix();
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public List<Group> getGroups() {
        return this.groupsList;
    }

    protected void addInjectionProperty(Injection metaInj, BeanLevelInfo leaf) {
        if (StringUtils.isBlank((String)metaInj.name())) {
            throw new RuntimeException("Property name shouldn't be blank in the " + this.clazz);
        }
        if (this.properties.containsKey(metaInj.name())) {
            throw new RuntimeException("Property '" + metaInj.name() + "' already defined for " + this.clazz);
        }
        Property prop = new Property(metaInj.name(), metaInj.group(), leaf.createCallStack());
        this.properties.put(prop.name, prop);
        Group gr = this.groupsMap.get(metaInj.group());
        if (gr == null) {
            throw new RuntimeException("Group '" + metaInj.group() + "' is not defined " + this.clazz);
        }
        gr.groupProperties.add(prop);
    }

    public class Group {
        private final String name;
        protected final List<Property> groupProperties = new ArrayList<Property>();

        public Group(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<Property> getGroupProperties() {
            return Collections.unmodifiableList(this.groupProperties);
        }

        public String getDescription() {
            return BaseMessages.getString(BeanInjectionInfo.this.clazz, (String)(BeanInjectionInfo.this.clazzAnnotation.localizationPrefix() + this.name), (String[])new String[0]);
        }
    }

    public class Property {
        private final String name;
        private final String groupName;
        protected final List<BeanLevelInfo> path;
        protected final int pathArraysCount;

        public Property(String name, String groupName, List<BeanLevelInfo> path) {
            this.name = name;
            this.groupName = groupName;
            this.path = path;
            int ac = 0;
            for (BeanLevelInfo level : path) {
                if (!level.array) continue;
                ++ac;
            }
            this.pathArraysCount = ac;
        }

        public String getName() {
            return this.name;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getDescription() {
            return BaseMessages.getString(BeanInjectionInfo.this.clazz, (String)(BeanInjectionInfo.this.clazzAnnotation.localizationPrefix() + this.name), (String[])new String[0]);
        }
    }
}

