/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.injection.bean;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;

class BeanLevelInfo {
    public BeanLevelInfo parent;
    public Class<?> leafClass;
    public Field field;
    public Method getter;
    public Method setter;
    public boolean array;

    BeanLevelInfo() {
    }

    public void init(BeanInjectionInfo info) {
        this.introspect(info, this.leafClass);
    }

    private void introspect(BeanInjectionInfo info, Class<?> clazz) {
        while (clazz != null) {
            this.introspect(info, clazz.getDeclaredFields(), clazz.getDeclaredMethods());
            for (Class<?> intf : clazz.getInterfaces()) {
                this.introspect(info, intf);
            }
            clazz = clazz.getSuperclass();
        }
    }

    protected void introspect(BeanInjectionInfo info, Field[] fields, Method[] methods) {
        for (Field field : fields) {
            if (field.isSynthetic() || field.isEnumConstant() || Modifier.isStatic(field.getModifiers())) continue;
            BeanLevelInfo leaf = new BeanLevelInfo();
            leaf.parent = this;
            leaf.field = field;
            if (field.getType().isArray()) {
                leaf.array = true;
                leaf.leafClass = field.getType().getComponentType();
            } else {
                leaf.array = false;
                leaf.leafClass = field.getType();
            }
            Injection metaInj = field.getAnnotation(Injection.class);
            if (metaInj != null) {
                info.addInjectionProperty(metaInj, leaf);
                continue;
            }
            if (!field.isAnnotationPresent(InjectionDeep.class)) continue;
            leaf.init(info);
        }
        for (AccessibleObject accessibleObject : methods) {
            Class<?> setterClass;
            Injection metaInj;
            if (((Method)accessibleObject).isSynthetic() || Modifier.isStatic(((Method)accessibleObject).getModifiers()) || (metaInj = ((Method)accessibleObject).getAnnotation(Injection.class)) == null && !accessibleObject.isAnnotationPresent(InjectionDeep.class)) continue;
            BeanLevelInfo leaf = new BeanLevelInfo();
            leaf.parent = this;
            Class<?> getterClass = this.isGetter((Method)accessibleObject);
            if (getterClass != null) {
                leaf.getter = accessibleObject;
                leaf.leafClass = getterClass;
            }
            if ((setterClass = this.isSetter((Method)accessibleObject)) != null) {
                leaf.setter = accessibleObject;
                leaf.leafClass = setterClass;
            }
            if (leaf.leafClass == null) continue;
            leaf.array = false;
            if (setterClass != null && leaf.setter.getParameterTypes().length == 2) {
                leaf.array = true;
            }
            if (metaInj != null) {
                info.addInjectionProperty(metaInj, leaf);
                continue;
            }
            if (!accessibleObject.isAnnotationPresent(InjectionDeep.class)) continue;
            leaf.init(info);
        }
    }

    private Class<?> isGetter(Method m) {
        if (m.getReturnType() == Void.TYPE) {
            return null;
        }
        switch (m.getParameterTypes().length) {
            case 0: {
                return m.getReturnType();
            }
            case 1: {
                if (m.getParameterTypes()[0] != Integer.TYPE) break;
                return m.getReturnType();
            }
        }
        return null;
    }

    private Class<?> isSetter(Method m) {
        if (m.getReturnType() != Void.TYPE) {
            return null;
        }
        switch (m.getParameterTypes().length) {
            case 1: {
                return m.getParameterTypes()[0];
            }
            case 2: {
                if (m.getParameterTypes()[0] != Integer.TYPE) break;
                return m.getParameterTypes()[1];
            }
        }
        return null;
    }

    protected List<BeanLevelInfo> createCallStack() {
        ArrayList<BeanLevelInfo> stack = new ArrayList<BeanLevelInfo>();
        BeanLevelInfo p = this;
        while (p != null) {
            if (p.field != null) {
                p.field.setAccessible(true);
            }
            stack.add(p);
            p = p.parent;
        }
        Collections.reverse(stack);
        return stack;
    }

    public String toString() {
        String r = "";
        r = this.field != null ? r + "field " + this.field.getName() : r + "<root field>";
        r = r + "(class " + this.leafClass.getSimpleName() + ")";
        return r;
    }
}

