/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.HasOverwritePrompter;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.di.repository.CanLimitDirs;
import org.pentaho.di.repository.IRepositoryImporter;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.version.BuildVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Import {
    private static final Class<?> PKG = Import.class;
    public static final String STRING_IMPORT = "Import";

    public static void main(String[] a) throws KettleException {
        List<Object> limitDirs;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        KettleEnvironment.init();
        Props.init((int)1);
        List<String> args = Import.pickupCmdArguments(a);
        CommandLineOption[] commandLineOptionArray = new CommandLineOption[14];
        StringBuffer optionRepname = new StringBuffer();
        commandLineOptionArray[0] = Import.createOption("rep", "Import.CmdLine.RepName", optionRepname);
        StringBuffer optionUsername = new StringBuffer();
        commandLineOptionArray[1] = Import.createOption("user", "Import.CmdLine.RepUsername", optionUsername);
        StringBuffer optionPassword = new StringBuffer();
        commandLineOptionArray[2] = Import.createOption("pass", "Import.CmdLine.RepPassword", optionPassword);
        StringBuffer optionDirname = new StringBuffer();
        commandLineOptionArray[3] = Import.createOption("dir", "Import.CmdLine.RepDir", optionDirname);
        StringBuffer optionLimitDir = new StringBuffer();
        commandLineOptionArray[4] = Import.createOption("limitdir", "Import.CmdLine.LimitDir", optionLimitDir);
        StringBuffer optionFilename = new StringBuffer();
        commandLineOptionArray[5] = Import.createOption("file", "Import.CmdLine.File", optionFilename);
        StringBuffer optionFileDir = new StringBuffer();
        commandLineOptionArray[6] = Import.createOption("filedir", "Import.CmdLine.FileDir", optionFileDir);
        StringBuffer optionRules = new StringBuffer();
        commandLineOptionArray[7] = Import.createOption("rules", "Import.CmdLine.RulesFile", optionRules);
        StringBuffer optionNoRules = new StringBuffer();
        commandLineOptionArray[8] = Import.createOption("norules", "Import.CmdLine.NoRules", optionNoRules, true, false);
        StringBuffer optionComment = new StringBuffer();
        commandLineOptionArray[9] = Import.createOption("comment", "Import.CmdLine.Comment", optionComment, false, false);
        StringBuffer optionReplace = new StringBuffer();
        commandLineOptionArray[10] = Import.createOption("replace", "Import.CmdLine.Replace", optionReplace, true, false);
        StringBuffer optionContinueOnError = new StringBuffer();
        commandLineOptionArray[11] = Import.createOption("coe", "Import.CmdLine.ContinueOnError", optionContinueOnError, true, false);
        StringBuffer optionVersion = new StringBuffer();
        commandLineOptionArray[12] = Import.createOption("version", "Import.CmdLine.Version", optionVersion, true, false);
        commandLineOptionArray[13] = new CommandLineOption("", BaseMessages.getString(PKG, (String)"Import.CmdLine.ExtraFiles", (String[])new String[0]), new StringBuffer(), false, true, true);
        CommandLineOption[] options = commandLineOptionArray;
        if (args.isEmpty()) {
            CommandLineOption.printUsage(options);
            Import.exitJVM(9);
        }
        LogChannel log = new LogChannel((Object)STRING_IMPORT);
        CommandLineOption.parseArguments(args, options, (LogChannelInterface)log);
        ArrayList<String> filenames = new ArrayList<String>(args);
        if (!Const.isEmpty((StringBuffer)optionFilename)) {
            filenames.add(optionFilename.toString());
        }
        String kettleRepname = Const.getEnvironmentVariable((String)"KETTLE_REPOSITORY", null);
        String kettleUsername = Const.getEnvironmentVariable((String)"KETTLE_USER", null);
        String kettlePassword = Const.getEnvironmentVariable((String)"KETTLE_PASSWORD", null);
        if (!Const.isEmpty((String)kettleRepname)) {
            optionRepname = new StringBuffer(kettleRepname);
        }
        if (!Const.isEmpty((String)kettleUsername)) {
            optionUsername = new StringBuffer(kettleUsername);
        }
        if (!Const.isEmpty((String)kettlePassword)) {
            optionPassword = new StringBuffer(kettlePassword);
        }
        if (!Const.isEmpty((StringBuffer)optionVersion)) {
            BuildVersion buildVersion = BuildVersion.getInstance();
            log.logBasic(BaseMessages.getString(PKG, (String)"Import.Log.KettleVersion", (String[])new String[]{buildVersion.getVersion(), buildVersion.getRevision(), buildVersion.getBuildDate()}));
            if (a.length == 1) {
                Import.exitJVM(6);
            }
        }
        if (Const.isEmpty((StringBuffer)optionRepname)) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoRepProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        if (Const.isEmpty(filenames)) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoExportFileProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        if (Const.isEmpty((StringBuffer)optionDirname)) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoRepositoryDirectoryProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        if (Const.isEmpty((StringBuffer)optionRules) && Const.isEmpty((StringBuffer)optionNoRules) && !"Y".equalsIgnoreCase(optionNoRules.toString())) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoRulesFileProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        ImportRules importRules = new ImportRules();
        String rulesFile = optionRules.toString();
        if (!Const.isEmpty((String)rulesFile)) {
            try {
                Document document = XMLHandler.loadXMLFile((String)rulesFile);
                Node rulesNode = XMLHandler.getSubNode((Node)document, (String)"rules");
                importRules.loadXML(rulesNode);
                log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.RulesLoaded", (String[])new String[]{rulesFile, Integer.toString(importRules.getRules().size())}));
                for (ImportRuleInterface rule : importRules.getRules()) {
                    log.logBasic(" - " + rule.toString());
                }
            }
            catch (KettleException e) {
                log.logError(BaseMessages.getString(PKG, (String)"Import.Log.ExceptionLoadingRules", (String[])new String[]{rulesFile}), (Throwable)e);
                Import.exitJVM(7);
            }
        }
        if (!Const.isEmpty((StringBuffer)optionLimitDir)) {
            String[] directories = optionLimitDir.toString().split(",");
            limitDirs = Arrays.asList(directories);
        } else {
            limitDirs = Collections.emptyList();
        }
        RepositoriesMeta repsinfo = new RepositoriesMeta();
        repsinfo.getLog().setLogLevel(log.getLogLevel());
        try {
            repsinfo.readData();
        }
        catch (Exception e) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnableToLoadRepositoryInformation", (String[])new String[0]), (Throwable)e);
            Import.exitJVM(1);
        }
        RepositoryMeta repositoryMeta = repsinfo.findRepository(optionRepname.toString());
        if (repositoryMeta == null) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.RepositoryCouldNotBeFound", (String[])new String[]{optionRepname.toString()}));
            Import.exitJVM(1);
        }
        if (Const.isEmpty((StringBuffer)optionRepname)) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoRepProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        Repository repository = null;
        try {
            repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
            repository.init(repositoryMeta);
            repository.getLog().setLogLevel(log.getLogLevel());
        }
        catch (Exception e) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnableToLoadOrInitializeRepository", (String[])new String[0]));
            Import.exitJVM(1);
        }
        try {
            repository.connect(optionUsername != null ? optionUsername.toString() : null, optionPassword != null ? optionPassword.toString() : null);
        }
        catch (KettleException ke) {
            log.logError(ke.getMessage());
            Import.exitJVM(1);
        }
        catch (Exception e) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnableToConnectToRepository", (String[])new String[0]));
            Import.exitJVM(1);
        }
        boolean replace = Const.isEmpty((StringBuffer)optionReplace) ? false : ValueMeta.convertStringToBoolean((String)optionReplace.toString());
        boolean continueOnError = Const.isEmpty((StringBuffer)optionContinueOnError) ? false : ValueMeta.convertStringToBoolean((String)optionContinueOnError.toString());
        log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.Starting", (String[])new String[0]));
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Date start = new Date();
        int returnCode = 0;
        try {
            RepositoryDirectoryInterface tree = repository.loadRepositoryDirectoryTree();
            RepositoryDirectoryInterface targetDirectory = tree.findDirectory(optionDirname.toString());
            if (targetDirectory == null) {
                log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnableToFindTargetDirectoryInRepository", (String[])new String[]{optionDirname.toString()}));
                Import.exitJVM(1);
            }
            IRepositoryImporter importer = repository.getImporter();
            importer.setImportRules(importRules);
            if (!limitDirs.isEmpty()) {
                if (importer instanceof CanLimitDirs) {
                    ((CanLimitDirs)((Object)importer)).setLimitDirs(limitDirs);
                } else {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Import.CouldntLimitDirs", (String[])new String[]{importer.getClass().getCanonicalName()}));
                }
            }
            ImportFeedback feedbackInterface = new ImportFeedback((LogChannelInterface)log, continueOnError, replace, reader);
            importer.importAll(feedbackInterface, optionFileDir.toString(), filenames.toArray(new String[filenames.size()]), targetDirectory, replace, continueOnError, optionComment.toString());
            List<Exception> exceptions = importer.getExceptions();
            if (exceptions != null && !exceptions.isEmpty()) {
                log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnexpectedErrorDuringImport", (String[])new String[0]), (Throwable)exceptions.get(0));
                returnCode = 2;
            }
        }
        catch (Exception e) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnexpectedErrorDuringImport", (String[])new String[0]), (Throwable)e);
            Import.exitJVM(2);
        }
        log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.Finished", (String[])new String[0]));
        Date stop = new Date();
        String begin = df.format(start);
        String end = df.format(stop);
        log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.StartStop", (String[])new String[]{begin, end}));
        long seconds = (stop.getTime() - start.getTime()) / 1000L;
        if (seconds <= 60L) {
            log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.ProcessEndAfter", (String[])new String[]{String.valueOf(seconds)}));
        } else if (seconds <= 3600L) {
            int min = (int)(seconds / 60L);
            int rem = (int)(seconds % 60L);
            log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.ProcessEndAfterLong", (String[])new String[]{String.valueOf(min), String.valueOf(rem), String.valueOf(seconds)}));
        } else if (seconds <= 86400L) {
            int hour = (int)(seconds / 3600L);
            int rem = (int)(seconds % 3600L);
            int min = rem / 60;
            log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.ProcessEndAfterLonger", (String[])new String[]{String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
        } else {
            int days = (int)(seconds / 86400L);
            int rem = (int)(seconds % 86400L);
            int hour = rem / 3600;
            int min = (rem %= 3600) / 60;
            log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.ProcessEndAfterLongest", (String[])new String[]{String.valueOf(days), String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
        }
        Import.exitJVM(returnCode);
    }

    private static List<String> pickupCmdArguments(String[] a) {
        ArrayList<String> args = new ArrayList<String>(a.length);
        for (String arg : a) {
            if (arg.isEmpty()) continue;
            args.add(arg);
        }
        return args;
    }

    private static CommandLineOption createOption(String option, String i18nKey, StringBuffer sb) {
        return new CommandLineOption(option, BaseMessages.getString(PKG, (String)i18nKey, (String[])new String[0]), sb);
    }

    private static CommandLineOption createOption(String option, String i18nKey, StringBuffer sb, boolean yesNo, boolean hidden) {
        return new CommandLineOption(option, BaseMessages.getString(PKG, (String)i18nKey, (String[])new String[0]), sb, yesNo, hidden);
    }

    protected static int parseIntArgument(CommandLineOption option, int def) throws KettleException {
        if (!Const.isEmpty((StringBuffer)option.getArgument())) {
            try {
                return Integer.parseInt(option.getArgument().toString());
            }
            catch (NumberFormatException ex) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Import.Error.InvalidNumberArgument", (Object[])new Object[]{option.getOption(), option.getArgument()}));
            }
        }
        return def;
    }

    private static void exitJVM(int status) {
        System.exit(status);
    }

    private static class ImportFeedback
    implements RepositoryImportFeedbackInterface,
    HasOverwritePrompter {
        private final LogChannelInterface log;
        private final boolean continueOnError;
        private final boolean replace;
        private final BufferedReader reader;

        public ImportFeedback(LogChannelInterface log, boolean continueOnError, boolean replace, BufferedReader reader) {
            this.log = log;
            this.continueOnError = continueOnError;
            this.replace = replace;
            this.reader = reader;
        }

        @Override
        public void updateDisplay() {
        }

        @Override
        public boolean transOverwritePrompt(TransMeta transMeta) {
            return this.replace;
        }

        @Override
        public void showError(String title, String message, Exception e) {
            this.log.logError(title + " : " + message, (Throwable)e);
        }

        @Override
        public void setLabel(String labelText) {
            this.log.logBasic(labelText);
        }

        @Override
        public boolean jobOverwritePrompt(JobMeta jobMeta) {
            return this.replace;
        }

        @Override
        public boolean askContinueOnErrorQuestion(String title, String message) {
            return this.continueOnError;
        }

        @Override
        public void addLog(String line) {
            this.log.logBasic(line);
        }

        @Override
        public boolean isAskingOverwriteConfirmation() {
            return false;
        }

        public OverwritePrompter getOverwritePrompter() {
            return new OverwritePrompter(){
                private final String yes = BaseMessages.getString((Class)Import.access$000(), (String)"Import.Yes", (String[])new String[0]);
                private final String no = BaseMessages.getString((Class)Import.access$000(), (String)"Import.No", (String[])new String[0]);
                private final String none = BaseMessages.getString((Class)Import.access$000(), (String)"Import.None", (String[])new String[0]);
                private final String all = BaseMessages.getString((Class)Import.access$000(), (String)"Import.All", (String[])new String[0]);
                private final String prompt = "[" + this.yes + "," + this.no + "," + this.none + "," + this.all + "]";

                public boolean overwritePrompt(String message, String rememberText, String rememberPropertyName) {
                    ImportFeedback.this.log.logBasic(message);
                    Boolean result = null;
                    boolean remember = false;
                    while (result == null) {
                        String line;
                        ImportFeedback.this.log.logBasic(this.prompt);
                        try {
                            line = ImportFeedback.this.reader.readLine().trim();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(BaseMessages.getString((Class)PKG, (String)"Import.CouldntReadline", (String[])new String[0]));
                        }
                        if (line.equalsIgnoreCase(this.yes) || line.equalsIgnoreCase(this.all)) {
                            result = true;
                        } else if (line.equalsIgnoreCase(this.no) || line.equalsIgnoreCase(this.none)) {
                            result = false;
                        }
                        if (!line.equalsIgnoreCase(this.all) && !line.equalsIgnoreCase(this.none)) continue;
                        remember = true;
                    }
                    Props.getInstance().setProperty(rememberPropertyName, !remember ? "Y" : "N");
                    return result;
                }
            };
        }
    }
}

