/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.copyfiles;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.provider.url.UrlFileNameParser;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryCopyFiles
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryCopyFiles.class;
    public static final String SOURCE_CONFIGURATION_NAME = "source_configuration_name";
    public static final String SOURCE_FILE_FOLDER = "source_filefolder";
    public static final String DESTINATION_CONFIGURATION_NAME = "destination_configuration_name";
    public static final String DESTINATION_FILE_FOLDER = "destination_filefolder";
    public static final String LOCAL_SOURCE_FILE = "LOCAL-SOURCE-FILE-";
    public static final String LOCAL_DEST_FILE = "LOCAL-DEST-FILE-";
    public static final String STATIC_SOURCE_FILE = "STATIC-SOURCE-FILE-";
    public static final String STATIC_DEST_FILE = "STATIC-DEST-FILE-";
    public boolean copy_empty_folders = true;
    public boolean arg_from_previous = false;
    public boolean overwrite_files = false;
    public boolean include_subfolders = false;
    public boolean add_result_filesname = false;
    public boolean remove_source_files = false;
    public boolean destination_is_a_file = false;
    public boolean create_destination_folder = false;
    public String[] source_filefolder = null;
    public String[] destination_filefolder = null;
    public String[] wildcard = null;
    HashSet<String> list_files_remove = new HashSet();
    HashSet<String> list_add_result = new HashSet();
    int NbrFail = 0;
    private Map<String, String> configurationMappings = new HashMap<String, String>();

    public JobEntryCopyFiles(String n) {
        super(n, "");
    }

    public JobEntryCopyFiles() {
        this("");
    }

    public void allocate(int nrFields) {
        this.source_filefolder = new String[nrFields];
        this.destination_filefolder = new String[nrFields];
        this.wildcard = new String[nrFields];
    }

    @Override
    public Object clone() {
        JobEntryCopyFiles je = (JobEntryCopyFiles)super.clone();
        if (this.source_filefolder != null) {
            int nrFields = this.source_filefolder.length;
            je.allocate(nrFields);
            System.arraycopy(this.source_filefolder, 0, je.source_filefolder, 0, nrFields);
            System.arraycopy(this.destination_filefolder, 0, je.destination_filefolder, 0, nrFields);
            System.arraycopy(this.wildcard, 0, je.wildcard, 0, nrFields);
        }
        return je;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"copy_empty_folders", (boolean)this.copy_empty_folders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.arg_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"overwrite_files", (boolean)this.overwrite_files));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove_source_files", (boolean)this.remove_source_files));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_result_filesname", (boolean)this.add_result_filesname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination_is_a_file", (boolean)this.destination_is_a_file));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_destination_folder", (boolean)this.create_destination_folder));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                this.saveSource(retval, this.source_filefolder[i]);
                this.saveDestination(retval, this.destination_filefolder[i]);
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.copy_empty_folders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"copy_empty_folders"));
            this.arg_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.overwrite_files = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"overwrite_files"));
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.remove_source_files = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove_source_files"));
            this.add_result_filesname = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.destination_is_a_file = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"destination_is_a_file"));
            this.create_destination_folder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_destination_folder"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = this.loadSource(fnode);
                this.destination_filefolder[i] = this.loadDestination(fnode);
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    protected String loadSource(Node fnode) {
        String source_filefolder = XMLHandler.getTagValue((Node)fnode, (String)SOURCE_FILE_FOLDER);
        String ncName = XMLHandler.getTagValue((Node)fnode, (String)SOURCE_CONFIGURATION_NAME);
        return this.loadURL(source_filefolder, ncName, this.getMetaStore(), this.configurationMappings);
    }

    protected String loadDestination(Node fnode) {
        String destination_filefolder = XMLHandler.getTagValue((Node)fnode, (String)DESTINATION_FILE_FOLDER);
        String ncName = XMLHandler.getTagValue((Node)fnode, (String)DESTINATION_CONFIGURATION_NAME);
        return this.loadURL(destination_filefolder, ncName, this.getMetaStore(), this.configurationMappings);
    }

    protected void saveSource(StringBuilder retval, String source) {
        String namedCluster = this.configurationMappings.get(source);
        retval.append("          ").append(XMLHandler.addTagValue((String)SOURCE_FILE_FOLDER, (String)source));
        retval.append("          ").append(XMLHandler.addTagValue((String)SOURCE_CONFIGURATION_NAME, (String)namedCluster));
    }

    protected void saveDestination(StringBuilder retval, String destination) {
        String namedCluster = this.configurationMappings.get(destination);
        retval.append("          ").append(XMLHandler.addTagValue((String)DESTINATION_FILE_FOLDER, (String)destination));
        retval.append("          ").append(XMLHandler.addTagValue((String)DESTINATION_CONFIGURATION_NAME, (String)namedCluster));
    }

    protected String loadSourceRep(Repository rep, ObjectId id_jobentry, int a) throws KettleException {
        String source_filefolder = rep.getJobEntryAttributeString(id_jobentry, a, SOURCE_FILE_FOLDER);
        String ncName = rep.getJobEntryAttributeString(id_jobentry, a, SOURCE_CONFIGURATION_NAME);
        return this.loadURL(source_filefolder, ncName, this.getMetaStore(), this.configurationMappings);
    }

    protected String loadDestinationRep(Repository rep, ObjectId id_jobentry, int a) throws KettleException {
        String destination_filefolder = rep.getJobEntryAttributeString(id_jobentry, a, DESTINATION_FILE_FOLDER);
        String ncName = rep.getJobEntryAttributeString(id_jobentry, a, DESTINATION_CONFIGURATION_NAME);
        return this.loadURL(destination_filefolder, ncName, this.getMetaStore(), this.configurationMappings);
    }

    protected void saveSourceRep(Repository rep, ObjectId id_job, ObjectId id_jobentry, int i, String value) throws KettleException {
        String namedCluster = this.configurationMappings.get(value);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, SOURCE_FILE_FOLDER, value);
        rep.saveJobEntryAttribute(id_job, id_jobentry, i, SOURCE_CONFIGURATION_NAME, namedCluster);
    }

    protected void saveDestinationRep(Repository rep, ObjectId id_job, ObjectId id_jobentry, int i, String value) throws KettleException {
        String namedCluster = this.configurationMappings.get(value);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, DESTINATION_FILE_FOLDER, value);
        rep.saveJobEntryAttribute(id_job, id_jobentry, i, DESTINATION_CONFIGURATION_NAME, namedCluster);
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.copy_empty_folders = rep.getJobEntryAttributeBoolean(id_jobentry, "copy_empty_folders");
            this.arg_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.overwrite_files = rep.getJobEntryAttributeBoolean(id_jobentry, "overwrite_files");
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.remove_source_files = rep.getJobEntryAttributeBoolean(id_jobentry, "remove_source_files");
            this.add_result_filesname = rep.getJobEntryAttributeBoolean(id_jobentry, "add_result_filesname");
            this.destination_is_a_file = rep.getJobEntryAttributeBoolean(id_jobentry, "destination_is_a_file");
            this.create_destination_folder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_destination_folder");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, SOURCE_FILE_FOLDER);
            this.allocate(argnr);
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = this.loadSourceRep(rep, id_jobentry, a);
                this.destination_filefolder[a] = this.loadDestinationRep(rep, id_jobentry, a);
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.UnableLoadRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "copy_empty_folders", this.copy_empty_folders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.arg_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "overwrite_files", this.overwrite_files);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "remove_source_files", this.remove_source_files);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_result_filesname", this.add_result_filesname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destination_is_a_file", this.destination_is_a_file);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_destination_folder", this.create_destination_folder);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    this.saveSourceRep(rep, id_job, this.getObjectId(), i, this.source_filefolder[i]);
                    this.saveDestinationRep(rep, id_job, this.getObjectId(), i, this.destination_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "wildcard", this.wildcard[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.UnableSaveRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        int NbrFail = 0;
        NbrFail = 0;
        if (this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.Starting", (String[])new String[0]));
        }
        try {
            String[] vsourcefilefolder = this.source_filefolder;
            String[] vdestinationfilefolder = this.destination_filefolder;
            String[] vwildcard = this.wildcard;
            result.setResult(false);
            result.setNrErrors(1L);
            if (this.arg_from_previous && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
            }
            if (this.arg_from_previous && rows != null) {
                for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String vsourcefilefolder_previous = resultRow.getString(0, null);
                    String vdestinationfilefolder_previous = resultRow.getString(1, null);
                    String vwildcard_previous = resultRow.getString(2, null);
                    if (!Const.isEmpty((String)vsourcefilefolder_previous) && !Const.isEmpty((String)vdestinationfilefolder_previous)) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.ProcessingRow", (String[])new String[]{KettleVFS.getFriendlyURI((String)vsourcefilefolder_previous), KettleVFS.getFriendlyURI((String)vdestinationfilefolder_previous), vwildcard_previous}));
                        }
                        if (this.processFileFolder(vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous, this.parentJob, result)) continue;
                        ++NbrFail;
                        continue;
                    }
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.IgnoringRow", (String[])new String[]{KettleVFS.getFriendlyURI((String)vsourcefilefolder[iteration]), KettleVFS.getFriendlyURI((String)vdestinationfilefolder[iteration]), vwildcard[iteration]}));
                }
            } else if (vsourcefilefolder != null && vdestinationfilefolder != null) {
                for (int i = 0; i < vsourcefilefolder.length && !this.parentJob.isStopped(); ++i) {
                    if (!Const.isEmpty((String)vsourcefilefolder[i]) && !Const.isEmpty((String)vdestinationfilefolder[i])) {
                        if (this.isBasic()) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.ProcessingRow", (String[])new String[]{KettleVFS.getFriendlyURI((String)vsourcefilefolder[i]), KettleVFS.getFriendlyURI((String)vdestinationfilefolder[i]), vwildcard[i]}));
                        }
                        if (this.processFileFolder(vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i], this.parentJob, result)) continue;
                        ++NbrFail;
                        continue;
                    }
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.IgnoringRow", (String[])new String[]{KettleVFS.getFriendlyURI((String)vsourcefilefolder[i]), KettleVFS.getFriendlyURI((String)vdestinationfilefolder[i]), vwildcard[i]}));
                }
            }
        }
        finally {
            this.list_add_result = null;
            this.list_files_remove = null;
        }
        if (NbrFail == 0) {
            result.setResult(true);
            result.setNrErrors(0L);
        } else {
            result.setNrErrors((long)NbrFail);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processFileFolder(String sourcefilefoldername, String destinationfilefoldername, String wildcard, Job parentJob, Result result) {
        boolean entrystatus;
        block49: {
            entrystatus = false;
            FileObject sourcefilefolder = null;
            FileObject destinationfilefolder = null;
            this.list_files_remove.clear();
            this.list_add_result.clear();
            String realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
            String realDestinationFilefoldername = this.environmentSubstitute(destinationfilefoldername);
            String realWildcard = this.environmentSubstitute(wildcard);
            try {
                sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername, (VariableSpace)this);
                destinationfilefolder = KettleVFS.getFileObject((String)realDestinationFilefoldername, (VariableSpace)this);
                if (sourcefilefolder.exists()) {
                    if (this.CreateDestinationFolder(destinationfilefolder)) {
                        if (sourcefilefolder.getType().equals((Object)FileType.FOLDER) && this.destination_is_a_file) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.CanNotCopyFolderToFile", (String[])new String[]{KettleVFS.getFriendlyURI((String)realSourceFilefoldername), KettleVFS.getFriendlyURI((String)realDestinationFilefoldername)}));
                            ++this.NbrFail;
                        } else {
                            int trimPathLength;
                            if (destinationfilefolder.getType().equals((Object)FileType.FOLDER) && sourcefilefolder.getType().equals((Object)FileType.FILE)) {
                                destinationfilefolder.copyFrom(sourcefilefolder.getParent(), (FileSelector)new TextOneFileSelector(sourcefilefolder.getParent().toString(), sourcefilefolder.getName().getBaseName(), destinationfilefolder.toString()));
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)sourcefilefolder), KettleVFS.getFriendlyURI((FileObject)destinationfilefolder)}));
                                }
                            } else if (sourcefilefolder.getType().equals((Object)FileType.FILE) && this.destination_is_a_file) {
                                destinationfilefolder.copyFrom(sourcefilefolder, (FileSelector)new TextOneToOneFileSelector(destinationfilefolder));
                            } else {
                                if (this.isDetailed()) {
                                    this.logDetailed("  ");
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.FetchFolder", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)sourcefilefolder)}));
                                }
                                TextFileSelector textFileSelector = new TextFileSelector(sourcefilefolder, destinationfilefolder, realWildcard, parentJob);
                                try {
                                    destinationfilefolder.copyFrom(sourcefilefolder, (FileSelector)textFileSelector);
                                }
                                finally {
                                    textFileSelector.shutdown();
                                }
                            }
                            if (this.remove_source_files && !this.list_files_remove.isEmpty()) {
                                String sourceFilefoldername = sourcefilefolder.toString();
                                trimPathLength = sourceFilefoldername.length() + 1;
                                Iterator<String> iter = this.list_files_remove.iterator();
                                while (iter.hasNext() && !parentJob.isStopped()) {
                                    String fileremoventry = iter.next();
                                    FileObject removeFile = null;
                                    if (fileremoventry.startsWith(sourceFilefoldername) && trimPathLength < fileremoventry.length()) {
                                        removeFile = sourcefilefolder.getChild(fileremoventry.substring(trimPathLength));
                                    }
                                    if (removeFile == null) {
                                        removeFile = KettleVFS.getFileObject((String)fileremoventry, (VariableSpace)this);
                                    }
                                    if (removeFile.getType() != FileType.FILE) continue;
                                    boolean deletefile = removeFile.delete();
                                    this.logBasic(" ------ ");
                                    if (!deletefile) {
                                        this.logError("      " + BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.CanRemoveFileFolder", (String[])new String[]{KettleVFS.getFriendlyURI((String)fileremoventry)}));
                                        continue;
                                    }
                                    if (!this.isDetailed()) continue;
                                    this.logDetailed("      " + BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.FileFolderRemoved", (String[])new String[]{KettleVFS.getFriendlyURI((String)fileremoventry)}));
                                }
                            }
                            if (this.add_result_filesname && !this.list_add_result.isEmpty()) {
                                String destinationFilefoldername = destinationfilefolder.toString();
                                trimPathLength = destinationFilefoldername.length() + 1;
                                for (String fileaddentry : this.list_add_result) {
                                    FileObject addFile = null;
                                    if (fileaddentry.startsWith(destinationFilefoldername) && trimPathLength < fileaddentry.length()) {
                                        addFile = destinationfilefolder.getChild(fileaddentry.substring(trimPathLength));
                                    }
                                    if (addFile == null) {
                                        addFile = KettleVFS.getFileObject((String)fileaddentry, (VariableSpace)this);
                                    }
                                    if (addFile.getType() != FileType.FILE) continue;
                                    ResultFile resultFile = new ResultFile(0, addFile, parentJob.getJobname(), this.toString());
                                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                    if (!this.isDetailed()) continue;
                                    this.logDetailed(" ------ ");
                                    this.logDetailed("      " + BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.FileAddedToResultFilesName", (String[])new String[]{KettleVFS.getFriendlyURI((String)fileaddentry)}));
                                }
                            }
                        }
                        entrystatus = true;
                        break block49;
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.DestinationFolderNotFound", (String[])new String[]{KettleVFS.getFriendlyURI((String)realDestinationFilefoldername)}));
                    break block49;
                }
                this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.SourceFileNotExists", (String[])new String[]{KettleVFS.getFriendlyURI((String)realSourceFilefoldername)}));
            }
            catch (FileSystemException fse) {
                this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.CopyProcessFileSystemException", (String[])new String[]{fse.getMessage()}));
                for (Throwable throwable = fse.getCause(); throwable != null; throwable = throwable.getCause()) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.CausedBy", (String[])new String[]{throwable.getMessage()}));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{KettleVFS.getFriendlyURI((String)realSourceFilefoldername), KettleVFS.getFriendlyURI((String)realDestinationFilefoldername), e.getMessage()}), e);
            }
            finally {
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                        sourcefilefolder = null;
                    }
                    catch (IOException fse) {}
                }
                if (destinationfilefolder != null) {
                    try {
                        destinationfilefolder.close();
                        destinationfilefolder = null;
                    }
                    catch (IOException fse) {}
                }
            }
        }
        return entrystatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CreateDestinationFolder(FileObject filefolder) {
        FileObject folder = null;
        try {
            folder = this.destination_is_a_file ? filefolder.getParent() : filefolder;
            if (!folder.exists()) {
                if (this.create_destination_folder) {
                    if (this.isDetailed()) {
                        this.logDetailed("Folder  " + KettleVFS.getFriendlyURI((FileObject)folder) + " does not exist !");
                    }
                    folder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed("Folder parent was created.");
                    }
                } else {
                    this.logError("Folder  " + KettleVFS.getFriendlyURI((FileObject)folder) + " does not exist !");
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logError("Couldn't created parent folder " + KettleVFS.getFriendlyURI((FileObject)folder), e);
        }
        finally {
            if (folder != null) {
                try {
                    folder.close();
                    folder = null;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public void setCopyEmptyFolders(boolean copy_empty_foldersin) {
        this.copy_empty_folders = copy_empty_foldersin;
    }

    public boolean isCopyEmptyFolders() {
        return this.copy_empty_folders;
    }

    public void setoverwrite_files(boolean overwrite_filesin) {
        this.overwrite_files = overwrite_filesin;
    }

    public boolean isoverwrite_files() {
        return this.overwrite_files;
    }

    public void setIncludeSubfolders(boolean include_subfoldersin) {
        this.include_subfolders = include_subfoldersin;
    }

    public boolean isIncludeSubfolders() {
        return this.include_subfolders;
    }

    public void setAddresultfilesname(boolean add_result_filesnamein) {
        this.add_result_filesname = add_result_filesnamein;
    }

    public boolean isAddresultfilesname() {
        return this.add_result_filesname;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.arg_from_previous = argfrompreviousin;
    }

    public boolean isArgFromPrevious() {
        return this.arg_from_previous;
    }

    public void setRemoveSourceFiles(boolean remove_source_filesin) {
        this.remove_source_files = remove_source_filesin;
    }

    public boolean isRemoveSourceFiles() {
        return this.remove_source_files;
    }

    public void setDestinationIsAFile(boolean destination_is_a_file) {
        this.destination_is_a_file = destination_is_a_file;
    }

    public boolean isDestinationIsAFile() {
        return this.destination_is_a_file;
    }

    public void setCreateDestinationFolder(boolean create_destination_folder) {
        this.create_destination_folder = create_destination_folder;
    }

    public boolean isCreateDestinationFolder() {
        return this.create_destination_folder;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public String loadURL(String url, String ncName, IMetaStore metastore, Map mappings) {
        if (!Const.isEmpty((String)ncName) && !Const.isEmpty((String)url)) {
            mappings.put(url, ncName);
        }
        return url;
    }

    public void setConfigurationMappings(Map<String, String> mappings) {
        this.configurationMappings = mappings;
    }

    public String getConfigurationBy(String url) {
        return this.configurationMappings.get(url);
    }

    public String getUrlPath(String incomingURL) {
        String path = null;
        try {
            String noVariablesURL = incomingURL.replaceAll("[${}]", "/");
            UrlFileNameParser parser = new UrlFileNameParser();
            FileName fileName = parser.parseUri(null, null, noVariablesURL);
            String root = fileName.getRootURI();
            path = incomingURL.substring(root.length() - 1);
        }
        catch (FileSystemException e) {
            path = null;
        }
        return path;
    }

    private class TextOneFileSelector
    implements FileSelector {
        String filename = null;
        String foldername = null;
        String destfolder = null;
        private int traverseCount;

        public TextOneFileSelector(String sourcefolderin, String sourcefilenamein, String destfolderin) {
            if (!Const.isEmpty((String)sourcefilenamein)) {
                this.filename = sourcefilenamein;
            }
            if (!Const.isEmpty((String)sourcefolderin)) {
                this.foldername = sourcefolderin;
            }
            if (!Const.isEmpty((String)destfolderin)) {
                this.destfolder = destfolderin;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean resultat = false;
            String fil_name = null;
            try {
                if (info.getFile().getType() == FileType.FILE) {
                    if (info.getFile().getName().getBaseName().equals(this.filename) && info.getFile().getParent().toString().equals(this.foldername)) {
                        fil_name = this.destfolder + Const.FILE_SEPARATOR + this.filename;
                        if (KettleVFS.getFileObject((String)fil_name, (VariableSpace)JobEntryCopyFiles.this).exists()) {
                            if (JobEntryCopyFiles.this.isDetailed()) {
                                JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{KettleVFS.getFriendlyURI((String)fil_name)}));
                            }
                            if (JobEntryCopyFiles.this.overwrite_files) {
                                if (JobEntryCopyFiles.this.isDetailed()) {
                                    JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileOverwrite", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), KettleVFS.getFriendlyURI((String)fil_name)}));
                                }
                                resultat = true;
                            }
                        } else {
                            if (JobEntryCopyFiles.this.isDetailed()) {
                                JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), KettleVFS.getFriendlyURI((String)fil_name)}));
                            }
                            resultat = true;
                        }
                    }
                    if (resultat && JobEntryCopyFiles.this.remove_source_files) {
                        JobEntryCopyFiles.this.list_files_remove.add(info.getFile().toString());
                    }
                    if (resultat && JobEntryCopyFiles.this.add_result_filesname) {
                        JobEntryCopyFiles.this.list_add_result.add(KettleVFS.getFileObject(fil_name, (VariableSpace)JobEntryCopyFiles.this).toString());
                    }
                }
            }
            catch (Exception e) {
                JobEntryCopyFiles.this.logError(BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), KettleVFS.getFriendlyURI(fil_name), e.getMessage()}));
                resultat = false;
            }
            return resultat;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return this.traverseCount++ == 0 || JobEntryCopyFiles.this.include_subfolders;
        }
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;
        String destinationFolder = null;
        Job parentjob;
        Pattern pattern;
        private int traverseCount;
        FileObject destinationFolderObject = null;

        private boolean GetFileWildcard(String selectedfile) {
            boolean getIt = true;
            if (this.pattern != null) {
                Matcher matcher = this.pattern.matcher(selectedfile);
                getIt = matcher.matches();
            }
            return getIt;
        }

        public TextFileSelector(FileObject sourcefolderin, FileObject destinationfolderin, String filewildcard, Job parentJob) {
            if (sourcefolderin != null) {
                this.sourceFolder = sourcefolderin.toString();
            }
            if (destinationfolderin != null) {
                this.destinationFolderObject = destinationfolderin;
                this.destinationFolder = this.destinationFolderObject.toString();
            }
            if (!Const.isEmpty((String)filewildcard)) {
                this.fileWildcard = filewildcard;
                this.pattern = Pattern.compile(this.fileWildcard);
            }
            this.parentjob = parentJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            Object file_name = null;
            String addFileNameString = null;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder) && !this.parentjob.isStopped()) {
                    String short_filename = info.getFile().getName().getBaseName();
                    if (this.destinationFolderObject == null) {
                        this.destinationFolderObject = KettleVFS.getFileObject((String)this.destinationFolder, (VariableSpace)JobEntryCopyFiles.this);
                    }
                    String fullName = info.getFile().toString();
                    String baseFolder = info.getBaseFolder().toString();
                    String path = fullName.substring(fullName.indexOf(baseFolder) + baseFolder.length() + 1);
                    file_name = this.destinationFolderObject.resolveFile(path, NameScope.DESCENDENT);
                    if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (JobEntryCopyFiles.this.include_subfolders) {
                            if (info.getFile().getType() == FileType.FOLDER) {
                                if (JobEntryCopyFiles.this.include_subfolders && JobEntryCopyFiles.this.copy_empty_folders && Const.isEmpty((String)this.fileWildcard)) {
                                    if (file_name == null || !file_name.exists()) {
                                        if (JobEntryCopyFiles.this.isDetailed()) {
                                            JobEntryCopyFiles.this.logDetailed(" ------ ");
                                            JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FolderCopied", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), file_name != null ? KettleVFS.getFriendlyURI((FileObject)file_name) : ""}));
                                        }
                                        returncode = true;
                                    } else {
                                        if (JobEntryCopyFiles.this.isDetailed()) {
                                            JobEntryCopyFiles.this.logDetailed(" ------ ");
                                            JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FolderExists", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)file_name)}));
                                        }
                                        if (JobEntryCopyFiles.this.overwrite_files) {
                                            if (JobEntryCopyFiles.this.isDetailed()) {
                                                JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FolderOverwrite", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), KettleVFS.getFriendlyURI((FileObject)file_name)}));
                                            }
                                            returncode = true;
                                        }
                                    }
                                }
                            } else if (this.GetFileWildcard(short_filename)) {
                                if (file_name == null || !file_name.exists()) {
                                    if (JobEntryCopyFiles.this.isDetailed()) {
                                        JobEntryCopyFiles.this.logDetailed(" ------ ");
                                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), file_name != null ? KettleVFS.getFriendlyURI((FileObject)file_name) : ""}));
                                    }
                                    returncode = true;
                                } else {
                                    if (JobEntryCopyFiles.this.isDetailed()) {
                                        JobEntryCopyFiles.this.logDetailed(" ------ ");
                                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)file_name)}));
                                    }
                                    if (JobEntryCopyFiles.this.overwrite_files) {
                                        if (JobEntryCopyFiles.this.isDetailed()) {
                                            JobEntryCopyFiles.this.logDetailed("       " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), KettleVFS.getFriendlyURI((FileObject)file_name)}));
                                        }
                                        returncode = true;
                                    }
                                }
                            }
                        }
                    } else if (info.getFile().getType() == FileType.FOLDER) {
                        if (JobEntryCopyFiles.this.include_subfolders && JobEntryCopyFiles.this.copy_empty_folders && Const.isEmpty((String)this.fileWildcard)) {
                            if (file_name == null || !file_name.exists()) {
                                if (JobEntryCopyFiles.this.isDetailed()) {
                                    JobEntryCopyFiles.this.logDetailed("", " ------ ");
                                    JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FolderCopied", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), file_name != null ? KettleVFS.getFriendlyURI((FileObject)file_name) : ""}));
                                }
                                returncode = true;
                            } else {
                                if (JobEntryCopyFiles.this.isDetailed()) {
                                    JobEntryCopyFiles.this.logDetailed(" ------ ");
                                    JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FolderExists", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)file_name)}));
                                }
                                if (JobEntryCopyFiles.this.overwrite_files) {
                                    if (JobEntryCopyFiles.this.isDetailed()) {
                                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FolderOverwrite", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), KettleVFS.getFriendlyURI((FileObject)file_name)}));
                                    }
                                    returncode = true;
                                }
                            }
                        }
                    } else {
                        file_name = KettleVFS.getFileObject((String)(this.destinationFolder + Const.FILE_SEPARATOR + short_filename));
                        if (this.GetFileWildcard(short_filename)) {
                            if (file_name == null || !file_name.exists()) {
                                if (JobEntryCopyFiles.this.isDetailed()) {
                                    JobEntryCopyFiles.this.logDetailed(" ------ ");
                                    JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), file_name != null ? KettleVFS.getFriendlyURI((FileObject)file_name) : ""}));
                                }
                                returncode = true;
                            } else {
                                if (JobEntryCopyFiles.this.isDetailed()) {
                                    JobEntryCopyFiles.this.logDetailed(" ------ ");
                                    JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)file_name)}));
                                }
                                if (JobEntryCopyFiles.this.overwrite_files) {
                                    if (JobEntryCopyFiles.this.isDetailed()) {
                                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileExistsInfos", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), KettleVFS.getFriendlyURI((FileObject)file_name)}));
                                    }
                                    returncode = true;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                JobEntryCopyFiles.this.logError(BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), file_name != null ? KettleVFS.getFriendlyURI((FileObject)file_name) : null, e.getMessage()}));
                returncode = false;
            }
            finally {
                if (file_name != null) {
                    try {
                        if (returncode && JobEntryCopyFiles.this.add_result_filesname) {
                            addFileNameString = file_name.toString();
                        }
                        file_name.close();
                        file_name = null;
                    }
                    catch (IOException iOException) {}
                }
            }
            if (returncode && JobEntryCopyFiles.this.remove_source_files) {
                JobEntryCopyFiles.this.list_files_remove.add(info.getFile().toString());
            }
            if (returncode && JobEntryCopyFiles.this.add_result_filesname) {
                JobEntryCopyFiles.this.list_add_result.add(addFileNameString);
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return this.traverseCount++ == 0 || JobEntryCopyFiles.this.include_subfolders;
        }

        public void shutdown() {
            if (this.destinationFolderObject != null) {
                try {
                    this.destinationFolderObject.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class TextOneToOneFileSelector
    implements FileSelector {
        FileObject destfile = null;

        public TextOneToOneFileSelector(FileObject destinationfile) {
            if (destinationfile != null) {
                this.destfile = destinationfile;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean resultat = false;
            Object fil_name = null;
            try {
                if (this.destfile.exists()) {
                    if (JobEntryCopyFiles.this.isDetailed()) {
                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)this.destfile)}));
                    }
                    if (JobEntryCopyFiles.this.overwrite_files) {
                        if (JobEntryCopyFiles.this.isDetailed()) {
                            JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileOverwrite", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)this.destfile)}));
                        }
                        resultat = true;
                    }
                } else {
                    if (JobEntryCopyFiles.this.isDetailed()) {
                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), KettleVFS.getFriendlyURI((FileObject)this.destfile)}));
                    }
                    resultat = true;
                }
                if (resultat && JobEntryCopyFiles.this.remove_source_files) {
                    JobEntryCopyFiles.this.list_files_remove.add(info.getFile().toString());
                }
                if (resultat && JobEntryCopyFiles.this.add_result_filesname) {
                    JobEntryCopyFiles.this.list_add_result.add(this.destfile.toString());
                }
            }
            catch (Exception e) {
                JobEntryCopyFiles.this.logError(BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)info.getFile()), fil_name, e.getMessage()}));
            }
            return resultat;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return false;
        }
    }
}

