/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.job;

import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;

public class JobEntryJobRunner
implements Runnable {
    private static Class<?> PKG = Job.class;
    private Job job;
    private Result result;
    private LogChannelInterface log;
    private int entryNr;
    private boolean finished;

    public JobEntryJobRunner(Job job, Result result, int entryNr, LogChannelInterface log) {
        this.job = job;
        this.result = result;
        this.log = log;
        this.entryNr = entryNr;
        this.finished = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block14: {
            block13: {
                if (!this.job.isStopped() && (this.job.getParentJob() == null || !this.job.getParentJob().isStopped())) break block13;
                this.job.setResult(this.result);
                try {
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobFinish.id, (Object)this.getJob());
                    this.job.fireJobFinishListeners();
                }
                catch (Exception e) {
                    this.result.setNrErrors(1L);
                    this.result.setResult(false);
                    this.log.logError(BaseMessages.getString(PKG, (String)"Job.Log.ErrorExecJob", (String[])new String[]{e.getMessage()}), (Throwable)e);
                }
                this.job.setFinished(true);
                return;
            }
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobStart.id, (Object)this.getJob());
            this.job.fireJobStartListeners();
            this.result = this.job.execute(this.entryNr + 1, this.result);
            this.job.setResult(this.result);
            try {
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobFinish.id, (Object)this.getJob());
                this.job.fireJobFinishListeners();
            }
            catch (Exception e) {
                this.result.setNrErrors(1L);
                this.result.setResult(false);
                this.log.logError(BaseMessages.getString(PKG, (String)"Job.Log.ErrorExecJob", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            this.job.setFinished(true);
            break block14;
            catch (KettleException e) {
                try {
                    e.printStackTrace();
                    this.log.logError("An error occurred executing this job entry : ", (Throwable)e);
                    this.result.setResult(false);
                    this.result.setNrErrors(1L);
                    this.job.setResult(this.result);
                }
                catch (Throwable throwable) {
                    this.job.setResult(this.result);
                    try {
                        ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobFinish.id, (Object)this.getJob());
                        this.job.fireJobFinishListeners();
                    }
                    catch (Exception e2) {
                        this.result.setNrErrors(1L);
                        this.result.setResult(false);
                        this.log.logError(BaseMessages.getString(PKG, (String)"Job.Log.ErrorExecJob", (String[])new String[]{e2.getMessage()}), (Throwable)e2);
                    }
                    this.job.setFinished(true);
                    throw throwable;
                }
                try {
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobFinish.id, (Object)this.getJob());
                    this.job.fireJobFinishListeners();
                }
                catch (Exception e3) {
                    this.result.setNrErrors(1L);
                    this.result.setResult(false);
                    this.log.logError(BaseMessages.getString(PKG, (String)"Job.Log.ErrorExecJob", (String[])new String[]{e3.getMessage()}), (Throwable)e3);
                }
                this.job.setFinished(true);
            }
        }
        this.finished = true;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public LogChannelInterface getLog() {
        return this.log;
    }

    public void setLog(LogChannelInterface log) {
        this.log = log;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public int getEntryNr() {
        return this.entryNr;
    }

    public void setEntryNr(int entryNr) {
        this.entryNr = entryNr;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void waitUntilFinished() {
        while (!this.isFinished() && !this.job.isStopped()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

