/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObjectType;

public class RepositoryObject
implements RepositoryElementMetaInterface {
    @Deprecated
    public static final String STRING_OBJECT_TYPE_TRANSFORMATION = "Transformation";
    @Deprecated
    public static final String STRING_OBJECT_TYPE_JOB = "Job";
    private String name;
    private RepositoryDirectoryInterface repositoryDirectory;
    private String modifiedUser;
    private Date modifiedDate;
    private RepositoryObjectType objectType;
    private String description;
    private boolean deleted;
    private ObjectId objectId;

    public RepositoryObject() {
    }

    public RepositoryObject(ObjectId objectId, String name, RepositoryDirectoryInterface repositoryDirectory, String modifiedUser, Date modifiedDate, RepositoryObjectType objectType, String description, boolean deleted) {
        this();
        this.objectId = objectId;
        this.name = name;
        this.repositoryDirectory = repositoryDirectory;
        this.modifiedUser = modifiedUser;
        this.modifiedDate = modifiedDate;
        this.objectType = objectType;
        this.description = description;
        this.deleted = deleted;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getModifiedUser() {
        return this.modifiedUser;
    }

    public void setModifiedUser(String modifiedUser) {
        this.modifiedUser = modifiedUser;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static final int compareStrings(String one, String two) {
        if (one == null && two == null) {
            return 0;
        }
        if (one == null && two != null) {
            return -1;
        }
        if (one != null && two == null) {
            return 1;
        }
        return one.compareToIgnoreCase(two);
    }

    public static final int compareDates(Date one, Date two) {
        if (one == null && two == null) {
            return 0;
        }
        if (one == null && two != null) {
            return -1;
        }
        if (one != null && two == null) {
            return 1;
        }
        return one.compareTo(two);
    }

    public static final void sortRepositoryObjects(List<RepositoryElementMetaInterface> objects, final int sortPosition, final boolean ascending) {
        Collections.sort(objects, new Comparator<RepositoryElementMetaInterface>(){

            @Override
            public int compare(RepositoryElementMetaInterface r1, RepositoryElementMetaInterface r2) {
                int result = 0;
                switch (sortPosition) {
                    case 0: {
                        result = RepositoryObject.compareStrings(r1.getName(), r2.getName());
                        break;
                    }
                    case 1: {
                        result = RepositoryObject.compareStrings(r1.getObjectType().getTypeDescription(), r2.getObjectType().getTypeDescription());
                        break;
                    }
                    case 2: {
                        result = RepositoryObject.compareStrings(r1.getModifiedUser(), r2.getModifiedUser());
                        break;
                    }
                    case 3: {
                        result = RepositoryObject.compareDates(r1.getModifiedDate(), r2.getModifiedDate());
                        break;
                    }
                    case 4: {
                        result = RepositoryObject.compareStrings(r1.getDescription(), r2.getDescription());
                        break;
                    }
                }
                if (!ascending) {
                    result *= -1;
                }
                return result;
            }
        });
    }

    public RepositoryObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(RepositoryObjectType objectType) {
        this.objectType = objectType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public void setRepositoryDirectory(RepositoryDirectoryInterface repositoryDirectory) {
        this.repositoryDirectory = repositoryDirectory;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }
}

