/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.debug.TransDebugMeta;
import org.w3c.dom.Node;

public class TransExecutionConfiguration
implements ExecutionConfiguration {
    public static final String XML_TAG = "transformation_execution_configuration";
    private final LogChannelInterface log = LogChannel.GENERAL;
    private boolean executingLocally = true;
    private boolean executingRemotely;
    private SlaveServer remoteServer;
    private boolean passingExport = false;
    private boolean executingClustered;
    private boolean clusterPosting = true;
    private boolean clusterPreparing = true;
    private boolean clusterStarting = true;
    private boolean clusterShowingTransformation = false;
    private Map<String, String> arguments = new HashMap<String, String>();
    private Map<String, String> params = new HashMap<String, String>();
    private Map<String, String> variables = new HashMap<String, String>();
    private Date replayDate;
    private boolean safeModeEnabled;
    private LogLevel logLevel = LogLevel.BASIC;
    private boolean clearingLog = true;
    private TransDebugMeta transDebugMeta = null;
    private Result previousResult;
    private Repository repository;
    private boolean gatheringMetrics = false;
    private boolean showingSubComponents = true;
    private boolean setLogfile;
    private boolean setAppendLogfile;
    private String logFileName;
    private boolean createParentFolder;
    private Long passedBatchId;

    public TransExecutionConfiguration() {
    }

    @Override
    public Object clone() {
        try {
            TransExecutionConfiguration configuration = (TransExecutionConfiguration)super.clone();
            configuration.params = new HashMap<String, String>();
            configuration.params.putAll(this.params);
            configuration.arguments = new HashMap<String, String>();
            configuration.arguments.putAll(this.arguments);
            configuration.variables = new HashMap<String, String>();
            configuration.variables.putAll(this.variables);
            return configuration;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public Map<String, String> getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(Map<String, String> arguments) {
        this.arguments = arguments;
    }

    @Override
    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public void setArgumentStrings(String[] arguments) {
        this.arguments = new HashMap<String, String>();
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                this.arguments.put("arg " + (i + 1), arguments[i]);
            }
        }
    }

    public boolean isExecutingClustered() {
        return this.executingClustered;
    }

    public void setExecutingClustered(boolean clusteredExecution) {
        this.executingClustered = clusteredExecution;
    }

    public boolean isClusterStarting() {
        return this.clusterStarting;
    }

    public void setClusterStarting(boolean notExecuting) {
        this.clusterStarting = notExecuting;
    }

    public boolean isClusterShowingTransformation() {
        return this.clusterShowingTransformation;
    }

    public void setClusterShowingTransformation(boolean showingTransformations) {
        this.clusterShowingTransformation = showingTransformations;
    }

    @Override
    public Map<String, String> getVariables() {
        return this.variables;
    }

    @Override
    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    @Override
    public void setVariables(VariableSpace space) {
        this.variables = new HashMap<String, String>();
        for (String name : space.listVariables()) {
            String value = space.getVariable(name);
            this.variables.put(name, value);
        }
    }

    @Override
    public boolean isExecutingRemotely() {
        return this.executingRemotely;
    }

    @Override
    public void setExecutingRemotely(boolean remoteExecution) {
        this.executingRemotely = remoteExecution;
    }

    public boolean isClusterPosting() {
        return this.clusterPosting;
    }

    public void setClusterPosting(boolean clusterPosting) {
        this.clusterPosting = clusterPosting;
    }

    @Override
    public boolean isExecutingLocally() {
        return this.executingLocally;
    }

    @Override
    public void setExecutingLocally(boolean localExecution) {
        this.executingLocally = localExecution;
    }

    public boolean isClusterPreparing() {
        return this.clusterPreparing;
    }

    public void setClusterPreparing(boolean clusterPreparing) {
        this.clusterPreparing = clusterPreparing;
    }

    @Override
    public SlaveServer getRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public void setRemoteServer(SlaveServer remoteServer) {
        this.remoteServer = remoteServer;
    }

    public void getAllVariables(TransMeta transMeta) {
        Properties sp = new Properties();
        VariableSpace space = Variables.getADefaultVariableSpace();
        String[] keys = space.listVariables();
        for (int i = 0; i < keys.length; ++i) {
            sp.put(keys[i], space.getVariable(keys[i]));
        }
        String[] vars = transMeta.listVariables();
        if (vars != null && vars.length > 0) {
            HashMap<String, String> newVariables = new HashMap<String, String>();
            for (int i = 0; i < vars.length; ++i) {
                String varname = vars[i];
                newVariables.put(varname, Const.NVL((String)this.variables.get(varname), (String)sp.getProperty(varname, "")));
            }
            this.variables.putAll(newVariables);
        }
        for (String variableName : Const.INTERNAL_JOB_VARIABLES) {
            String value = transMeta.getVariable(variableName);
            if (Const.isEmpty((String)value)) continue;
            this.variables.put(variableName, value);
        }
    }

    public void getUsedVariables(TransMeta transMeta) {
        Properties sp = new Properties();
        VariableSpace space = Variables.getADefaultVariableSpace();
        String[] keys = space.listVariables();
        for (int i = 0; i < keys.length; ++i) {
            sp.put(keys[i], space.getVariable(keys[i]));
        }
        List<String> vars = transMeta.getUsedVariables();
        if (vars != null && vars.size() > 0) {
            HashMap<String, String> newVariables = new HashMap<String, String>();
            for (int i = 0; i < vars.size(); ++i) {
                String varname = vars.get(i);
                if (varname.startsWith("Internal")) continue;
                newVariables.put(varname, Const.NVL((String)this.variables.get(varname), (String)sp.getProperty(varname, "")));
            }
            this.variables.putAll(newVariables);
        }
        for (String variableName : Const.INTERNAL_JOB_VARIABLES) {
            String value = transMeta.getVariable(variableName);
            if (Const.isEmpty((String)value)) continue;
            this.variables.put(variableName, value);
        }
    }

    public void getUsedArguments(TransMeta transMeta, String[] commandLineArguments) {
        Map<String, String> map = transMeta.getUsedArguments(commandLineArguments);
        for (String key : map.keySet()) {
            String value = map.get(key);
            if (this.arguments.containsKey(key)) continue;
            this.arguments.put(key, value);
        }
    }

    @Override
    public Date getReplayDate() {
        return this.replayDate;
    }

    @Override
    public void setReplayDate(Date replayDate) {
        this.replayDate = replayDate;
    }

    @Override
    public boolean isSafeModeEnabled() {
        return this.safeModeEnabled;
    }

    @Override
    public void setSafeModeEnabled(boolean usingSafeMode) {
        this.safeModeEnabled = usingSafeMode;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String getXML() throws IOException {
        StringBuilder xml = new StringBuilder(200);
        xml.append("  <transformation_execution_configuration>").append(Const.CR);
        xml.append("    ").append(XMLHandler.addTagValue((String)"exec_local", (boolean)this.executingLocally));
        xml.append("    ").append(XMLHandler.addTagValue((String)"exec_remote", (boolean)this.executingRemotely));
        if (this.remoteServer != null) {
            xml.append("    ").append(this.remoteServer.getXML()).append(Const.CR);
        }
        xml.append("    ").append(XMLHandler.addTagValue((String)"pass_export", (boolean)this.passingExport));
        xml.append("    ").append(XMLHandler.addTagValue((String)"exec_cluster", (boolean)this.executingClustered));
        xml.append("    ").append(XMLHandler.addTagValue((String)"cluster_post", (boolean)this.clusterPosting));
        xml.append("    ").append(XMLHandler.addTagValue((String)"cluster_prepare", (boolean)this.clusterPreparing));
        xml.append("    ").append(XMLHandler.addTagValue((String)"cluster_start", (boolean)this.clusterStarting));
        xml.append("    ").append(XMLHandler.addTagValue((String)"cluster_show_trans", (boolean)this.clusterShowingTransformation));
        xml.append("    <parameters>").append(Const.CR);
        ArrayList<String> paramNames = new ArrayList<String>(this.params.keySet());
        Collections.sort(paramNames);
        for (String name : paramNames) {
            String value = this.params.get(name);
            xml.append("    <parameter>");
            xml.append(XMLHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.addTagValue((String)"value", (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</parameter>").append(Const.CR);
        }
        xml.append("    </parameters>").append(Const.CR);
        xml.append("    <variables>").append(Const.CR);
        ArrayList<String> variableNames = new ArrayList<String>(this.variables.keySet());
        Collections.sort(variableNames);
        for (String name : variableNames) {
            String value = this.variables.get(name);
            xml.append("    <variable>");
            xml.append(XMLHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.addTagValue((String)"value", (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</variable>").append(Const.CR);
        }
        xml.append("    </variables>").append(Const.CR);
        xml.append("    <arguments>").append(Const.CR);
        ArrayList<String> argumentNames = new ArrayList<String>(this.arguments.keySet());
        Collections.sort(argumentNames);
        for (String name : argumentNames) {
            String value = this.arguments.get(name);
            xml.append("    <argument>");
            xml.append(XMLHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.addTagValue((String)"value", (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</argument>").append(Const.CR);
        }
        xml.append("    </arguments>").append(Const.CR);
        xml.append("    ").append(XMLHandler.addTagValue((String)"replay_date", (Date)this.replayDate));
        xml.append("    ").append(XMLHandler.addTagValue((String)"safe_mode", (boolean)this.safeModeEnabled));
        xml.append("    ").append(XMLHandler.addTagValue((String)"log_level", (String)this.logLevel.getCode()));
        xml.append("    ").append(XMLHandler.addTagValue((String)"log_file", (boolean)this.setLogfile));
        xml.append("    ").append(XMLHandler.addTagValue((String)"log_filename", (String)this.logFileName));
        xml.append("    ").append(XMLHandler.addTagValue((String)"log_file_append", (boolean)this.setAppendLogfile));
        xml.append("    ").append(XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createParentFolder));
        xml.append("    ").append(XMLHandler.addTagValue((String)"clear_log", (boolean)this.clearingLog));
        xml.append("    ").append(XMLHandler.addTagValue((String)"gather_metrics", (boolean)this.gatheringMetrics));
        xml.append("    ").append(XMLHandler.addTagValue((String)"show_subcomponents", (boolean)this.showingSubComponents));
        if (this.passedBatchId != null) {
            xml.append("    ").append(XMLHandler.addTagValue((String)"passedBatchId", (long)this.passedBatchId));
        }
        if (this.previousResult != null) {
            xml.append(this.previousResult.getXML());
        }
        if (this.repository != null) {
            xml.append(XMLHandler.openTag((String)"repository"));
            xml.append(XMLHandler.addTagValue((String)"name", (String)this.repository.getName()));
            if (this.repository.getUserInfo() != null) {
                xml.append(XMLHandler.addTagValue((String)"login", (String)this.repository.getUserInfo().getLogin()));
                xml.append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPassword((String)this.repository.getUserInfo().getPassword())));
            }
            xml.append(XMLHandler.closeTag((String)"repository"));
        }
        xml.append("</transformation_execution_configuration>").append(Const.CR);
        return xml.toString();
    }

    public TransExecutionConfiguration(Node trecNode) throws KettleException {
        this();
        Node repNode;
        Node resultNode;
        this.executingLocally = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"exec_local"));
        this.executingRemotely = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"exec_remote"));
        Node remoteHostNode = XMLHandler.getSubNode((Node)trecNode, (String)"slaveserver");
        if (remoteHostNode != null) {
            this.remoteServer = new SlaveServer(remoteHostNode);
        }
        this.passingExport = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"pass_export"));
        this.executingClustered = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"exec_cluster"));
        this.clusterPosting = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"cluster_post"));
        this.clusterPreparing = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"cluster_prepare"));
        this.clusterStarting = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"cluster_start"));
        this.clusterShowingTransformation = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"cluster_show_trans"));
        Node varsNode = XMLHandler.getSubNode((Node)trecNode, (String)"variables");
        int nrVariables = XMLHandler.countNodes((Node)varsNode, (String)"variable");
        for (int i = 0; i < nrVariables; ++i) {
            Node argNode = XMLHandler.getSubNodeByNr((Node)varsNode, (String)"variable", (int)i);
            String name = XMLHandler.getTagValue((Node)argNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)argNode, (String)"value");
            if (Const.isEmpty((String)name)) continue;
            this.variables.put(name, Const.NVL((String)value, (String)""));
        }
        Node argsNode = XMLHandler.getSubNode((Node)trecNode, (String)"arguments");
        int nrArguments = XMLHandler.countNodes((Node)argsNode, (String)"argument");
        for (int i = 0; i < nrArguments; ++i) {
            Node argNode = XMLHandler.getSubNodeByNr((Node)argsNode, (String)"argument", (int)i);
            String name = XMLHandler.getTagValue((Node)argNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)argNode, (String)"value");
            if (Const.isEmpty((String)name) || Const.isEmpty((String)value)) continue;
            this.arguments.put(name, value);
        }
        Node parmsNode = XMLHandler.getSubNode((Node)trecNode, (String)"parameters");
        int nrParams = XMLHandler.countNodes((Node)parmsNode, (String)"parameter");
        for (int i = 0; i < nrParams; ++i) {
            Node parmNode = XMLHandler.getSubNodeByNr((Node)parmsNode, (String)"parameter", (int)i);
            String name = XMLHandler.getTagValue((Node)parmNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)parmNode, (String)"value");
            if (Const.isEmpty((String)name)) continue;
            this.params.put(name, value);
        }
        this.replayDate = XMLHandler.stringToDate((String)XMLHandler.getTagValue((Node)trecNode, (String)"replay_date"));
        this.safeModeEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"safe_mode"));
        this.logLevel = LogLevel.getLogLevelForCode((String)XMLHandler.getTagValue((Node)trecNode, (String)"log_level"));
        this.setLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"log_file"));
        this.logFileName = XMLHandler.getTagValue((Node)trecNode, (String)"log_filename");
        this.setAppendLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"log_file_append"));
        this.createParentFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"create_parent_folder"));
        this.clearingLog = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"clear_log"));
        this.gatheringMetrics = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"gather_metrics"));
        this.showingSubComponents = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"show_subcomponents"));
        String sPassedBatchId = XMLHandler.getTagValue((Node)trecNode, (String)"passedBatchId");
        if (!StringUtils.isEmpty((String)sPassedBatchId)) {
            this.passedBatchId = Long.parseLong(sPassedBatchId);
        }
        if ((resultNode = XMLHandler.getSubNode((Node)trecNode, (String)"result")) != null) {
            try {
                this.previousResult = new Result(resultNode);
            }
            catch (KettleException e) {
                throw new KettleException("Unable to hydrate previous result", (Throwable)e);
            }
        }
        if ((repNode = XMLHandler.getSubNode((Node)trecNode, (String)"repository")) != null) {
            String repositoryName = XMLHandler.getTagValue((Node)repNode, (String)"name");
            String username = XMLHandler.getTagValue((Node)repNode, (String)"login");
            String password = Encr.decryptPassword((String)XMLHandler.getTagValue((Node)repNode, (String)"password"));
            RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
            repositoriesMeta.getLog().setLogLevel(this.log.getLogLevel());
            try {
                repositoriesMeta.readData();
            }
            catch (Exception e) {
                throw new KettleException("Unable to get a list of repositories to locate repository '" + repositoryName + "'");
            }
            this.connectRepository(repositoriesMeta, repositoryName, username, password);
        }
    }

    @Override
    public Repository connectRepository(RepositoriesMeta repositoriesMeta, String repositoryName, String username, String password) throws KettleException {
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(repositoryName);
        if (repositoryMeta == null) {
            this.log.logBasic("I couldn't find the repository with name '" + repositoryName + "'");
            return null;
        }
        Repository rep = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
        if (rep == null) {
            this.log.logBasic("Unable to load repository plugin for '" + repositoryName + "'");
            return null;
        }
        rep.init(repositoryMeta);
        try {
            rep.connect(username, password);
            this.setRepository(rep);
            return rep;
        }
        catch (Exception e) {
            this.log.logBasic("Unable to connect to the repository with name '" + repositoryName + "'");
            return null;
        }
    }

    @Override
    public String[] getArgumentStrings() {
        if (this.arguments == null || this.arguments.size() == 0) {
            return null;
        }
        Object[] argNames = this.arguments.keySet().toArray(new String[this.arguments.size()]);
        Arrays.sort(argNames);
        String[] values = new String[argNames.length];
        for (int i = 0; i < argNames.length; ++i) {
            if (!((String)argNames[i]).equalsIgnoreCase("Argument " + (i + 1))) continue;
            values[i] = this.arguments.get(argNames[i]);
        }
        return values;
    }

    public TransDebugMeta getTransDebugMeta() {
        return this.transDebugMeta;
    }

    public void setTransDebugMeta(TransDebugMeta transDebugMeta) {
        this.transDebugMeta = transDebugMeta;
    }

    @Override
    public Result getPreviousResult() {
        return this.previousResult;
    }

    @Override
    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public boolean isClearingLog() {
        return this.clearingLog;
    }

    @Override
    public void setClearingLog(boolean clearingLog) {
        this.clearingLog = clearingLog;
    }

    @Override
    public boolean isPassingExport() {
        return this.passingExport;
    }

    @Override
    public void setPassingExport(boolean passingExport) {
        this.passingExport = passingExport;
    }

    @Override
    public boolean isGatheringMetrics() {
        return this.gatheringMetrics;
    }

    @Override
    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.gatheringMetrics = gatheringMetrics;
    }

    public boolean isShowingSubComponents() {
        return this.showingSubComponents;
    }

    public void setShowingSubComponents(boolean showingSubComponents) {
        this.showingSubComponents = showingSubComponents;
    }

    public boolean isSetLogfile() {
        return this.setLogfile;
    }

    public void setSetLogfile(boolean setLogfile) {
        this.setLogfile = setLogfile;
    }

    public boolean isSetAppendLogfile() {
        return this.setAppendLogfile;
    }

    public void setSetAppendLogfile(boolean setAppendLogfile) {
        this.setAppendLogfile = setAppendLogfile;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String fileName) {
        this.logFileName = fileName;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    @Override
    public Long getPassedBatchId() {
        return this.passedBatchId;
    }

    @Override
    public void setPassedBatchId(Long passedBatchId) {
        this.passedBatchId = passedBatchId;
    }
}

