/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.columnexists;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.columnexists.ColumnExists;
import org.pentaho.di.trans.steps.columnexists.ColumnExistsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class ColumnExistsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ColumnExistsMeta.class;
    private DatabaseMeta database;
    private String schemaname;
    private String tablename;
    private String tablenamefield;
    private String columnnamefield;
    private String resultfieldname;
    private boolean istablenameInfield;

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String getDynamicTablenameField() {
        return this.tablenamefield;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public void setDynamicTablenameField(String tablenamefield) {
        this.tablenamefield = tablenamefield;
    }

    public String getDynamicColumnnameField() {
        return this.columnnamefield;
    }

    public void setDynamicColumnnameField(String columnnamefield) {
        this.columnnamefield = columnnamefield;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public boolean isTablenameInField() {
        return this.istablenameInfield;
    }

    public void setTablenameInField(boolean istablenameInfield) {
        this.istablenameInfield = istablenameInfield;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        ColumnExistsMeta retval = (ColumnExistsMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.database = null;
        this.schemaname = null;
        this.tablename = null;
        this.istablenameInfield = false;
        this.resultfieldname = "result";
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!Const.isEmpty((String)this.resultfieldname)) {
            ValueMetaBoolean v = new ValueMetaBoolean(space.environmentSubstitute(this.resultfieldname));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.database == null ? "" : this.database.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("    " + XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("    " + XMLHandler.addTagValue((String)"istablenameInfield", (boolean)this.istablenameInfield));
        retval.append("    " + XMLHandler.addTagValue((String)"tablenamefield", (String)this.tablenamefield));
        retval.append("    " + XMLHandler.addTagValue((String)"columnnamefield", (String)this.columnnamefield));
        retval.append("      " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.database = DatabaseMeta.findDatabase(databases, (String)con);
            this.tablename = XMLHandler.getTagValue((Node)stepnode, (String)"tablename");
            this.schemaname = XMLHandler.getTagValue((Node)stepnode, (String)"schemaname");
            this.istablenameInfield = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"istablenameInfield"));
            this.tablenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"tablenamefield");
            this.columnnamefield = XMLHandler.getTagValue((Node)stepnode, (String)"columnnamefield");
            this.resultfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ColumnExistsMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.database = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.tablename = rep.getStepAttributeString(id_step, "tablename");
            this.schemaname = rep.getStepAttributeString(id_step, "schemaname");
            this.istablenameInfield = rep.getStepAttributeBoolean(id_step, "istablenameInfield");
            this.tablenamefield = rep.getStepAttributeString(id_step, "tablenamefield");
            this.columnnamefield = rep.getStepAttributeString(id_step, "columnnamefield");
            this.resultfieldname = rep.getStepAttributeString(id_step, "resultfieldname");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ColumnExistsMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.database);
            rep.saveStepAttribute(id_transformation, id_step, "tablename", this.tablename);
            rep.saveStepAttribute(id_transformation, id_step, "schemaname", this.schemaname);
            rep.saveStepAttribute(id_transformation, id_step, "istablenameInfield", this.istablenameInfield);
            rep.saveStepAttribute(id_transformation, id_step, "tablenamefield", this.tablenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "columnnamefield", this.columnnamefield);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultfieldname);
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ColumnExistsMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.database == null) {
            error_message = BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.resultfieldname)) {
            error_message = BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        remarks.add((CheckResultInterface)cr);
        if (this.istablenameInfield) {
            if (Const.isEmpty((String)this.tablenamefield)) {
                error_message = BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.TableFieldMissing", (String[])new String[0]);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            } else {
                error_message = BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.TableFieldOK", (String[])new String[0]);
                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            }
            remarks.add((CheckResultInterface)cr);
        } else {
            if (Const.isEmpty((String)this.tablename)) {
                error_message = BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.TablenameMissing", (String[])new String[0]);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            } else {
                error_message = BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.TablenameOK", (String[])new String[0]);
                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            }
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.columnnamefield)) {
            error_message = BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.ColumnNameFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.ColumnNameFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"ColumnExistsMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ColumnExists(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ColumnExistsData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.database != null) {
            return new DatabaseMeta[]{this.database};
        }
        return super.getUsedDatabaseConnections();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

