/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;

public class ExcelInputField
implements Cloneable {
    @Injection(name="NAME", group="FIELDS")
    private String name;
    private int type;
    @Injection(name="LENGTH", group="FIELDS")
    private int length = -1;
    @Injection(name="PRECISION", group="FIELDS")
    private int precision = -1;
    private int trimtype;
    @Injection(name="FORMAT", group="FIELDS")
    private String format;
    @Injection(name="CURRENCY", group="FIELDS")
    private String currencySymbol;
    @Injection(name="DECIMAL", group="FIELDS")
    private String decimalSymbol;
    @Injection(name="GROUP", group="FIELDS")
    private String groupSymbol;
    @Injection(name="REPEAT", group="FIELDS")
    private boolean repeat;

    public ExcelInputField(String fieldname, int position, int length) {
        this.name = fieldname;
        this.length = length;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
    }

    public ExcelInputField() {
        this(null, -1, -1);
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMeta.getTypeDesc((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    @Injection(name="TYPE", group="FIELDS")
    public void setType(String typeDesc) {
        this.type = ValueMeta.getType((String)typeDesc);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return ExcelInputMeta.getTrimTypeCode(this.trimtype);
    }

    public String getTrimTypeDesc() {
        return ExcelInputMeta.getTrimTypeDesc(this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    @Injection(name="TRIM_TYPE", group="FIELDS")
    public void setTrimType(String trimType) {
        this.trimtype = ValueMetaBase.getTrimTypeByCode((String)trimType);
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public String toString() {
        return this.name + ":" + this.getTypeDesc() + "(" + this.length + "," + this.precision + ")";
    }
}

