/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getfilenames;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getfilenames.GetFileNamesData;
import org.pentaho.di.trans.steps.getfilenames.GetFileNamesMeta;

public class GetFileNames
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GetFileNamesMeta.class;
    private GetFileNamesMeta meta;
    private GetFileNamesData data;

    public GetFileNames(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block26: {
            if (!this.meta.isFileField()) {
                if (this.data.filenr >= this.data.filessize) {
                    this.setOutputDone();
                    return false;
                }
            } else {
                if (this.data.filenr >= this.data.filessize) {
                    this.data.readrow = this.getRow();
                }
                if (this.data.readrow == null) {
                    this.setOutputDone();
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    if (Const.isEmpty((String)this.meta.getDynamicFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfFilenameField < 0) {
                        this.data.indexOfFilenameField = this.data.inputRowMeta.indexOfValue(this.meta.getDynamicFilenameField());
                        if (this.data.indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetFileNames.Log.ErrorFindingField", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"GetFileNames.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                        }
                    }
                    if (!Const.isEmpty((String)this.meta.getDynamicWildcardField()) && this.data.indexOfWildcardField < 0) {
                        this.data.indexOfWildcardField = this.data.inputRowMeta.indexOfValue(this.meta.getDynamicWildcardField());
                        if (this.data.indexOfWildcardField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetFileNames.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getDynamicWildcardField() + "]");
                            throw new KettleException(BaseMessages.getString(PKG, (String)"GetFileNames.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicWildcardField()}));
                        }
                    }
                    if (!Const.isEmpty((String)this.meta.getDynamicExcludeWildcardField()) && this.data.indexOfExcludeWildcardField < 0) {
                        this.data.indexOfExcludeWildcardField = this.data.inputRowMeta.indexOfValue(this.meta.getDynamicExcludeWildcardField());
                        if (this.data.indexOfExcludeWildcardField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetFileNames.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getDynamicExcludeWildcardField() + "]");
                            throw new KettleException(BaseMessages.getString(PKG, (String)"GetFileNames.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicExcludeWildcardField()}));
                        }
                    }
                }
            }
            try {
                Object[] outputRow = this.buildEmptyRow();
                int outputIndex = 0;
                Object[] extraData = new Object[this.data.nrStepFields];
                if (this.meta.isFileField()) {
                    if (this.data.filenr >= this.data.filessize) {
                        String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFilenameField);
                        String wildcard = "";
                        if (this.data.indexOfWildcardField >= 0) {
                            wildcard = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfWildcardField);
                        }
                        String excludewildcard = "";
                        if (this.data.indexOfExcludeWildcardField >= 0) {
                            excludewildcard = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfExcludeWildcardField);
                        }
                        String[] filesname = new String[]{filename};
                        String[] filesmask = new String[]{wildcard};
                        String[] excludefilesmask = new String[]{excludewildcard};
                        String[] filesrequired = new String[]{"N"};
                        boolean[] includesubfolders = new boolean[]{this.meta.isDynamicIncludeSubFolders()};
                        this.data.files = this.meta.getDynamicFileList(this, filesname, filesmask, excludefilesmask, filesrequired, includesubfolders);
                        this.data.filessize = this.data.files.nrOfFiles();
                        this.data.filenr = 0;
                    }
                    outputRow = (Object[])this.data.readrow.clone();
                }
                if (this.data.filessize <= 0) break block26;
                this.data.file = this.data.files.getFile(this.data.filenr);
                if (this.meta.isAddResultFile()) {
                    ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                    resultFile.setComment(BaseMessages.getString(PKG, (String)"GetFileNames.Log.FileReadByStep", (String[])new String[0]));
                    this.addResultFile(resultFile);
                }
                extraData[outputIndex++] = KettleVFS.getFilename((FileObject)this.data.file);
                extraData[outputIndex++] = this.data.file.getName().getBaseName();
                try {
                    extraData[outputIndex++] = KettleVFS.getFilename((FileObject)this.data.file.getParent());
                    extraData[outputIndex++] = this.data.file.getType().toString();
                    extraData[outputIndex++] = this.data.file.exists();
                    extraData[outputIndex++] = this.data.file.isHidden();
                    extraData[outputIndex++] = this.data.file.isReadable();
                    extraData[outputIndex++] = this.data.file.isWriteable();
                    extraData[outputIndex++] = new Date(this.data.file.getContent().getLastModifiedTime());
                    Long size = null;
                    if (this.data.file.getType().equals((Object)FileType.FILE)) {
                        size = new Long(this.data.file.getContent().getSize());
                    }
                    extraData[outputIndex++] = size;
                }
                catch (IOException e) {
                    throw new KettleException((Throwable)e);
                }
                extraData[outputIndex++] = this.data.file.getName().getExtension();
                extraData[outputIndex++] = this.data.file.getName().getURI();
                extraData[outputIndex++] = this.data.file.getName().getRootURI();
                if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                    extraData[outputIndex++] = new Long(this.data.rownr);
                }
                ++this.data.rownr;
                outputRow = RowDataUtil.addRowData((Object[])outputRow, (int)this.data.totalpreviousfields, (Object[])extraData);
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.meta.getRowLimit() > 0L && this.data.rownr >= this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        ++this.data.filenr;
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NrLine", (String[])new String[]{"" + this.getLinesInput()}));
        }
        return true;
    }

    private void handleMissingFiles() throws KettleException {
        if (this.meta.isdoNotFailIfNoFile() && this.data.files.nrOfFiles() == 0) {
            this.logBasic(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoFile", (String[])new String[0]));
            return;
        }
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logBasic("ERROR: Missing " + message);
            throw new KettleException("Following required files are missing: " + message);
        }
        List nonAccessibleFiles = this.data.files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logBasic("WARNING: Not accessible " + message);
            throw new KettleException("Following required files are not accessible: " + message);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetFileNamesMeta)smi;
        this.data = (GetFileNamesData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.nrStepFields = this.data.outputRowMeta.size();
                if (!this.meta.isFileField()) {
                    this.data.files = this.meta.getFileList(this);
                    this.data.filessize = this.data.files.nrOfFiles();
                    this.handleMissingFiles();
                } else {
                    this.data.filessize = 0;
                }
            }
            catch (Exception e) {
                this.logError("Error initializing step: " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                return false;
            }
            this.data.rownr = 1L;
            this.data.filenr = 0;
            this.data.totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetFileNamesMeta)smi;
        this.data = (GetFileNamesData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
                this.data.file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }
}

