/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getrepositorynames;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getrepositorynames.GetRepositoryNamesData;
import org.pentaho.di.trans.steps.getrepositorynames.GetRepositoryNamesMeta;

public class GetRepositoryNames
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GetRepositoryNamesMeta.class;
    private GetRepositoryNamesMeta meta;
    private GetRepositoryNamesData data;

    public GetRepositoryNames(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
        }
        if (this.data.filenr >= this.data.list.size()) {
            this.setOutputDone();
            return false;
        }
        RepositoryElementMetaInterface repositoryObject = this.data.list.get(this.data.filenr++);
        Object[] outputRow = this.buildEmptyRow();
        int outputIndex = 0;
        String directory = repositoryObject.getRepositoryDirectory().getPath();
        String name = repositoryObject.getName();
        String path = directory.endsWith("/") ? directory + name : directory + "/" + name;
        outputRow[outputIndex++] = path;
        outputRow[outputIndex++] = directory;
        outputRow[outputIndex++] = name;
        outputRow[outputIndex++] = repositoryObject.getObjectType().getTypeDescription();
        outputRow[outputIndex++] = repositoryObject.getObjectId().toString();
        outputRow[outputIndex++] = repositoryObject.getModifiedUser();
        outputRow[outputIndex++] = repositoryObject.getModifiedDate();
        outputRow[outputIndex++] = repositoryObject.getDescription();
        if (this.meta.isIncludeRowNumber()) {
            outputRow[outputIndex++] = this.data.rownr++;
        }
        this.putRow(this.data.outputRowMeta, outputRow);
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"GetRepositoryNames.Log.NrLine", (String[])new String[]{"" + this.getLinesInput()}));
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetRepositoryNamesMeta)smi;
        this.data = (GetRepositoryNamesData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.list = this.getRepositoryObjects();
            }
            catch (Exception e) {
                this.logError("Error initializing step: ", e);
                return false;
            }
            this.data.rownr = 1L;
            this.data.filenr = 0;
            return true;
        }
        return false;
    }

    private List<RepositoryElementMetaInterface> getRepositoryObjects() throws KettleException {
        try {
            Repository repository = this.getTransMeta().getRepository();
            RepositoryDirectoryInterface tree = repository.loadRepositoryDirectoryTree();
            ArrayList<RepositoryElementMetaInterface> list = new ArrayList<RepositoryElementMetaInterface>();
            for (int i = 0; i < this.meta.getDirectory().length; ++i) {
                RepositoryDirectoryInterface dir = tree.findDirectory(this.environmentSubstitute(this.meta.getDirectory()[i]));
                if (dir == null) continue;
                List<RepositoryElementMetaInterface> objects = this.getRepositoryObjects(repository, dir, this.meta.getIncludeSubFolders()[i], this.environmentSubstitute(this.meta.getNameMask()[i]), this.environmentSubstitute(this.meta.getExcludeNameMask()[i]));
                list.addAll(objects);
            }
            return list;
        }
        catch (Exception e) {
            throw new KettleException("Unable to get the list of repository objects from the repository", (Throwable)e);
        }
    }

    private List<RepositoryElementMetaInterface> getRepositoryObjects(Repository repository, RepositoryDirectoryInterface directory, boolean subdirs, String nameMask, String excludeNameMask) throws KettleException {
        ArrayList<RepositoryElementMetaInterface> list = new ArrayList<RepositoryElementMetaInterface>();
        ArrayList<RepositoryElementMetaInterface> objects = new ArrayList<RepositoryElementMetaInterface>();
        if (this.meta.getObjectTypeSelection().areTransformationsSelected()) {
            objects.addAll(repository.getTransformationObjects(directory.getObjectId(), false));
        }
        if (this.meta.getObjectTypeSelection().areJobsSelected()) {
            objects.addAll(repository.getJobObjects(directory.getObjectId(), false));
        }
        for (RepositoryElementMetaInterface object : objects) {
            boolean add = false;
            if (Const.isEmpty((String)nameMask) || object.getName().matches(nameMask)) {
                add = true;
            }
            if (!Const.isEmpty((String)excludeNameMask) && object.getName().matches(excludeNameMask)) {
                add = false;
            }
            if (!add) continue;
            list.add(object);
        }
        if (subdirs) {
            for (RepositoryDirectoryInterface child : directory.getChildren()) {
                list.addAll(this.getRepositoryObjects(repository, child, subdirs, nameMask, excludeNameMask));
            }
        }
        return list;
    }
}

