/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.groupby;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.math.stat.descriptive.rank.Percentile;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.groupby.GroupByData;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;

public class GroupBy
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GroupByMeta.class;
    private GroupByMeta meta = (GroupByMeta)this.getStepMeta().getStepMetaInterface();
    private GroupByData data;
    private boolean allNullsAreZero = false;
    private boolean minNullIsValued = false;

    public GroupBy(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (GroupByData)stepDataInterface;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GroupByMeta)smi;
        this.data = (GroupByData)sdi;
        Object[] r = this.getRow();
        if (this.first) {
            int i;
            String val = this.getVariable("KETTLE_AGGREGATION_ALL_NULLS_ARE_ZERO", "N");
            this.allNullsAreZero = ValueMetaBase.convertStringToBoolean((String)val);
            val = this.getVariable("KETTLE_AGGREGATION_MIN_NULL_IS_VALUED", "N");
            this.minNullIsValued = ValueMetaBase.convertStringToBoolean((String)val);
            this.data.inputRowMeta = this.getInputRowMeta();
            if (this.data.inputRowMeta == null) {
                this.data.inputRowMeta = this.getTransMeta().getPrevStepFields(this.getStepMeta());
            }
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.counts = new long[this.meta.getSubjectField().length];
            this.data.subjectnrs = new int[this.meta.getSubjectField().length];
            this.data.cumulativeSumSourceIndexes = new ArrayList<Integer>();
            this.data.cumulativeSumTargetIndexes = new ArrayList<Integer>();
            this.data.cumulativeAvgSourceIndexes = new ArrayList<Integer>();
            this.data.cumulativeAvgTargetIndexes = new ArrayList<Integer>();
            for (i = 0; i < this.meta.getSubjectField().length; ++i) {
                this.data.subjectnrs[i] = this.meta.getAggregateType()[i] == 18 ? 0 : this.data.inputRowMeta.indexOfValue(this.meta.getSubjectField()[i]);
                if (r != null && this.data.subjectnrs[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"GroupBy.Log.AggregateSubjectFieldCouldNotFound", (String[])new String[]{this.meta.getSubjectField()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (this.meta.getAggregateType()[i] == 13) {
                    this.data.cumulativeSumSourceIndexes.add(this.data.subjectnrs[i]);
                    this.data.cumulativeSumTargetIndexes.add(this.data.inputRowMeta.size() + i);
                }
                if (this.meta.getAggregateType()[i] != 14) continue;
                this.data.cumulativeAvgSourceIndexes.add(this.data.subjectnrs[i]);
                this.data.cumulativeAvgTargetIndexes.add(this.data.inputRowMeta.size() + i);
            }
            this.data.previousSums = new Object[this.data.cumulativeSumTargetIndexes.size()];
            this.data.previousAvgSum = new Object[this.data.cumulativeAvgTargetIndexes.size()];
            this.data.previousAvgCount = new long[this.data.cumulativeAvgTargetIndexes.size()];
            this.data.groupnrs = new int[this.meta.getGroupField().length];
            for (i = 0; i < this.meta.getGroupField().length; ++i) {
                this.data.groupnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getGroupField()[i]);
                if (r == null || this.data.groupnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"GroupBy.Log.GroupFieldCouldNotFound", (String[])new String[]{this.meta.getGroupField()[i]}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.valueMetaInteger = new ValueMetaInteger("count");
            this.data.valueMetaNumber = new ValueMetaNumber("sum");
            this.initGroupMeta(this.data.inputRowMeta);
        }
        if (this.first || this.data.newBatch) {
            this.newAggregate(r);
        }
        if (this.first) {
            this.data.groupAggMeta = new RowMeta();
            this.data.groupAggMeta.addRowMeta(this.data.groupMeta);
            this.data.groupAggMeta.addRowMeta(this.data.aggMeta);
        }
        if (r == null) {
            this.handleLastOfGroup();
            this.setOutputDone();
            return false;
        }
        if (this.first || this.data.newBatch) {
            this.first = false;
            this.data.newBatch = false;
            this.data.previous = this.data.inputRowMeta.cloneRow(r);
        } else {
            this.calcAggregate(this.data.previous);
            if (this.meta.passAllRows()) {
                this.addToBuffer(this.data.previous);
            }
        }
        if (!this.sameGroup(this.data.previous, r)) {
            if (this.meta.passAllRows()) {
                this.closeOutput();
                this.data.groupResult = this.getAggregateResult();
                Object[] row = this.getRowFromBuffer();
                long lineNr = 0L;
                while (row != null) {
                    int size = this.data.inputRowMeta.size();
                    row = RowDataUtil.addRowData((Object[])row, (int)size, (Object[])this.data.groupResult);
                    size += this.data.groupResult.length;
                    ++lineNr;
                    if (this.meta.isAddingLineNrInGroup() && !Const.isEmpty((String)this.meta.getLineNrInGroupField())) {
                        Long lineNrValue = new Long(lineNr);
                        row = RowDataUtil.addValueData((Object[])row, (int)size, (Object)lineNrValue);
                        ++size;
                    }
                    this.addCumulativeSums(row);
                    this.addCumulativeAverages(row);
                    this.putRow(this.data.outputRowMeta, row);
                    row = this.getRowFromBuffer();
                }
                this.closeInput();
            } else {
                Object[] result = this.buildResult(this.data.previous);
                if (result != null) {
                    this.putRow(this.data.groupAggMeta, result);
                }
            }
            this.newAggregate(r);
        }
        this.data.previous = this.data.inputRowMeta.cloneRow(r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"GroupBy.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private void handleLastOfGroup() throws KettleException {
        if (this.meta.passAllRows()) {
            if (this.data.previous != null) {
                this.calcAggregate(this.data.previous);
                this.addToBuffer(this.data.previous);
            }
            this.data.groupResult = this.getAggregateResult();
            Object[] row = this.getRowFromBuffer();
            long lineNr = 0L;
            while (row != null) {
                int size = this.data.inputRowMeta.size();
                row = RowDataUtil.addRowData((Object[])row, (int)size, (Object[])this.data.groupResult);
                size += this.data.groupResult.length;
                ++lineNr;
                if (this.meta.isAddingLineNrInGroup() && !Const.isEmpty((String)this.meta.getLineNrInGroupField())) {
                    Long lineNrValue = new Long(lineNr);
                    row = RowDataUtil.addValueData((Object[])row, (int)size, (Object)lineNrValue);
                    ++size;
                }
                this.addCumulativeSums(row);
                this.addCumulativeAverages(row);
                this.putRow(this.data.outputRowMeta, row);
                row = this.getRowFromBuffer();
            }
            this.closeInput();
        } else {
            Object[] result;
            if (this.data.previous != null) {
                this.calcAggregate(this.data.previous);
            }
            if ((result = this.buildResult(this.data.previous)) != null) {
                this.putRow(this.data.groupAggMeta, result);
            }
        }
    }

    private void addCumulativeSums(Object[] row) throws KettleValueException {
        for (int i = 0; i < this.data.cumulativeSumSourceIndexes.size(); ++i) {
            int sourceIndex = this.data.cumulativeSumSourceIndexes.get(i);
            Object previousTarget = this.data.previousSums[i];
            Object sourceValue = row[sourceIndex];
            int targetIndex = this.data.cumulativeSumTargetIndexes.get(i);
            ValueMetaInterface sourceMeta = this.data.inputRowMeta.getValueMeta(sourceIndex);
            ValueMetaInterface targetMeta = this.data.outputRowMeta.getValueMeta(targetIndex);
            row[targetIndex] = targetMeta.isNull(previousTarget) ? sourceMeta.convertToNormalStorageType(sourceValue) : (sourceMeta.isNull(sourceValue) ? previousTarget : ValueDataUtil.plus((ValueMetaInterface)targetMeta, (Object)this.data.previousSums[i], (ValueMetaInterface)sourceMeta, (Object)row[sourceIndex]));
            this.data.previousSums[i] = row[targetIndex];
        }
    }

    private void addCumulativeAverages(Object[] row) throws KettleValueException {
        for (int i = 0; i < this.data.cumulativeAvgSourceIndexes.size(); ++i) {
            int sourceIndex = this.data.cumulativeAvgSourceIndexes.get(i);
            Object previousTarget = this.data.previousAvgSum[i];
            Object sourceValue = row[sourceIndex];
            int targetIndex = this.data.cumulativeAvgTargetIndexes.get(i);
            ValueMetaInterface sourceMeta = this.data.inputRowMeta.getValueMeta(sourceIndex);
            ValueMetaInterface targetMeta = this.data.outputRowMeta.getValueMeta(targetIndex);
            Object sum = null;
            sum = targetMeta.isNull(previousTarget) ? sourceMeta.convertToNormalStorageType(sourceValue) : (sourceMeta.isNull(sourceValue) ? previousTarget : (sourceMeta.isInteger() ? ValueDataUtil.plus((ValueMetaInterface)this.data.valueMetaInteger, (Object)this.data.previousAvgSum[i], (ValueMetaInterface)sourceMeta, (Object)row[sourceIndex]) : ValueDataUtil.plus((ValueMetaInterface)targetMeta, (Object)this.data.previousAvgSum[i], (ValueMetaInterface)sourceMeta, (Object)row[sourceIndex])));
            this.data.previousAvgSum[i] = sum;
            if (!sourceMeta.isNull(sourceValue)) {
                int n = i;
                this.data.previousAvgCount[n] = this.data.previousAvgCount[n] + 1L;
            }
            if (sourceMeta.isInteger()) {
                if (sum == null) {
                    row[targetIndex] = null;
                    continue;
                }
                row[targetIndex] = new Double(((Long)sum).doubleValue() / (double)this.data.previousAvgCount[i]);
                continue;
            }
            row[targetIndex] = ValueDataUtil.divide((ValueMetaInterface)targetMeta, (Object)sum, (ValueMetaInterface)this.data.valueMetaInteger, (Object)this.data.previousAvgCount[i]);
        }
    }

    boolean sameGroup(Object[] previous, Object[] r) throws KettleValueException {
        return this.data.inputRowMeta.compare(previous, r, this.data.groupnrs) == 0;
    }

    void calcAggregate(Object[] row) throws KettleValueException {
        block17: for (int i = 0; i < this.data.subjectnrs.length; ++i) {
            Object subj = row[this.data.subjectnrs[i]];
            ValueMetaInterface subjMeta = this.data.inputRowMeta.getValueMeta(this.data.subjectnrs[i]);
            Object value = this.data.agg[i];
            ValueMetaInterface valueMeta = this.data.aggMeta.getValueMeta(i);
            switch (this.meta.getAggregateType()[i]) {
                case 1: {
                    this.data.agg[i] = ValueDataUtil.sum((ValueMetaInterface)valueMeta, (Object)value, (ValueMetaInterface)subjMeta, (Object)subj);
                    continue block17;
                }
                case 2: {
                    if (subjMeta.isNull(subj)) continue block17;
                    this.data.agg[i] = ValueDataUtil.sum((ValueMetaInterface)valueMeta, (Object)value, (ValueMetaInterface)subjMeta, (Object)subj);
                    int n = i;
                    this.data.counts[n] = this.data.counts[n] + 1L;
                    continue block17;
                }
                case 3: 
                case 4: {
                    if (subjMeta.isNull(subj)) continue block17;
                    ((List)this.data.agg[i]).add(subjMeta.getNumber(subj));
                    continue block17;
                }
                case 15: {
                    if (subjMeta.isNull(subj)) continue block17;
                    int n = i;
                    this.data.counts[n] = this.data.counts[n] + 1L;
                    double n2 = this.data.counts[i];
                    double x = subjMeta.getNumber(subj);
                    double sum = value == null ? new Double(0.0) : (Double)value;
                    double mean = this.data.mean[i];
                    double delta = x - mean;
                    this.data.mean[i] = mean;
                    this.data.agg[i] = sum += delta * (x - (mean += delta / n2));
                    continue block17;
                }
                case 17: {
                    Object obj;
                    if (subjMeta.isNull(subj)) continue block17;
                    if (this.data.distinctObjs == null) {
                        this.data.distinctObjs = new Set[this.meta.getSubjectField().length];
                    }
                    if (this.data.distinctObjs[i] == null) {
                        this.data.distinctObjs[i] = new TreeSet<Object>();
                    }
                    if (this.data.distinctObjs[i].contains(obj = subjMeta.convertToNormalStorageType(subj))) continue block17;
                    this.data.distinctObjs[i].add(obj);
                    value = value == null ? new Long(0L) : value;
                    this.data.agg[i] = (Long)value + 1L;
                    continue block17;
                }
                case 7: {
                    if (subjMeta.isNull(subj)) continue block17;
                    int n = i;
                    this.data.counts[n] = this.data.counts[n] + 1L;
                    continue block17;
                }
                case 18: {
                    int n = i;
                    this.data.counts[n] = this.data.counts[n] + 1L;
                    continue block17;
                }
                case 5: {
                    if (subj == null && !this.minNullIsValued) continue block17;
                    if (subjMeta.isSortedDescending()) {
                        if (subjMeta.compare(value, valueMeta, subj) >= 0) continue block17;
                        this.data.agg[i] = subj;
                        continue block17;
                    }
                    if (subjMeta.compare(subj, valueMeta, value) >= 0) continue block17;
                    this.data.agg[i] = subj;
                    continue block17;
                }
                case 6: {
                    if (subjMeta.isSortedDescending()) {
                        if (subjMeta.compare(value, valueMeta, subj) <= 0) continue block17;
                        this.data.agg[i] = subj;
                        continue block17;
                    }
                    if (subjMeta.compare(subj, valueMeta, value) <= 0) continue block17;
                    this.data.agg[i] = subj;
                    continue block17;
                }
                case 9: {
                    if (subj == null || value != null) continue block17;
                    this.data.agg[i] = subj;
                    continue block17;
                }
                case 10: {
                    if (subj == null) continue block17;
                    this.data.agg[i] = subj;
                    continue block17;
                }
                case 11: {
                    continue block17;
                }
                case 12: {
                    this.data.agg[i] = subj;
                    continue block17;
                }
                case 8: {
                    if (subj == null) continue block17;
                    StringBuilder sb = (StringBuilder)value;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block17;
                }
                case 16: {
                    StringBuilder sb;
                    if (subj == null) continue block17;
                    String separator = "";
                    if (!Const.isEmpty((String)this.meta.getValueField()[i])) {
                        separator = this.environmentSubstitute(this.meta.getValueField()[i]);
                    }
                    if ((sb = (StringBuilder)value).length() > 0) {
                        sb.append(separator);
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block17;
                }
            }
        }
    }

    void newAggregate(Object[] r) {
        int i;
        for (i = 0; i < this.data.counts.length; ++i) {
            this.data.counts[i] = 0L;
        }
        this.data.distinctObjs = null;
        this.data.agg = new Object[this.data.subjectnrs.length];
        this.data.mean = new double[this.data.subjectnrs.length];
        this.data.aggMeta = new RowMeta();
        for (i = 0; i < this.data.subjectnrs.length; ++i) {
            ValueMetaInterface subjMeta = this.data.inputRowMeta.getValueMeta(this.data.subjectnrs[i]);
            Serializable v = null;
            ValueMetaInterface vMeta = null;
            int aggType = this.meta.getAggregateType()[i];
            switch (aggType) {
                case 1: 
                case 2: 
                case 13: 
                case 14: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], subjMeta.isNumeric() ? subjMeta.getType() : 1);
                    break;
                }
                case 3: 
                case 4: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 1);
                    v = new ArrayList();
                    break;
                }
                case 15: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 1);
                    break;
                }
                case 7: 
                case 17: 
                case 18: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 5);
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    vMeta = subjMeta.clone();
                    vMeta.setName(this.meta.getAggregateField()[i]);
                    v = r == null ? null : r[this.data.subjectnrs[i]];
                    break;
                }
                case 8: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 2);
                    v = new StringBuilder();
                    break;
                }
                case 16: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 2);
                    v = new StringBuilder();
                    break;
                }
            }
            if (subjMeta != null && aggType != 7 && aggType != 17 && aggType != 18) {
                vMeta.setLength(subjMeta.getLength(), subjMeta.getPrecision());
            }
            this.data.agg[i] = v;
            this.data.aggMeta.addValueMeta(vMeta);
        }
        for (i = 0; i < this.data.previousSums.length; ++i) {
            this.data.previousSums[i] = null;
        }
        for (i = 0; i < this.data.previousAvgCount.length; ++i) {
            this.data.previousAvgCount[i] = 0L;
            this.data.previousAvgSum[i] = null;
        }
    }

    private Object[] buildResult(Object[] r) throws KettleValueException {
        Object[] result = null;
        if (r != null || this.meta.isAlwaysGivingBackOneRow()) {
            result = RowDataUtil.allocateRowData((int)this.data.groupnrs.length);
            if (r != null) {
                for (int i = 0; i < this.data.groupnrs.length; ++i) {
                    result[i] = r[this.data.groupnrs[i]];
                }
            }
            result = RowDataUtil.addRowData((Object[])result, (int)this.data.groupnrs.length, (Object[])this.getAggregateResult());
        }
        return result;
    }

    private void initGroupMeta(RowMetaInterface previousRowMeta) throws KettleValueException {
        this.data.groupMeta = new RowMeta();
        for (int i = 0; i < this.data.groupnrs.length; ++i) {
            this.data.groupMeta.addValueMeta(previousRowMeta.getValueMeta(this.data.groupnrs[i]));
        }
    }

    Object[] getAggregateResult() throws KettleValueException {
        if (this.data.subjectnrs == null) {
            return new Object[0];
        }
        Object[] result = new Object[this.data.subjectnrs.length];
        for (int i = 0; i < this.data.subjectnrs.length; ++i) {
            Object ag = this.data.agg[i];
            switch (this.meta.getAggregateType()[i]) {
                case 1: {
                    break;
                }
                case 2: {
                    ag = ValueDataUtil.divide((ValueMetaInterface)this.data.aggMeta.getValueMeta(i), (Object)ag, (ValueMetaInterface)new ValueMeta("c", 5), (Object)new Long(this.data.counts[i]));
                    break;
                }
                case 3: 
                case 4: {
                    double percentile = 50.0;
                    if (this.meta.getAggregateType()[i] == 4) {
                        percentile = Double.parseDouble(this.meta.getValueField()[i]);
                    }
                    List valuesList = (List)this.data.agg[i];
                    double[] values = new double[valuesList.size()];
                    for (int v = 0; v < values.length; ++v) {
                        values[v] = (Double)valuesList.get(v);
                    }
                    ag = new Percentile().evaluate(values, percentile);
                    break;
                }
                case 7: 
                case 18: {
                    ag = new Long(this.data.counts[i]);
                    break;
                }
                case 17: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 15: {
                    double sum = (Double)ag / (double)this.data.counts[i];
                    ag = Math.sqrt(sum);
                    break;
                }
                case 8: 
                case 16: {
                    ag = ((StringBuilder)ag).toString();
                    break;
                }
            }
            if (ag == null && this.allNullsAreZero) {
                ValueMetaInterface vm = this.data.aggMeta.getValueMeta(i);
                ag = ValueDataUtil.getZeroForValueMetaType((ValueMetaInterface)vm);
            }
            result[i] = ag;
        }
        return result;
    }

    void addToBuffer(Object[] row) throws KettleFileException {
        this.data.bufferList.add(row);
        if (this.data.bufferList.size() > 5000 && this.data.rowsOnFile == 0) {
            String pathToTmp = this.environmentSubstitute(this.getMeta().getDirectory());
            try {
                File ioFile = new File(pathToTmp);
                if (!ioFile.exists()) {
                    pathToTmp = this.retrieveVfsPath(pathToTmp);
                }
                this.data.tempFile = File.createTempFile(this.getMeta().getPrefix(), ".tmp", new File(pathToTmp));
                this.data.fosToTempFile = new FileOutputStream(this.data.tempFile);
                this.data.dosToTempFile = new DataOutputStream(this.data.fosToTempFile);
                this.data.firstRead = true;
            }
            catch (IOException e) {
                throw new KettleFileException(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToCreateTemporaryFile", (String[])new String[0]), (Throwable)e);
            }
            Object[] oldest = this.data.bufferList.get(0);
            this.data.inputRowMeta.writeData(this.data.dosToTempFile, oldest);
            this.data.bufferList.remove(0);
            ++this.data.rowsOnFile;
        }
    }

    String retrieveVfsPath(String pathToTmp) throws KettleFileException {
        FileObject vfsFile = KettleVFS.getFileObject((String)pathToTmp);
        String path = vfsFile.getName().getPath();
        return path;
    }

    private Object[] getRowFromBuffer() throws KettleFileException {
        if (this.data.rowsOnFile > 0) {
            Object[] row;
            if (this.data.firstRead) {
                try {
                    this.data.fisToTmpFile = new FileInputStream(this.data.tempFile);
                    this.data.disToTmpFile = new DataInputStream(this.data.fisToTmpFile);
                    this.data.firstRead = false;
                }
                catch (IOException e) {
                    throw new KettleFileException(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToReadBackRowFromTemporaryFile", (String[])new String[0]), (Throwable)e);
                }
            }
            try {
                row = this.data.inputRowMeta.readData(this.data.disToTmpFile);
            }
            catch (SocketTimeoutException e) {
                throw new KettleFileException((Throwable)e);
            }
            --this.data.rowsOnFile;
            return row;
        }
        if (this.data.bufferList.size() > 0) {
            Object[] row = this.data.bufferList.get(0);
            this.data.bufferList.remove(0);
            return row;
        }
        return null;
    }

    private void closeOutput() throws KettleFileException {
        try {
            if (this.data.dosToTempFile != null) {
                this.data.dosToTempFile.close();
                this.data.dosToTempFile = null;
            }
            if (this.data.fosToTempFile != null) {
                this.data.fosToTempFile.close();
                this.data.fosToTempFile = null;
            }
            this.data.firstRead = true;
        }
        catch (IOException e) {
            throw new KettleFileException(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToCloseInputStream", (String[])new String[]{this.data.tempFile.getPath()}), (Throwable)e);
        }
    }

    private void closeInput() throws KettleFileException {
        try {
            if (this.data.fisToTmpFile != null) {
                this.data.fisToTmpFile.close();
                this.data.fisToTmpFile = null;
            }
            if (this.data.disToTmpFile != null) {
                this.data.disToTmpFile.close();
                this.data.disToTmpFile = null;
            }
        }
        catch (IOException e) {
            throw new KettleFileException(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToCloseInputStream", (String[])new String[]{this.data.tempFile.getPath()}), (Throwable)e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GroupByMeta)smi;
        this.data = (GroupByData)sdi;
        if (super.init(smi, sdi)) {
            this.data.bufferList = new ArrayList();
            this.data.rowsOnFile = 0;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.tempFile != null) {
            try {
                this.closeInput();
                this.closeOutput();
            }
            catch (KettleFileException e) {
                this.log.logError(e.getLocalizedMessage());
            }
            boolean tempFileDeleted = this.data.tempFile.delete();
            if (!tempFileDeleted && this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToDeleteTemporaryFile", (String[])new String[]{this.data.tempFile.getPath()}));
            }
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void batchComplete() throws KettleException {
        this.handleLastOfGroup();
        this.data.newBatch = true;
    }

    void setAllNullsAreZero(boolean allNullsAreZero) {
        this.allNullsAreZero = allNullsAreZero;
    }

    void setMinNullIsValued(boolean minNullIsValued) {
        this.minNullIsValued = minNullIsValued;
    }

    public GroupByMeta getMeta() {
        return this.meta;
    }
}

