/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.httppost;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTData;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTMeta;

public class HTTPPOST
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = HTTPPOSTMeta.class;
    private static final String CONTENT_TYPE = "Content-type";
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private HTTPPOSTMeta meta;
    private HTTPPOSTData data;

    public HTTPPOST(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] callHTTPPOST(Object[] rowData) throws KettleException {
        Object[] objectArray;
        block51: {
            if (this.meta.isUrlInField()) {
                this.data.realUrl = this.data.inputRowMeta.getString(rowData, this.data.indexOfUrlField);
            }
            FileInputStream fis = null;
            try {
                int i;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ConnectingToURL", (String[])new String[]{this.data.realUrl}));
                }
                HttpClient HTTPPOSTclient = SlaveConnectionManager.getInstance().createHttpClient();
                PostMethod post = new PostMethod(this.data.realUrl);
                if (this.data.realConnectionTimeout > -1) {
                    HTTPPOSTclient.getHttpConnectionManager().getParams().setConnectionTimeout(this.data.realConnectionTimeout);
                }
                if (this.data.realSocketTimeout > -1) {
                    HTTPPOSTclient.getHttpConnectionManager().getParams().setSoTimeout(this.data.realSocketTimeout);
                }
                if (!Const.isEmpty((String)this.data.realHttpLogin)) {
                    HTTPPOSTclient.getParams().setAuthenticationPreemptive(true);
                    UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.data.realHttpLogin, this.data.realHttpPassword);
                    HTTPPOSTclient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
                }
                HostConfiguration hostConfiguration = new HostConfiguration();
                if (!Const.isEmpty((String)this.data.realProxyHost)) {
                    hostConfiguration.setProxy(this.data.realProxyHost, this.data.realProxyPort);
                }
                if (!this.data.contentTypeHeaderOverwrite) {
                    if (Const.isEmpty((String)this.data.realEncoding)) {
                        post.setRequestHeader(CONTENT_TYPE, CONTENT_TYPE_TEXT_XML);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.HeaderValue", (String[])new String[]{CONTENT_TYPE, CONTENT_TYPE_TEXT_XML}));
                        }
                    } else {
                        post.setRequestHeader(CONTENT_TYPE, "text/xml; " + this.data.realEncoding);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.HeaderValue", (String[])new String[]{CONTENT_TYPE, "text/xml; " + this.data.realEncoding}));
                        }
                    }
                }
                if (this.data.useHeaderParameters) {
                    for (i = 0; i < this.data.header_parameters_nrs.length; ++i) {
                        post.addRequestHeader(this.data.headerParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.header_parameters_nrs[i]));
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.HeaderValue", (String[])new String[]{this.data.headerParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.header_parameters_nrs[i])}));
                    }
                }
                if (this.data.useBodyParameters) {
                    for (i = 0; i < this.data.body_parameters_nrs.length; ++i) {
                        this.data.bodyParameters[i].setValue(this.data.inputRowMeta.getString(rowData, this.data.body_parameters_nrs[i]));
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.BodyValue", (String[])new String[]{this.data.bodyParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.body_parameters_nrs[i])}));
                    }
                    String bodyParams = this.getRequestBodyParamsAsStr(this.data.bodyParameters, this.data.realEncoding);
                    post.setRequestEntity((RequestEntity)new StringRequestEntity(bodyParams, CONTENT_TYPE_TEXT_XML, "US-ASCII"));
                }
                if (this.data.useQueryParameters) {
                    for (i = 0; i < this.data.query_parameters_nrs.length; ++i) {
                        this.data.queryParameters[i].setValue(this.data.inputRowMeta.getString(rowData, this.data.query_parameters_nrs[i]));
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.QueryValue", (String[])new String[]{this.data.queryParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.query_parameters_nrs[i])}));
                    }
                    post.setQueryString(this.data.queryParameters);
                }
                if (this.data.indexOfRequestEntity >= 0) {
                    String tmp = this.data.inputRowMeta.getString(rowData, this.data.indexOfRequestEntity);
                    if (this.meta.isPostAFile()) {
                        File input = new File(tmp);
                        fis = new FileInputStream(input);
                        post.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)fis, input.length()));
                    } else if (this.data.realEncoding != null && this.data.realEncoding.length() > 0) {
                        post.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(tmp.getBytes(this.data.realEncoding)), (long)tmp.length()));
                    } else {
                        post.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(tmp.getBytes()), (long)tmp.length()));
                    }
                }
                InputStreamReader inputStreamReader = null;
                Object[] newRow = null;
                if (rowData != null) {
                    newRow = (Object[])rowData.clone();
                }
                try {
                    long startTime = System.currentTimeMillis();
                    int statusCode = HTTPPOSTclient.executeMethod(hostConfiguration, (HttpMethod)post);
                    long responseTime = System.currentTimeMillis() - startTime;
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ResponseTime", (Object[])new Object[]{responseTime, this.data.realUrl}));
                    }
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ResponseCode", (String[])new String[]{String.valueOf(statusCode)}));
                    }
                    String body = null;
                    if (statusCode != -1) {
                        if (statusCode == 204) {
                            body = "";
                        } else {
                            int c;
                            String contentType;
                            if (statusCode == 401) {
                                throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.Authentication", (String[])new String[]{this.data.realUrl}));
                            }
                            String encoding = this.data.realEncoding;
                            if (Const.isEmpty((String)encoding) && (contentType = post.getResponseHeader("Content-Type").getValue()) != null && contentType.contains("charset")) {
                                encoding = contentType.replaceFirst("^.*;\\s*charset\\s*=\\s*", "").replace("\"", "").trim();
                            }
                            if (Const.isEmpty((String)encoding)) {
                                if (this.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.Encoding", (String[])new String[]{"ISO-8859-1"}));
                                }
                                inputStreamReader = new InputStreamReader(post.getResponseBodyAsStream());
                            } else {
                                if (this.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.Encoding", (String[])new String[]{encoding}));
                                }
                                inputStreamReader = new InputStreamReader(post.getResponseBodyAsStream(), encoding);
                            }
                            StringBuffer bodyBuffer = new StringBuffer();
                            while ((c = inputStreamReader.read()) != -1) {
                                bodyBuffer.append((char)c);
                            }
                            inputStreamReader.close();
                            body = bodyBuffer.toString();
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ResponseBody", (String[])new String[]{body}));
                            }
                        }
                    }
                    int returnFieldsOffset = this.data.inputRowMeta.size();
                    if (!Const.isEmpty((String)this.meta.getFieldName())) {
                        newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                        ++returnFieldsOffset;
                    }
                    if (!Const.isEmpty((String)this.meta.getResultCodeFieldName())) {
                        newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(statusCode));
                        ++returnFieldsOffset;
                    }
                    if (!Const.isEmpty((String)this.meta.getResponseTimeFieldName())) {
                        newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(responseTime));
                    }
                }
                finally {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    post.releaseConnection();
                    if (this.data.realcloseIdleConnectionsTime > -1) {
                        HTTPPOSTclient.getHttpConnectionManager().closeIdleConnections((long)this.data.realcloseIdleConnectionsTime);
                    }
                }
                objectArray = newRow;
                if (fis == null) break block51;
            }
            catch (UnknownHostException uhe) {
                try {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOST.Error.UnknownHostException", (String[])new String[]{uhe.getMessage()}));
                    catch (Exception e) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOST.Error.CanNotReadURL", (String[])new String[]{this.data.realUrl}), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        BaseStep.closeQuietly(fis);
                    }
                    throw throwable;
                }
            }
            BaseStep.closeQuietly(fis);
        }
        return objectArray;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block22: {
            this.meta = (HTTPPOSTMeta)smi;
            this.data = (HTTPPOSTData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int nrQuery;
                int nrargs;
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (this.meta.isUrlInField()) {
                    if (Const.isEmpty((String)this.meta.getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfUrlField < 0) {
                        String realUrlfieldName = this.environmentSubstitute(this.meta.getUrlField());
                        this.data.indexOfUrlField = this.data.inputRowMeta.indexOfValue(realUrlfieldName);
                        if (this.data.indexOfUrlField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                        }
                    }
                } else {
                    this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
                }
                if ((nrargs = this.meta.getArgumentField().length) > 0) {
                    this.data.useBodyParameters = false;
                    this.data.useHeaderParameters = false;
                    this.data.contentTypeHeaderOverwrite = false;
                    int nrheader = 0;
                    int nrbody = 0;
                    for (int i = 0; i < nrargs; ++i) {
                        if (this.meta.getArgumentHeader()[i]) {
                            this.data.useHeaderParameters = true;
                            ++nrheader;
                            continue;
                        }
                        this.data.useBodyParameters = true;
                        ++nrbody;
                    }
                    this.data.header_parameters_nrs = new int[nrheader];
                    this.data.headerParameters = new NameValuePair[nrheader];
                    this.data.body_parameters_nrs = new int[nrbody];
                    this.data.bodyParameters = new NameValuePair[nrbody];
                    int posHeader = 0;
                    int posBody = 0;
                    for (int i = 0; i < nrargs; ++i) {
                        int fieldIndex = this.data.inputRowMeta.indexOfValue(this.meta.getArgumentField()[i]);
                        if (fieldIndex < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ErrorFindingField", (String[])new String[0]) + this.meta.getArgumentField()[i] + "]");
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.CouldnotFindField", (String[])new String[]{this.meta.getArgumentField()[i]}));
                        }
                        if (this.meta.getArgumentHeader()[i]) {
                            this.data.header_parameters_nrs[posHeader] = fieldIndex;
                            this.data.headerParameters[posHeader] = new NameValuePair(this.environmentSubstitute(this.meta.getArgumentParameter()[i]), this.data.outputRowMeta.getString(r, this.data.header_parameters_nrs[posHeader]));
                            ++posHeader;
                            if (!CONTENT_TYPE.equalsIgnoreCase(this.meta.getArgumentParameter()[i])) continue;
                            this.data.contentTypeHeaderOverwrite = true;
                            continue;
                        }
                        this.data.body_parameters_nrs[posBody] = fieldIndex;
                        this.data.bodyParameters[posBody] = new NameValuePair(this.environmentSubstitute(this.meta.getArgumentParameter()[i]), this.data.outputRowMeta.getString(r, this.data.body_parameters_nrs[posBody]));
                        ++posBody;
                    }
                }
                if ((nrQuery = this.meta.getQueryField().length) > 0) {
                    this.data.useQueryParameters = true;
                    this.data.query_parameters_nrs = new int[nrQuery];
                    this.data.queryParameters = new NameValuePair[nrQuery];
                    for (int i = 0; i < nrQuery; ++i) {
                        this.data.query_parameters_nrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getQueryField()[i]);
                        if (this.data.query_parameters_nrs[i] < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ErrorFindingField", (String[])new String[0]) + this.meta.getQueryField()[i] + "]");
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.CouldnotFindField", (String[])new String[]{this.meta.getQueryField()[i]}));
                        }
                        this.data.queryParameters[i] = new NameValuePair(this.environmentSubstitute(this.meta.getQueryParameter()[i]), this.data.outputRowMeta.getString(r, this.data.query_parameters_nrs[i]));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getRequestEntity())) {
                    this.data.indexOfRequestEntity = this.data.inputRowMeta.indexOfValue(this.environmentSubstitute(this.meta.getRequestEntity()));
                    if (this.data.indexOfRequestEntity < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.CouldnotFindRequestEntityField", (String[])new String[]{this.meta.getRequestEntity()}));
                    }
                }
                this.data.realEncoding = this.environmentSubstitute(this.meta.getEncoding());
            }
            try {
                Object[] outputRowData = this.callHTTPPOST(r);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTPPOST.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block22;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "HTTPPOST001");
            }
        }
        return true;
    }

    private String getRequestBodyParamsAsStr(NameValuePair[] pairs, String charset) throws KettleException {
        StringBuffer buf = new StringBuffer();
        try {
            for (int i = 0; i < pairs.length; ++i) {
                NameValuePair pair = pairs[i];
                if (pair.getName() == null) continue;
                if (i > 0) {
                    buf.append("&");
                }
                buf.append(URLEncoder.encode(pair.getName(), charset));
                buf.append("=");
                if (pair.getValue() == null) continue;
                buf.append(URLEncoder.encode(pair.getValue(), charset));
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new KettleException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPPOSTMeta)smi;
        this.data = (HTTPPOSTData)sdi;
        if (super.init(smi, sdi)) {
            this.data.realProxyHost = this.environmentSubstitute(this.meta.getProxyHost());
            this.data.realProxyPort = Const.toInt((String)this.environmentSubstitute(this.meta.getProxyPort()), (int)8080);
            this.data.realHttpLogin = this.environmentSubstitute(this.meta.getHttpLogin());
            this.data.realHttpPassword = Utils.resolvePassword((VariableSpace)this.variables, (String)this.meta.getHttpPassword());
            this.data.realSocketTimeout = Const.toInt((String)this.environmentSubstitute(this.meta.getSocketTimeout()), (int)-1);
            this.data.realConnectionTimeout = Const.toInt((String)this.environmentSubstitute(this.meta.getSocketTimeout()), (int)-1);
            this.data.realcloseIdleConnectionsTime = Const.toInt((String)this.environmentSubstitute(this.meta.getCloseIdleConnectionsTime()), (int)-1);
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPPOSTMeta)smi;
        this.data = (HTTPPOSTData)sdi;
        super.dispose(smi, sdi);
    }
}

