/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadfileinput;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInput;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputData;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class LoadFileInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static final String INCLUDE = "include";
    private static final String INCLUDE_FIELD = "include_field";
    private static final String ROWNUM = "rownum";
    private static final String ADDRESULTFILE = "addresultfile";
    private static final String IS_IGNORE_EMPTY_FILE = "IsIgnoreEmptyFile";
    private static final String ROWNUM_FIELD = "rownum_field";
    private static final String ENCODING = "encoding";
    private static final String NAME = "name";
    private static final String FILEMASK = "filemask";
    private static final String EXCLUDE_FILEMASK = "exclude_filemask";
    private static final String FILE_REQUIRED = "file_required";
    private static final String INCLUDE_SUBFOLDERS = "include_subfolders";
    private static final String LIMIT = "limit";
    private static final String IS_IN_FIELDS = "IsInFields";
    private static final String DYNAMIC_FILENAME_FIELD = "DynamicFilenameField";
    private static final String SHORT_FILE_FIELD_NAME = "shortFileFieldName";
    private static final String PATH_FIELD_NAME = "pathFieldName";
    private static final String HIDDEN_FIELD_NAME = "hiddenFieldName";
    private static final String LAST_MODIFICATION_TIME_FIELD_NAME = "lastModificationTimeFieldName";
    private static final String URI_NAME_FIELD_NAME = "uriNameFieldName";
    private static final String ROOT_URI_NAME_FIELD_NAME = "rootUriNameFieldName";
    private static final String EXTENSION_FIELD_NAME = "extensionFieldName";
    private static final String FILE = "file";
    private static final String FIELDS = "fields";
    private static final String FILE_NAME_REP = "file_name";
    private static final String FILE_MASK_REP = "file_mask";
    private static final String EXCLUDEFILE_MASK_REP = "excludefile_mask";
    private static final String FIELD_NAME_REP = "field_name";
    private static final String ELEMENT_TYPE_REP = "element_type";
    private static final String FIELD_TYPE_REP = "field_type";
    private static final String FIELD_FORMAT_REP = "field_format";
    private static final String FIELD_CURRENCY_REP = "field_currency";
    private static final String FIELD_DECIMAL_REP = "field_decimal";
    private static final String FIELD_GROUP_REP = "field_group";
    private static final String FIELD_LENGTH_REP = "field_length";
    private static final String FIELD_PRECISION_REP = "field_precision";
    private static final String FIELD_TRIM_TYPE_REP = "field_trim_type";
    private static final String FIELD_REPEAT_REP = "field_repeat";
    private static Class<?> PKG = LoadFileInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private LoadFileInputField[] inputFields;
    private String encoding;
    private String DynamicFilenameField;
    private boolean fileinfield;
    private boolean addresultfile;
    private String[] fileRequired;
    private boolean IsIgnoreEmptyFile;
    private String[] includeSubFolders;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequired) {
        this.fileRequired = fileRequired;
    }

    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public boolean addResultFile() {
        return this.addresultfile;
    }

    public boolean isIgnoreEmptyFile() {
        return this.IsIgnoreEmptyFile;
    }

    public void setIgnoreEmptyFile(boolean IsIgnoreEmptyFile) {
        this.IsIgnoreEmptyFile = IsIgnoreEmptyFile;
    }

    public void setAddResultFile(boolean addresultfile) {
        this.addresultfile = addresultfile;
    }

    public LoadFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(LoadFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getDynamicFilenameField() {
        return this.DynamicFilenameField;
    }

    public void setDynamicFilenameField(String DynamicFilenameField) {
        this.DynamicFilenameField = DynamicFilenameField;
    }

    public boolean getIsInFields() {
        return this.fileinfield;
    }

    public void setIsInFields(boolean IsInFields) {
        this.fileinfield = IsInFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        LoadFileInputMeta retval = (LoadFileInputMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrFiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrFiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrFiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrFiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrFiles);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (LoadFileInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)INCLUDE, (boolean)this.includeFilename));
        retval.append("    " + XMLHandler.addTagValue((String)INCLUDE_FIELD, (String)this.filenameField));
        retval.append("    " + XMLHandler.addTagValue((String)ROWNUM, (boolean)this.includeRowNumber));
        retval.append("    " + XMLHandler.addTagValue((String)ADDRESULTFILE, (boolean)this.addresultfile));
        retval.append("    " + XMLHandler.addTagValue((String)IS_IGNORE_EMPTY_FILE, (boolean)this.IsIgnoreEmptyFile));
        retval.append("    " + XMLHandler.addTagValue((String)ROWNUM_FIELD, (String)this.rowNumberField));
        retval.append("    " + XMLHandler.addTagValue((String)ENCODING, (String)this.encoding));
        retval.append("    <file>" + Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)NAME, (String)this.fileName[i]));
            retval.append("      " + XMLHandler.addTagValue((String)FILEMASK, (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)EXCLUDE_FILEMASK, (String)this.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)FILE_REQUIRED, (String)this.fileRequired[i]));
            retval.append("      " + XMLHandler.addTagValue((String)INCLUDE_SUBFOLDERS, (String)this.includeSubFolders[i]));
        }
        retval.append("      </file>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            LoadFileInputField field = this.inputFields[i];
            retval.append(field.getXML());
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)LIMIT, (long)this.rowLimit));
        retval.append("    " + XMLHandler.addTagValue((String)IS_IN_FIELDS, (boolean)this.fileinfield));
        retval.append("    " + XMLHandler.addTagValue((String)DYNAMIC_FILENAME_FIELD, (String)this.DynamicFilenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)SHORT_FILE_FIELD_NAME, (String)this.shortFileFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)PATH_FIELD_NAME, (String)this.pathFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)HIDDEN_FIELD_NAME, (String)this.hiddenFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)LAST_MODIFICATION_TIME_FIELD_NAME, (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)URI_NAME_FIELD_NAME, (String)this.uriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)ROOT_URI_NAME_FIELD_NAME, (String)this.rootUriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)EXTENSION_FIELD_NAME, (String)this.extensionFieldName));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.includeFilename = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)INCLUDE));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)INCLUDE_FIELD);
            this.addresultfile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)ADDRESULTFILE));
            this.IsIgnoreEmptyFile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)IS_IGNORE_EMPTY_FILE));
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)ROWNUM));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)ROWNUM_FIELD);
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)ENCODING);
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)FILE);
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)FIELDS);
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)NAME);
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)NAME, (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)FILEMASK, (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)EXCLUDE_FILEMASK, (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)FILE_REQUIRED, (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)INCLUDE_SUBFOLDERS, (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                LoadFileInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new LoadFileInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)LIMIT), (long)0L);
            this.fileinfield = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)IS_IN_FIELDS));
            this.DynamicFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)DYNAMIC_FILENAME_FIELD);
            this.shortFileFieldName = XMLHandler.getTagValue((Node)stepnode, (String)SHORT_FILE_FIELD_NAME);
            this.pathFieldName = XMLHandler.getTagValue((Node)stepnode, (String)PATH_FIELD_NAME);
            this.hiddenFieldName = XMLHandler.getTagValue((Node)stepnode, (String)HIDDEN_FIELD_NAME);
            this.lastModificationTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)LAST_MODIFICATION_TIME_FIELD_NAME);
            this.uriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)URI_NAME_FIELD_NAME);
            this.rootUriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)ROOT_URI_NAME_FIELD_NAME);
            this.extensionFieldName = XMLHandler.getTagValue((Node)stepnode, (String)EXTENSION_FIELD_NAME);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"LoadFileInputMeta.Exception.ErrorLoadingXML", (String[])new String[]{e.toString()}));
        }
    }

    public void allocate(int nrfiles, int nrfields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
        this.inputFields = new LoadFileInputField[nrfields];
    }

    @Override
    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.encoding = "";
        this.IsIgnoreEmptyFile = false;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.addresultfile = true;
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new LoadFileInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
        this.fileinfield = false;
        this.DynamicFilenameField = null;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString v;
        if (!this.getIsInFields()) {
            r.clear();
        }
        for (int i = 0; i < this.inputFields.length; ++i) {
            LoadFileInputField field = this.inputFields[i];
            int type = field.getType();
            switch (field.getElementType()) {
                case 0: {
                    if (type != 0) break;
                    type = 2;
                    break;
                }
                case 1: {
                    if (type != 0) break;
                    type = 5;
                    break;
                }
            }
            try {
                ValueMetaInterface v2 = ValueMetaFactory.createValueMeta((String)space.environmentSubstitute(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setConversionMask(field.getFormat());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setTrimType(field.getTrimType());
                v2.setOrigin(name);
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.includeFilename) {
            v = new ValueMetaString(space.environmentSubstitute(this.filenameField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getShortFileNameField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getExtensionField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getPathField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            v = new ValueMetaBoolean(space.environmentSubstitute(this.isHiddenField()));
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            v = new ValueMetaDate(space.environmentSubstitute(this.getLastModificationDateField()));
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.getRootUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.includeFilename = rep.getStepAttributeBoolean(id_step, INCLUDE);
            this.filenameField = rep.getStepAttributeString(id_step, INCLUDE_FIELD);
            this.addresultfile = rep.getStepAttributeBoolean(id_step, ADDRESULTFILE);
            this.IsIgnoreEmptyFile = rep.getStepAttributeBoolean(id_step, IS_IGNORE_EMPTY_FILE);
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, ROWNUM);
            this.rowNumberField = rep.getStepAttributeString(id_step, ROWNUM_FIELD);
            this.rowLimit = rep.getStepAttributeInteger(id_step, LIMIT);
            this.encoding = rep.getStepAttributeString(id_step, ENCODING);
            int nrFiles = rep.countNrStepAttributes(id_step, FILE_NAME_REP);
            int nrFields = rep.countNrStepAttributes(id_step, FIELD_NAME_REP);
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, FILE_NAME_REP);
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, FILE_MASK_REP);
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, EXCLUDEFILE_MASK_REP);
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, FILE_REQUIRED);
                if (!YES.equalsIgnoreCase(this.fileRequired[i])) {
                    this.fileRequired[i] = NO;
                }
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, INCLUDE_SUBFOLDERS);
                if (YES.equalsIgnoreCase(this.includeSubFolders[i])) continue;
                this.includeSubFolders[i] = NO;
            }
            for (i = 0; i < nrFields; ++i) {
                LoadFileInputField field = new LoadFileInputField();
                field.setName(rep.getStepAttributeString(id_step, i, FIELD_NAME_REP));
                field.setElementType(LoadFileInputField.getElementTypeByCode(rep.getStepAttributeString(id_step, i, ELEMENT_TYPE_REP)));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, FIELD_TYPE_REP)));
                field.setFormat(rep.getStepAttributeString(id_step, i, FIELD_FORMAT_REP));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, FIELD_CURRENCY_REP));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, FIELD_DECIMAL_REP));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, FIELD_GROUP_REP));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, FIELD_LENGTH_REP));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, FIELD_PRECISION_REP));
                field.setTrimType(LoadFileInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, FIELD_TRIM_TYPE_REP)));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, FIELD_REPEAT_REP));
                this.inputFields[i] = field;
            }
            this.fileinfield = rep.getStepAttributeBoolean(id_step, IS_IN_FIELDS);
            this.DynamicFilenameField = rep.getStepAttributeString(id_step, DYNAMIC_FILENAME_FIELD);
            this.shortFileFieldName = rep.getStepAttributeString(id_step, SHORT_FILE_FIELD_NAME);
            this.pathFieldName = rep.getStepAttributeString(id_step, PATH_FIELD_NAME);
            this.hiddenFieldName = rep.getStepAttributeString(id_step, HIDDEN_FIELD_NAME);
            this.lastModificationTimeFieldName = rep.getStepAttributeString(id_step, LAST_MODIFICATION_TIME_FIELD_NAME);
            this.rootUriNameFieldName = rep.getStepAttributeString(id_step, ROOT_URI_NAME_FIELD_NAME);
            this.extensionFieldName = rep.getStepAttributeString(id_step, EXTENSION_FIELD_NAME);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LoadFileInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, INCLUDE, this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, INCLUDE_FIELD, this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, ADDRESULTFILE, this.addresultfile);
            rep.saveStepAttribute(id_transformation, id_step, IS_IGNORE_EMPTY_FILE, this.IsIgnoreEmptyFile);
            rep.saveStepAttribute(id_transformation, id_step, ROWNUM, this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, ROWNUM_FIELD, this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, LIMIT, this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, ENCODING, this.encoding);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, FILE_NAME_REP, this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, FILE_MASK_REP, this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, EXCLUDEFILE_MASK_REP, this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, FILE_REQUIRED, this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, INCLUDE_SUBFOLDERS, this.includeSubFolders[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                LoadFileInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_NAME_REP, field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, ELEMENT_TYPE_REP, field.getElementTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_TYPE_REP, field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_FORMAT_REP, field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_CURRENCY_REP, field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_DECIMAL_REP, field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_GROUP_REP, field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_LENGTH_REP, field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_PRECISION_REP, field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_TRIM_TYPE_REP, field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, FIELD_REPEAT_REP, field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, IS_IN_FIELDS, this.fileinfield);
            rep.saveStepAttribute(id_transformation, id_step, DYNAMIC_FILENAME_FIELD, this.DynamicFilenameField);
            rep.saveStepAttribute(id_transformation, id_step, SHORT_FILE_FIELD_NAME, this.shortFileFieldName);
            rep.saveStepAttribute(id_transformation, id_step, PATH_FIELD_NAME, this.pathFieldName);
            rep.saveStepAttribute(id_transformation, id_step, HIDDEN_FIELD_NAME, this.hiddenFieldName);
            rep.saveStepAttribute(id_transformation, id_step, LAST_MODIFICATION_TIME_FIELD_NAME, this.lastModificationTimeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, URI_NAME_FIELD_NAME, this.uriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, ROOT_URI_NAME_FIELD_NAME, this.rootUriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, EXTENSION_FIELD_NAME, this.extensionFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LoadFileInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (this.getIsInFields()) {
            CheckResult cr;
            if (input.length == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            if (Const.isEmpty((String)this.getDynamicFilenameField())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.FieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles(transMeta);
            if (fileInputList == null || fileInputList.getFiles().size() == 0) {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.fileinfield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                    this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Const.isEmpty((String)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new LoadFileInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new LoadFileInputData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadFileInputMeta)) {
            return false;
        }
        LoadFileInputMeta that = (LoadFileInputMeta)o;
        if (this.IsIgnoreEmptyFile != that.IsIgnoreEmptyFile) {
            return false;
        }
        if (this.addresultfile != that.addresultfile) {
            return false;
        }
        if (this.fileinfield != that.fileinfield) {
            return false;
        }
        if (this.includeFilename != that.includeFilename) {
            return false;
        }
        if (this.includeRowNumber != that.includeRowNumber) {
            return false;
        }
        if (this.rowLimit != that.rowLimit) {
            return false;
        }
        if (this.DynamicFilenameField != null ? !this.DynamicFilenameField.equals(that.DynamicFilenameField) : that.DynamicFilenameField != null) {
            return false;
        }
        if (this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null) {
            return false;
        }
        if (!Arrays.equals(this.excludeFileMask, that.excludeFileMask)) {
            return false;
        }
        if (this.extensionFieldName != null ? !this.extensionFieldName.equals(that.extensionFieldName) : that.extensionFieldName != null) {
            return false;
        }
        if (!Arrays.equals(this.fileMask, that.fileMask)) {
            return false;
        }
        if (!Arrays.equals(this.fileName, that.fileName)) {
            return false;
        }
        if (!Arrays.equals(this.fileRequired, that.fileRequired)) {
            return false;
        }
        if (this.filenameField != null ? !this.filenameField.equals(that.filenameField) : that.filenameField != null) {
            return false;
        }
        if (this.hiddenFieldName != null ? !this.hiddenFieldName.equals(that.hiddenFieldName) : that.hiddenFieldName != null) {
            return false;
        }
        if (!Arrays.equals(this.includeSubFolders, that.includeSubFolders)) {
            return false;
        }
        if (!Arrays.equals(this.inputFields, that.inputFields)) {
            return false;
        }
        if (this.lastModificationTimeFieldName != null ? !this.lastModificationTimeFieldName.equals(that.lastModificationTimeFieldName) : that.lastModificationTimeFieldName != null) {
            return false;
        }
        if (this.pathFieldName != null ? !this.pathFieldName.equals(that.pathFieldName) : that.pathFieldName != null) {
            return false;
        }
        if (this.rootUriNameFieldName != null ? !this.rootUriNameFieldName.equals(that.rootUriNameFieldName) : that.rootUriNameFieldName != null) {
            return false;
        }
        if (this.rowNumberField != null ? !this.rowNumberField.equals(that.rowNumberField) : that.rowNumberField != null) {
            return false;
        }
        if (this.shortFileFieldName != null ? !this.shortFileFieldName.equals(that.shortFileFieldName) : that.shortFileFieldName != null) {
            return false;
        }
        return !(this.uriNameFieldName == null ? that.uriNameFieldName != null : !this.uriNameFieldName.equals(that.uriNameFieldName));
    }

    public int hashCode() {
        int result = this.fileName != null ? Arrays.hashCode(this.fileName) : 0;
        result = 31 * result + (this.fileMask != null ? Arrays.hashCode(this.fileMask) : 0);
        result = 31 * result + (this.excludeFileMask != null ? Arrays.hashCode(this.excludeFileMask) : 0);
        result = 31 * result + (this.includeFilename ? 1 : 0);
        result = 31 * result + (this.filenameField != null ? this.filenameField.hashCode() : 0);
        result = 31 * result + (this.includeRowNumber ? 1 : 0);
        result = 31 * result + (this.rowNumberField != null ? this.rowNumberField.hashCode() : 0);
        result = 31 * result + (int)(this.rowLimit ^ this.rowLimit >>> 32);
        result = 31 * result + (this.inputFields != null ? Arrays.hashCode(this.inputFields) : 0);
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        result = 31 * result + (this.DynamicFilenameField != null ? this.DynamicFilenameField.hashCode() : 0);
        result = 31 * result + (this.fileinfield ? 1 : 0);
        result = 31 * result + (this.addresultfile ? 1 : 0);
        result = 31 * result + (this.fileRequired != null ? Arrays.hashCode(this.fileRequired) : 0);
        result = 31 * result + (this.IsIgnoreEmptyFile ? 1 : 0);
        result = 31 * result + (this.includeSubFolders != null ? Arrays.hashCode(this.includeSubFolders) : 0);
        result = 31 * result + (this.shortFileFieldName != null ? this.shortFileFieldName.hashCode() : 0);
        result = 31 * result + (this.pathFieldName != null ? this.pathFieldName.hashCode() : 0);
        result = 31 * result + (this.hiddenFieldName != null ? this.hiddenFieldName.hashCode() : 0);
        result = 31 * result + (this.lastModificationTimeFieldName != null ? this.lastModificationTimeFieldName.hashCode() : 0);
        result = 31 * result + (this.uriNameFieldName != null ? this.uriNameFieldName.hashCode() : 0);
        result = 31 * result + (this.rootUriNameFieldName != null ? this.rootUriNameFieldName.hashCode() : 0);
        result = 31 * result + (this.extensionFieldName != null ? this.extensionFieldName.hashCode() : 0);
        return result;
    }
}

