/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.memgroupby;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaNone;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupBy;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class MemoryGroupByMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MemoryGroupByMeta.class;
    public static final int TYPE_GROUP_NONE = 0;
    public static final int TYPE_GROUP_SUM = 1;
    public static final int TYPE_GROUP_AVERAGE = 2;
    public static final int TYPE_GROUP_MEDIAN = 3;
    public static final int TYPE_GROUP_PERCENTILE = 4;
    public static final int TYPE_GROUP_MIN = 5;
    public static final int TYPE_GROUP_MAX = 6;
    public static final int TYPE_GROUP_COUNT_ALL = 7;
    public static final int TYPE_GROUP_CONCAT_COMMA = 8;
    public static final int TYPE_GROUP_FIRST = 9;
    public static final int TYPE_GROUP_LAST = 10;
    public static final int TYPE_GROUP_FIRST_INCL_NULL = 11;
    public static final int TYPE_GROUP_LAST_INCL_NULL = 12;
    public static final int TYPE_GROUP_STANDARD_DEVIATION = 13;
    public static final int TYPE_GROUP_CONCAT_STRING = 14;
    public static final int TYPE_GROUP_COUNT_DISTINCT = 15;
    public static final int TYPE_GROUP_COUNT_ANY = 16;
    public static final String[] typeGroupCode = new String[]{"-", "SUM", "AVERAGE", "MEDIAN", "PERCENTILE", "MIN", "MAX", "COUNT_ALL", "CONCAT_COMMA", "FIRST", "LAST", "FIRST_INCL_NULL", "LAST_INCL_NULL", "STD_DEV", "CONCAT_STRING", "COUNT_DISTINCT", "COUNT_ANY"};
    public static final String[] typeGroupLongDesc = new String[]{"-", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.SUM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.AVERAGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.MEDIAN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.PERCENTILE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.MIN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.MAX", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_ALL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_COMMA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.FIRST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.LAST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.FIRST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.LAST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.STANDARD_DEVIATION", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_STRING", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.COUNT_DISTINCT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.COUNT_ANY", (String[])new String[0])};
    private String[] groupField;
    private String[] aggregateField;
    private String[] subjectField;
    private int[] aggregateType;
    private String[] valueField;
    private boolean alwaysGivingBackOneRow;

    public String[] getAggregateField() {
        return this.aggregateField;
    }

    public void setAggregateField(String[] aggregateField) {
        this.aggregateField = aggregateField;
    }

    public int[] getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(int[] aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String[] getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String[] groupField) {
        this.groupField = groupField;
    }

    public String[] getSubjectField() {
        return this.subjectField;
    }

    public void setSubjectField(String[] subjectField) {
        this.subjectField = subjectField;
    }

    public String[] getValueField() {
        return this.valueField;
    }

    public void setValueField(String[] valueField) {
        this.valueField = valueField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int sizegroup, int nrfields) {
        this.groupField = new String[sizegroup];
        this.aggregateField = new String[nrfields];
        this.subjectField = new String[nrfields];
        this.aggregateType = new int[nrfields];
        this.valueField = new String[nrfields];
    }

    @Override
    public Object clone() {
        MemoryGroupByMeta retval = (MemoryGroupByMeta)super.clone();
        int nrFields = this.aggregateField.length;
        int nrGroups = this.groupField.length;
        retval.allocate(nrGroups, nrFields);
        System.arraycopy(this.groupField, 0, retval.groupField, 0, nrGroups);
        System.arraycopy(this.aggregateField, 0, retval.aggregateField, 0, nrFields);
        System.arraycopy(this.subjectField, 0, retval.subjectField, 0, nrFields);
        System.arraycopy(this.aggregateType, 0, retval.aggregateType, 0, nrFields);
        System.arraycopy(this.valueField, 0, retval.valueField, 0, nrFields);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node groupn = XMLHandler.getSubNode((Node)stepnode, (String)"group");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int sizegroup = XMLHandler.countNodes((Node)groupn, (String)"field");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(sizegroup, nrfields);
            for (int i = 0; i < sizegroup; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)groupn, (String)"field", (int)i);
                this.groupField[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
            boolean hasNumberOfValues = false;
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.aggregateField[i] = XMLHandler.getTagValue((Node)fnode, (String)"aggregate");
                this.subjectField[i] = XMLHandler.getTagValue((Node)fnode, (String)"subject");
                this.aggregateType[i] = MemoryGroupByMeta.getType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                if (this.aggregateType[i] == 7 || this.aggregateType[i] == 15 || this.aggregateType[i] == 16) {
                    hasNumberOfValues = true;
                }
                this.valueField[i] = XMLHandler.getTagValue((Node)fnode, (String)"valuefield");
            }
            String giveBackRow = XMLHandler.getTagValue((Node)stepnode, (String)"give_back_row");
            this.alwaysGivingBackOneRow = Const.isEmpty((String)giveBackRow) ? hasNumberOfValues : "Y".equalsIgnoreCase(giveBackRow);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public static final int getType(String desc) {
        int i;
        for (i = 0; i < typeGroupCode.length; ++i) {
            if (!typeGroupCode[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        for (i = 0; i < typeGroupLongDesc.length; ++i) {
            if (!typeGroupLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int i) {
        if (i < 0 || i >= typeGroupCode.length) {
            return null;
        }
        return typeGroupCode[i];
    }

    public static final String getTypeDescLong(int i) {
        if (i < 0 || i >= typeGroupLongDesc.length) {
            return null;
        }
        return typeGroupLongDesc[i];
    }

    @Override
    public void setDefault() {
        int sizegroup = 0;
        int nrfields = 0;
        this.allocate(sizegroup, nrfields);
    }

    @Override
    public void getFields(RowMetaInterface r, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int i;
        boolean compatibilityMode = ValueMetaBase.convertStringToBoolean((String)space.getVariable("KETTLE_COMPATIBILITY_MEMORY_GROUP_BY_SUM_AVERAGE_RETURN_NUMBER_TYPE", "N"));
        RowMeta fields = new RowMeta();
        for (i = 0; i < this.groupField.length; ++i) {
            ValueMetaInterface valueMeta = r.searchValueMeta(this.groupField[i]);
            if (valueMeta == null) continue;
            valueMeta.setStorageType(0);
            fields.addValueMeta(valueMeta);
        }
        for (i = 0; i < this.subjectField.length; ++i) {
            ValueMetaInterface v;
            ValueMetaInterface subj = r.searchValueMeta(this.subjectField[i]);
            if (subj == null && this.aggregateType[i] != 16) continue;
            String value_name = this.aggregateField[i];
            int value_type = 0;
            int length = -1;
            int precision = -1;
            switch (this.aggregateType[i]) {
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    value_type = subj.getType();
                    break;
                }
                case 7: 
                case 15: 
                case 16: {
                    value_type = 5;
                    break;
                }
                case 8: {
                    value_type = 2;
                    break;
                }
                case 1: 
                case 2: {
                    if (!compatibilityMode && subj.isNumeric()) {
                        value_type = subj.getType();
                        break;
                    }
                    value_type = 1;
                    break;
                }
                case 3: 
                case 4: 
                case 13: {
                    value_type = 1;
                    break;
                }
                case 14: {
                    value_type = 2;
                    break;
                }
            }
            if (this.aggregateType[i] == 7 || this.aggregateType[i] == 15 || this.aggregateType[i] == 16) {
                length = 10;
                precision = 0;
            } else if (this.aggregateType[i] == 1 && value_type != 5 && value_type != 1 && value_type != 6) {
                value_type = 1;
                precision = -1;
                length = -1;
            }
            if (value_type == 0) continue;
            try {
                v = ValueMetaFactory.createValueMeta((String)value_name, (int)value_type);
            }
            catch (KettlePluginException e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.Exception.UnknownValueMetaType", (String[])new String[0]), new Object[]{value_type, e});
                v = new ValueMetaNone(value_name);
            }
            v.setOrigin(origin);
            v.setLength(length, precision);
            fields.addValueMeta(v);
        }
        r.clear();
        r.addRowMeta((RowMetaInterface)fields);
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(500);
        retval.append("      ").append(XMLHandler.addTagValue((String)"give_back_row", (boolean)this.alwaysGivingBackOneRow));
        retval.append("      <group>").append(Const.CR);
        for (i = 0; i < this.groupField.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.groupField[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </group>").append(Const.CR);
        retval.append("      <fields>").append(Const.CR);
        for (i = 0; i < this.subjectField.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"aggregate", (String)this.aggregateField[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"subject", (String)this.subjectField[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"type", (String)MemoryGroupByMeta.getTypeDesc(this.aggregateType[i])));
            retval.append("          ").append(XMLHandler.addTagValue((String)"valuefield", (String)this.valueField[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int groupsize = rep.countNrStepAttributes(id_step, "group_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "aggregate_name");
            this.allocate(groupsize, nrvalues);
            for (int i = 0; i < groupsize; ++i) {
                this.groupField[i] = rep.getStepAttributeString(id_step, i, "group_name");
            }
            boolean hasNumberOfValues = false;
            for (int i = 0; i < nrvalues; ++i) {
                this.aggregateField[i] = rep.getStepAttributeString(id_step, i, "aggregate_name");
                this.subjectField[i] = rep.getStepAttributeString(id_step, i, "aggregate_subject");
                this.aggregateType[i] = MemoryGroupByMeta.getType(rep.getStepAttributeString(id_step, i, "aggregate_type"));
                if (this.aggregateType[i] == 7 || this.aggregateType[i] == 15 || this.aggregateType[i] == 16) {
                    hasNumberOfValues = true;
                }
                this.valueField[i] = rep.getStepAttributeString(id_step, i, "aggregate_value_field");
            }
            this.alwaysGivingBackOneRow = rep.getStepAttributeBoolean(id_step, 0, "give_back_row", hasNumberOfValues);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "give_back_row", this.alwaysGivingBackOneRow);
            for (i = 0; i < this.groupField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "group_name", this.groupField[i]);
            }
            for (i = 0; i < this.subjectField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_name", this.aggregateField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_subject", this.subjectField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_type", MemoryGroupByMeta.getTypeDesc(this.aggregateType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_value_field", this.valueField[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.CheckResult.ReceivingInfoOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new MemoryGroupBy(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MemoryGroupByData();
    }

    public boolean isAlwaysGivingBackOneRow() {
        return this.alwaysGivingBackOneRow;
    }

    public void setAlwaysGivingBackOneRow(boolean alwaysGivingBackOneRow) {
        this.alwaysGivingBackOneRow = alwaysGivingBackOneRow;
    }
}

