/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.monetdbagilemart;

import org.pentaho.di.core.TableManager;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.monetdbagilemart.MonetDBAgileMartMeta;
import org.pentaho.di.trans.steps.monetdbagilemart.MonetDBRowLimitException;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoader;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderData;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderMeta;
import org.pentaho.di.trans.steps.tableagilemart.AgileMartUtil;

public class MonetDBAgileMart
extends MonetDBBulkLoader
implements TableManager {
    private static Class<?> PKG = MonetDBAgileMartMeta.class;
    private long rowLimit = -1L;
    private long bufferLimit = -1L;

    public MonetDBAgileMart(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        String connection = MonetDBAgileMartMeta.getStringProperty("AgileBIDatabase", "AgileBI");
        ((MonetDBAgileMartMeta)stepMeta.getStepMetaInterface()).setDatabaseMeta(transMeta.findDatabase(connection));
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        MonetDBBulkLoaderMeta stepMeta = (MonetDBBulkLoaderMeta)smi;
        stepMeta.setAutoSchema(true);
        stepMeta.setAutoStringWidths(true);
        stepMeta.setTruncate(true);
        return super.init(smi, sdi);
    }

    @Override
    public boolean execute(MonetDBBulkLoaderMeta meta, boolean wait) throws KettleException {
        this.rowLimit = ((MonetDBAgileMartMeta)meta).getRowLimit();
        this.rowsWritten = 0L;
        MonetDBBulkLoaderData data = this.getData();
        this.bufferLimit = data.bufferSize;
        if (this.rowLimit < this.bufferLimit) {
            this.bufferLimit = this.rowLimit;
        }
        if (this.log.isDetailed()) {
            this.logDetailed("MonetDBAgileMart Truncate flag: " + meta.isTruncate());
        }
        if (this.log.isDetailed()) {
            this.logDetailed("MonetDBAgileMart Auto Adjust Schema flag: " + meta.isAutoSchema());
        }
        if (this.log.isDetailed()) {
            this.logDetailed("MonetDBAgileMart Auto String Length flag: " + meta.isAutoStringWidths());
        }
        if (this.log.isDetailed()) {
            this.logDetailed("Creating commands");
        }
        if (meta.isAutoSchema() || meta.isTruncate()) {
            try {
                if (meta.isAutoSchema()) {
                    this.autoAdjustSchema(meta);
                } else if (meta.isTruncate()) {
                    this.truncateTable();
                }
            }
            catch (Exception ex) {
                throw new KettleException("Error while generating MonetDB commands", (Throwable)ex);
            }
        }
        if (!meta.isAutoSchema()) {
            meta.updateFields(this.getTransMeta(), this.getStepname(), data);
        }
        return super.execute(meta, wait);
    }

    @Override
    protected void writeRowToMonetDB(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        if (this.rowsWritten >= this.rowLimit) {
            this.writeBufferToMonetDB();
            AgileMartUtil util = new AgileMartUtil();
            util.updateMetadata(this.getMeta(), this.rowsWritten);
            throw new MonetDBRowLimitException(BaseMessages.getString((String)"MonetDBAgileMart.Log.RowLimitExceeded"));
        }
        MonetDBBulkLoaderData data = this.getData();
        if (this.bufferLimit == (long)data.bufferIndex || this.log.isDebug()) {
            this.writeBufferToMonetDB();
            if (this.rowLimit - this.rowsWritten < this.bufferLimit) {
                this.bufferLimit = this.rowLimit - this.rowsWritten;
            }
            if (this.rowsWritten >= this.rowLimit) {
                throw new MonetDBRowLimitException(BaseMessages.getString((String)"MonetDBAgileMart.Log.RowLimitExceeded"));
            }
        }
        this.addRowToBuffer(rowMeta, r);
        ++this.rowsWritten;
    }

    @Override
    public void setRowLimit(long rowLimit) {
        ((MonetDBAgileMartMeta)this.getMeta()).setRowLimit(rowLimit);
    }

    @Override
    public boolean flush() {
        try {
            this.writeBufferToMonetDB();
            return true;
        }
        catch (KettleException e) {
            MonetDBBulkLoaderMeta meta = this.getMeta();
            this.setMessage(BaseMessages.getString(PKG, (String)"MonetDBAgileMart.Log.FlushError", (String[])new String[]{meta.getTableName(), this.getMessage()}));
            this.log.logError(BaseMessages.getString(PKG, (String)"MonetDBAgileMart.Log.FlushError", (String[])new String[]{meta.getTableName(), this.getMessage()}), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean truncateTable() {
        MonetDBBulkLoaderMeta meta = this.getMeta();
        try {
            super.truncate();
            return true;
        }
        catch (KettleException e) {
            this.setMessage(BaseMessages.getString(PKG, (String)"MonetDBAgileMart.Log.TruncateError", (String[])new String[]{meta.getTableName(), this.getMessage()}));
            this.log.logError(BaseMessages.getString(PKG, (String)"MonetDBAgileMart.Log.TruncateError", (String[])new String[]{meta.getTableName(), this.getMessage()}), (Throwable)e);
            return false;
        }
    }

    @Override
    public void setTableName(String tableName) {
        MonetDBBulkLoaderMeta meta = this.getMeta();
        meta.setTableName(tableName);
    }

    @Override
    public boolean adjustSchema() {
        MonetDBBulkLoaderMeta meta = this.getMeta();
        try {
            this.autoAdjustSchema(meta);
            return true;
        }
        catch (KettleException e) {
            this.setMessage(BaseMessages.getString(PKG, (String)"MonetDBAgileMart.Log.SchemaError", (String[])new String[]{meta.getTableName(), this.getMessage()}));
            this.log.logError(BaseMessages.getString(PKG, (String)"MonetDBAgileMart.Log.SchemaError", (String[])new String[]{meta.getTableName(), this.getMessage()}), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean dropTable() {
        MonetDBBulkLoaderMeta meta = this.getMeta();
        try {
            this.drop();
            return true;
        }
        catch (KettleException e) {
            this.setMessage(BaseMessages.getString(PKG, (String)"MonetDBAgileMart.Log.DropError", (String[])new String[]{meta.getTableName(), this.getMessage()}));
            this.log.logError(BaseMessages.getString(PKG, (String)"MonetDBAgileMart.Log.DropError", (String[])new String[]{meta.getTableName(), this.getMessage()}), (Throwable)e);
            return false;
        }
    }
}

