/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.multimerge;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.multimerge.MultiMergeJoinData;
import org.pentaho.di.trans.steps.multimerge.MultiMergeJoinMeta;

public class MultiMergeJoin
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MultiMergeJoinMeta.class;
    private MultiMergeJoinMeta meta;
    private MultiMergeJoinData data;

    public MultiMergeJoin(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private boolean processFirstRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        String inputStepName;
        this.meta = (MultiMergeJoinMeta)smi;
        this.data = (MultiMergeJoinData)sdi;
        TransMeta transMeta = this.getTransMeta();
        StepIOMetaInterface stepIOMeta = this.meta.getStepIOMeta();
        List<StreamInterface> infoStreams = stepIOMeta.getInfoStreams();
        StepMeta toStepMeta = this.meta.getParentStepMeta();
        ArrayList<String> inputStepNameList = new ArrayList<String>();
        String[] inputStepNames = this.meta.getInputSteps();
        for (int i = 0; i < infoStreams.size(); ++i) {
            inputStepName = inputStepNames[i];
            StreamInterface stream = infoStreams.get(i);
            StepMeta fromStepMeta = stream.getStepMeta();
            if (fromStepMeta == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.UnableToFindReferenceStream", (String[])new String[]{inputStepName}));
            }
            TransHopMeta transHopMeta = transMeta.findTransHop(fromStepMeta, toStepMeta, true);
            if (transHopMeta == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.UnableToFindReferenceStream", (String[])new String[]{inputStepName}));
            }
            if (transHopMeta.isEnabled()) {
                inputStepNameList.add(inputStepName);
                continue;
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.IgnoringStep", (String[])new String[]{inputStepName}));
        }
        int streamSize = inputStepNameList.size();
        if (streamSize == 0) {
            return false;
        }
        this.data.rowSets = new RowSet[streamSize];
        this.data.rows = new Object[streamSize][];
        this.data.metas = new RowMetaInterface[streamSize];
        this.data.rowLengths = new int[streamSize];
        MultiMergeJoinData.QueueComparator comparator = new MultiMergeJoinData.QueueComparator(this.data);
        this.data.queue = new PriorityQueue<MultiMergeJoinData.QueueEntry>(streamSize, comparator);
        this.data.results = new ArrayList<List<Object[]>>(streamSize);
        this.data.queueEntries = new MultiMergeJoinData.QueueEntry[streamSize];
        this.data.drainIndices = new int[streamSize];
        this.data.keyNrs = new int[streamSize][];
        this.data.dummy = new Object[streamSize][];
        this.data.outputRowMeta = new RowMeta();
        int j = 0;
        for (int i = 0; i < inputStepNames.length; ++i) {
            RowMetaInterface rowMeta;
            inputStepName = inputStepNames[i];
            if (!inputStepNameList.contains(inputStepName)) continue;
            MultiMergeJoinData.QueueEntry queueEntry = new MultiMergeJoinData.QueueEntry();
            queueEntry.index = j;
            this.data.queueEntries[j] = queueEntry;
            this.data.results.add(new ArrayList());
            RowSet rowSet = this.findInputRowSet(inputStepName);
            if (rowSet == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Exception.UnableToFindSpecifiedStep", (String[])new String[]{inputStepName}));
            }
            this.data.rowSets[j] = rowSet;
            Object[] row = this.getRowFrom(rowSet);
            this.data.rows[j] = row;
            if (row == null) {
                this.data.metas[j] = rowMeta = this.getTransMeta().getStepFields(inputStepName);
            } else {
                queueEntry.row = row;
                rowMeta = rowSet.getRowMeta();
                String keyField = this.meta.getKeyFields()[i];
                String[] keyFieldParts = keyField.split(",");
                this.data.keyNrs[j] = new int[keyFieldParts.length];
                for (int k = 0; k < keyFieldParts.length; ++k) {
                    String keyFieldPart = keyFieldParts[k];
                    this.data.keyNrs[j][k] = rowMeta.indexOfValue(keyFieldPart);
                    if (this.data.keyNrs[j][k] >= 0) continue;
                    String message = BaseMessages.getString(PKG, (String)"MultiMergeJoin.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{keyFieldPart, inputStepName});
                    this.logError(message);
                    throw new KettleStepException(message);
                }
                this.data.metas[j] = rowMeta;
                this.data.queue.add(this.data.queueEntries[j]);
            }
            this.data.outputRowMeta.mergeRowMeta(rowMeta.clone());
            this.data.rowLengths[j] = rowMeta.size();
            this.data.dummy[j] = RowDataUtil.allocateRowData((int)rowMeta.size());
            ++j;
        }
        return true;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        int i;
        this.meta = (MultiMergeJoinMeta)smi;
        this.data = (MultiMergeJoinData)sdi;
        if (this.first) {
            if (!this.processFirstRow(smi, sdi)) {
                this.setOutputDone();
                return false;
            }
            this.first = false;
        }
        if (this.log.isRowLevel()) {
            String metaString = BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.DataInfo", (String[])new String[]{this.data.metas[0].getString(this.data.rows[0]) + ""});
            for (i = 1; i < this.data.metas.length; ++i) {
                metaString = metaString + this.data.metas[i].getString(this.data.rows[i]);
            }
            this.logRowlevel(metaString);
        }
        int streamSize = this.data.metas.length;
        if (this.data.optional) {
            int i2;
            int i3;
            if (this.data.queue.isEmpty()) {
                this.setOutputDone();
                return false;
            }
            MultiMergeJoinData.QueueEntry minEntry = this.data.queue.poll();
            int drainSize = 1;
            this.data.rows[minEntry.index] = minEntry.row;
            this.data.drainIndices[0] = minEntry.index;
            MultiMergeJoinData.QueueComparator comparator = (MultiMergeJoinData.QueueComparator)this.data.queue.comparator();
            while (!this.data.queue.isEmpty() && comparator.compare(this.data.queue.peek(), minEntry) == 0) {
                MultiMergeJoinData.QueueEntry entry = this.data.queue.poll();
                this.data.rows[entry.index] = entry.row;
                this.data.drainIndices[drainSize++] = entry.index;
            }
            Object[] row = null;
            for (i3 = 0; i3 < drainSize; ++i3) {
                int index = this.data.drainIndices[i3];
                this.data.results.get(index).add(this.data.rows[index]);
                while (!this.isStopped() && (row = this.getRowFrom(this.data.rowSets[index])) != null && this.data.metas[index].compare(this.data.rows[index], row, this.data.keyNrs[index]) == 0) {
                    this.data.results.get(index).add(row);
                }
                if (this.isStopped()) {
                    return false;
                }
                if (row == null) continue;
                this.data.queueEntries[index].row = row;
                this.data.queue.add(this.data.queueEntries[index]);
            }
            for (i3 = 0; i3 < streamSize; ++i3) {
                this.data.drainIndices[i3] = 0;
                if (!this.data.results.get(i3).isEmpty()) continue;
                this.data.results.get(i3).add(this.data.dummy[i3]);
            }
            int current = 0;
            while (true) {
                for (i2 = 0; i2 < streamSize; ++i2) {
                    this.data.rows[i2] = this.data.results.get(i2).get(this.data.drainIndices[i2]);
                }
                row = RowDataUtil.createResizedCopy((Object[][])this.data.rows, (int[])this.data.rowLengths);
                this.putRow(this.data.outputRowMeta, row);
                do {
                    int n = current;
                    this.data.drainIndices[n] = this.data.drainIndices[n] + 1;
                    if (this.data.drainIndices[n] < this.data.results.get(current).size()) break;
                    this.data.drainIndices[current] = 0;
                } while (++current < streamSize);
                if (current >= streamSize) break;
                current = 0;
            }
            for (i2 = 0; i2 < streamSize; ++i2) {
                this.data.results.get(i2).clear();
            }
        } else {
            if (this.data.queue.size() < streamSize) {
                this.data.queue.clear();
                for (i = 0; i < streamSize; ++i) {
                    while (this.data.rows[i] != null && !this.isStopped()) {
                        this.data.rows[i] = this.getRowFrom(this.data.rowSets[i]);
                    }
                }
                this.setOutputDone();
                return false;
            }
            MultiMergeJoinData.QueueEntry minEntry = this.data.queue.poll();
            int drainSize = 1;
            this.data.rows[minEntry.index] = minEntry.row;
            this.data.drainIndices[0] = minEntry.index;
            MultiMergeJoinData.QueueComparator comparator = (MultiMergeJoinData.QueueComparator)this.data.queue.comparator();
            while (!this.data.queue.isEmpty() && comparator.compare(this.data.queue.peek(), minEntry) == 0) {
                MultiMergeJoinData.QueueEntry entry = this.data.queue.poll();
                this.data.rows[entry.index] = entry.row;
                this.data.drainIndices[drainSize++] = entry.index;
            }
            Object[] row = null;
            if (this.data.queue.isEmpty()) {
                int i4;
                int i5;
                for (i5 = 0; i5 < streamSize; ++i5) {
                    this.data.results.get(i5).add(this.data.rows[i5]);
                    while (!this.isStopped() && (row = this.getRowFrom(this.data.rowSets[i5])) != null && this.data.metas[i5].compare(this.data.rows[i5], row, this.data.keyNrs[i5]) == 0) {
                        this.data.results.get(i5).add(row);
                    }
                    if (this.isStopped()) {
                        return false;
                    }
                    if (row == null) continue;
                    this.data.queueEntries[i5].row = row;
                    this.data.queue.add(this.data.queueEntries[i5]);
                }
                for (i5 = 0; i5 < streamSize; ++i5) {
                    this.data.drainIndices[i5] = 0;
                }
                int current = 0;
                while (true) {
                    for (i4 = 0; i4 < streamSize; ++i4) {
                        this.data.rows[i4] = this.data.results.get(i4).get(this.data.drainIndices[i4]);
                    }
                    row = RowDataUtil.createResizedCopy((Object[][])this.data.rows, (int[])this.data.rowLengths);
                    this.putRow(this.data.outputRowMeta, row);
                    do {
                        int n = current;
                        this.data.drainIndices[n] = this.data.drainIndices[n] + 1;
                        if (this.data.drainIndices[n] < this.data.results.get(current).size()) break;
                        this.data.drainIndices[current] = 0;
                    } while (++current < streamSize);
                    if (current >= streamSize) break;
                    current = 0;
                }
                for (i4 = 0; i4 < streamSize; ++i4) {
                    this.data.results.get(i4).clear();
                }
            } else {
                for (int i6 = 0; i6 < drainSize; ++i6) {
                    int index = this.data.drainIndices[i6];
                    while ((row = this.getRowFrom(this.data.rowSets[index])) != null && this.data.metas[index].compare(this.data.rows[index], row, this.data.keyNrs[index]) == 0 && !this.isStopped()) {
                    }
                    if (this.isStopped() || row == null) break;
                    this.data.queueEntries[index].row = row;
                    this.data.queue.add(this.data.queueEntries[index]);
                }
                if (this.isStopped()) {
                    return false;
                }
            }
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MultiMergeJoin.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MultiMergeJoinMeta)smi;
        this.data = (MultiMergeJoinData)sdi;
        if (super.init(smi, sdi)) {
            StepIOMetaInterface stepIOMeta = this.meta.getStepIOMeta();
            String[] inputStepNames = this.meta.getInputSteps();
            List<StreamInterface> infoStreams = stepIOMeta.getInfoStreams();
            for (int i = 0; i < infoStreams.size(); ++i) {
                String inputStepName = inputStepNames[i];
                StreamInterface stream = infoStreams.get(i);
                if (stream.getStepMeta() != null) continue;
                this.logError(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.UnableToFindReferenceStream", (String[])new String[]{inputStepName}));
                return false;
            }
            String joinType = this.meta.getJoinType();
            for (int i = 0; i < MultiMergeJoinMeta.join_types.length; ++i) {
                if (!joinType.equalsIgnoreCase(MultiMergeJoinMeta.join_types[i])) continue;
                this.data.optional = MultiMergeJoinMeta.optionals[i];
                return true;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MultiMergeJoin.Log.InvalidJoinType", (String[])new String[]{this.meta.getJoinType()}));
            return false;
        }
        return true;
    }

    protected boolean isInputLayoutValid(RowMetaInterface[] rows) {
        if (rows != null) {
            int i;
            String[] keyFields = this.meta.getKeyFields();
            if (rows.length != keyFields.length) {
                this.logError("keys are not configured for all the streams ");
                return false;
            }
            int prevCount = 0;
            ArrayList<String[]> keyList = new ArrayList<String[]>();
            for (i = 0; i < keyFields.length; ++i) {
                String[] keys = keyFields[i].split(",");
                keyList.add(keys);
                int count = keys.length;
                if (i != 0 && prevCount != count) {
                    this.logError("Number of keys do not match ");
                    return false;
                }
                prevCount = count;
            }
            for (i = 0; i < prevCount; ++i) {
                ValueMetaInterface preValue = null;
                for (int j = 0; j < rows.length; ++j) {
                    ValueMetaInterface v = rows[j].searchValueMeta(((String[])keyList.get(j))[i]);
                    if (v == null) {
                        return false;
                    }
                    if (j != 0 && v.getType() != preValue.getType()) {
                        this.logError("key data type do not match ");
                        return false;
                    }
                    preValue = v;
                }
            }
        }
        return true;
    }
}

