/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.orabulkloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkDataOutput;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderData;
import org.pentaho.di.trans.steps.orabulkloader.OraBulkLoaderMeta;

public class OraBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = OraBulkLoaderMeta.class;
    public static final int EX_SUCC = 0;
    public static final int EX_WARN = 2;
    Process sqlldrProcess = null;
    private OraBulkLoaderMeta meta;
    protected OraBulkLoaderData data;
    private OraBulkDataOutput output = null;
    private boolean preview = false;

    public OraBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private String substituteRecordTerminator(String terminator) {
        StringBuilder in = new StringBuilder();
        boolean escaped = false;
        terminator = this.environmentSubstitute(terminator);
        int length = terminator.length();
        for (int i = 0; i < length; ++i) {
            char c = terminator.charAt(i);
            if (escaped) {
                switch (c) {
                    case 'n': {
                        in.append('\n');
                        break;
                    }
                    case 'r': {
                        in.append('\r');
                        break;
                    }
                    default: {
                        in.append(c);
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            in.append(c);
        }
        return in.toString();
    }

    private String encodeRecordTerminator(String terminator, String encoding) throws KettleException {
        String in = this.substituteRecordTerminator(terminator);
        StringBuilder out = new StringBuilder();
        try {
            byte[] bytes = Const.isEmpty((String)encoding) ? in.getBytes() : in.getBytes(encoding);
            for (byte aByte : bytes) {
                String hex = Integer.toHexString(aByte);
                if (hex.length() == 1) {
                    out.append('0');
                }
                out.append(hex);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new KettleException("Unsupported character encoding: " + encoding, (Throwable)e);
        }
        return out.toString();
    }

    public String getControlFileContents(OraBulkLoaderMeta meta, RowMetaInterface rm, Object[] r) throws KettleException {
        DatabaseMeta dm = meta.getDatabaseMeta();
        String inputName = "'" + this.environmentSubstitute(meta.getDataFile()) + "'";
        String loadAction = meta.getLoadAction();
        StringBuilder contents = new StringBuilder(500);
        contents.append("OPTIONS(").append(Const.CR);
        contents.append("  ERRORS='").append(meta.getMaxErrors()).append("'").append(Const.CR);
        if (!(meta.getCommitSizeAsInt(this) == 0 || meta.isDirectPath() && this.getStepMeta().getCopies() > 1)) {
            contents.append("  , ROWS='").append(meta.getCommitSize()).append("'").append(Const.CR);
        }
        if (meta.getBindSizeAsInt(this) != 0) {
            contents.append("  , BINDSIZE='").append(meta.getBindSize()).append("'").append(Const.CR);
        }
        if (meta.getReadSizeAsInt(this) != 0) {
            contents.append("  , READSIZE='").append(meta.getReadSize()).append("'").append(Const.CR);
        }
        contents.append(")").append(Const.CR);
        contents.append("LOAD DATA").append(Const.CR);
        if (!Const.isEmpty((String)meta.getCharacterSetName())) {
            contents.append("CHARACTERSET ").append(meta.getCharacterSetName()).append(Const.CR);
        }
        if (!"AUTO_CONCURRENT".equals(meta.getLoadMethod()) || !Const.isEmpty((String)meta.getAltRecordTerm())) {
            String infile = inputName;
            if ("AUTO_CONCURRENT".equals(meta.getLoadMethod())) {
                infile = "''";
            }
            contents.append("INFILE ").append(infile);
            if (!Const.isEmpty((String)meta.getAltRecordTerm())) {
                contents.append(" \"STR x'").append(this.encodeRecordTerminator(meta.getAltRecordTerm(), meta.getEncoding())).append("'\"");
            }
            contents.append(Const.CR);
        }
        contents.append("INTO TABLE ").append(dm.getQuotedSchemaTableCombination(this.environmentSubstitute(meta.getSchemaName()), this.environmentSubstitute(meta.getTableName()))).append(Const.CR).append(loadAction).append(Const.CR).append("FIELDS TERMINATED BY ',' ENCLOSED BY '\"'").append(Const.CR).append("(");
        String[] streamFields = meta.getFieldStream();
        String[] tableFields = meta.getFieldTable();
        String[] dateMask = meta.getDateMask();
        if (streamFields == null || streamFields.length == 0) {
            throw new KettleException("No fields defined to load to database");
        }
        block7: for (int i = 0; i < streamFields.length; ++i) {
            if (i != 0) {
                contents.append(", ").append(Const.CR);
            }
            contents.append(dm.quoteField(tableFields[i]));
            int pos = rm.indexOfValue(streamFields[i]);
            if (pos < 0) {
                throw new KettleException("Could not find field " + streamFields[i] + " in stream");
            }
            ValueMetaInterface v = rm.getValueMeta(pos);
            switch (v.getType()) {
                case 2: {
                    if (v.getLength() > 255) {
                        contents.append(" CHAR(").append(v.getLength()).append(")");
                        continue block7;
                    }
                    contents.append(" CHAR");
                    continue block7;
                }
                case 1: 
                case 5: 
                case 6: {
                    continue block7;
                }
                case 3: {
                    if ("DATE".equals(dateMask[i])) {
                        contents.append(" DATE 'yyyy-mm-dd'");
                        continue block7;
                    }
                    if ("DATETIME".equals(dateMask[i])) {
                        contents.append(" TIMESTAMP 'yyyy-mm-dd hh24:mi:ss.ff'");
                        continue block7;
                    }
                    contents.append(" DATE 'yyyy-mm-dd'");
                    continue block7;
                }
                case 8: {
                    contents.append(" ENCLOSED BY '<startlob>' AND '<endlob>'");
                    continue block7;
                }
                case 9: {
                    contents.append(" TIMESTAMP 'yyyy-mm-dd hh24:mi:ss.ff'");
                    continue block7;
                }
            }
        }
        contents.append(")");
        return contents.toString();
    }

    public void createControlFile(String filename, Object[] row, OraBulkLoaderMeta meta) throws KettleException {
        File controlFile = new File(filename);
        OutputStreamWriter fw = null;
        try {
            controlFile.createNewFile();
            fw = new FileWriter(controlFile);
            fw.write(this.getControlFileContents(meta, this.getInputRowMeta(), row));
        }
        catch (IOException ex) {
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String createCommandLine(OraBulkLoaderMeta meta, boolean password) throws KettleException {
        DatabaseMeta dm;
        FileObject fileObject;
        StringBuilder sb = new StringBuilder(300);
        if (meta.getSqlldr() != null) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getSqlldr()), (VariableSpace)this.getTransMeta());
                String sqlldr = KettleVFS.getFilename((FileObject)fileObject);
                sb.append(sqlldr);
            }
            catch (KettleFileException ex) {
                throw new KettleException("Error retrieving sqlldr string", (Throwable)ex);
            }
        } else {
            throw new KettleException("No sqlldr application specified");
        }
        if (meta.getControlFile() != null) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getControlFile()), (VariableSpace)this.getTransMeta());
                sb.append(" control='");
                sb.append(KettleVFS.getFilename((FileObject)fileObject));
                sb.append("'");
            }
            catch (KettleFileException ex) {
                throw new KettleException("Error retrieving controlfile string", (Throwable)ex);
            }
        } else {
            throw new KettleException("No control file specified");
        }
        if ("AUTO_CONCURRENT".equals(meta.getLoadMethod())) {
            sb.append(" data='-'");
        }
        if (meta.getLogFile() != null) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getLogFile()), (VariableSpace)this.getTransMeta());
                sb.append(" log='");
                sb.append(KettleVFS.getFilename((FileObject)fileObject));
                sb.append("'");
            }
            catch (KettleFileException ex) {
                throw new KettleException("Error retrieving logfile string", (Throwable)ex);
            }
        }
        if (meta.getBadFile() != null) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getBadFile()), (VariableSpace)this.getTransMeta());
                sb.append(" bad='");
                sb.append(KettleVFS.getFilename((FileObject)fileObject));
                sb.append("'");
            }
            catch (KettleFileException ex) {
                throw new KettleException("Error retrieving badfile string", (Throwable)ex);
            }
        }
        if (meta.getDiscardFile() != null) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getDiscardFile()), (VariableSpace)this.getTransMeta());
                sb.append(" discard='");
                sb.append(KettleVFS.getFilename((FileObject)fileObject));
                sb.append("'");
            }
            catch (KettleFileException ex) {
                throw new KettleException("Error retrieving discardfile string", (Throwable)ex);
            }
        }
        if ((dm = meta.getDatabaseMeta()) != null) {
            String user = Const.NVL((String)dm.getUsername(), (String)"");
            String pass = Const.NVL((String)Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(dm.getPassword())), (String)"");
            if (!password) {
                pass = "******";
            }
            String dns = Const.NVL((String)dm.getDatabaseName(), (String)"");
            sb.append(" userid=").append(this.environmentSubstitute(user)).append("/").append(this.environmentSubstitute(pass)).append("@");
            String overrideName = meta.getDbNameOverride();
            if (Const.isEmpty((String)Const.rtrim((String)overrideName))) {
                sb.append(this.environmentSubstitute(dns));
            } else {
                sb.append(this.environmentSubstitute(overrideName));
            }
        } else {
            throw new KettleException("No connection specified");
        }
        if (meta.isDirectPath()) {
            sb.append(" DIRECT=TRUE");
            if (this.getStepMeta().getCopies() > 1 || meta.isParallel()) {
                sb.append(" PARALLEL=TRUE");
            }
        }
        return sb.toString();
    }

    public void checkExitVal(int exitVal) throws KettleException {
        if (exitVal == 0) {
            return;
        }
        if (this.meta.isFailOnWarning() && exitVal == 2) {
            throw new KettleException("sqlldr returned warning");
        }
        if (this.meta.isFailOnError() && exitVal != 2) {
            throw new KettleException("sqlldr returned an error (exit code " + exitVal + ")");
        }
    }

    public boolean execute(OraBulkLoaderMeta meta, boolean wait) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        try {
            this.sqlldrProcess = rt.exec(this.createCommandLine(meta, true));
            StreamLogger errorLogger = new StreamLogger(this.sqlldrProcess.getErrorStream(), "ERROR");
            StreamLogger outputLogger = new StreamLogger(this.sqlldrProcess.getInputStream(), "OUTPUT");
            errorLogger.start();
            outputLogger.start();
            if (wait) {
                int exitVal = this.sqlldrProcess.waitFor();
                this.sqlldrProcess = null;
                this.logBasic(BaseMessages.getString(PKG, (String)"OraBulkLoader.Log.ExitValueSqlldr", (String[])new String[]{"" + exitVal}));
                this.checkExitVal(exitVal);
            }
        }
        catch (Exception ex) {
            throw new KettleException("Error while executing sqlldr '" + this.createCommandLine(meta, false) + "'");
        }
        return true;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (OraBulkLoaderMeta)smi;
        this.data = (OraBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                if (!this.preview) {
                    String loadMethod;
                    if (this.output != null) {
                        try {
                            this.output.close();
                        }
                        catch (IOException e) {
                            throw new KettleException("Error while closing output", (Throwable)e);
                        }
                        this.output = null;
                    }
                    if ("AUTO_END".equals(loadMethod = this.meta.getLoadMethod())) {
                        if (!this.first) {
                            this.execute(this.meta, true);
                            this.sqlldrProcess = null;
                        }
                    } else if ("AUTO_CONCURRENT".equals(this.meta.getLoadMethod())) {
                        try {
                            if (this.sqlldrProcess != null) {
                                int exitVal = this.sqlldrProcess.waitFor();
                                this.sqlldrProcess = null;
                                this.logBasic(BaseMessages.getString(PKG, (String)"OraBulkLoader.Log.ExitValueSqlldr", (String[])new String[]{"" + exitVal}));
                                this.checkExitVal(exitVal);
                            } else if (!this.first) {
                                throw new KettleException("Internal error: no sqlldr process running");
                            }
                        }
                        catch (Exception ex) {
                            throw new KettleException("Error while executing sqlldr", (Throwable)ex);
                        }
                    }
                }
                return false;
            }
            if (!this.preview) {
                if (this.first) {
                    this.first = false;
                    String recTerm = Const.CR;
                    if (!Const.isEmpty((String)this.meta.getAltRecordTerm())) {
                        recTerm = this.substituteRecordTerminator(this.meta.getAltRecordTerm());
                    }
                    this.createControlFile(this.environmentSubstitute(this.meta.getControlFile()), r, this.meta);
                    this.output = new OraBulkDataOutput(this.meta, recTerm);
                    if ("AUTO_CONCURRENT".equals(this.meta.getLoadMethod())) {
                        this.execute(this.meta, false);
                    }
                    this.output.open(this, this.sqlldrProcess);
                }
                this.output.writeLine(this.getInputRowMeta(), r);
            }
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
        }
        catch (KettleException e) {
            this.logError(BaseMessages.getString(PKG, (String)"OraBulkLoader.Log.ErrorInStep", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (OraBulkLoaderMeta)smi;
        this.data = (OraBulkLoaderData)sdi;
        Trans trans = this.getTrans();
        this.preview = trans.isPreview();
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block14: {
            this.meta = (OraBulkLoaderMeta)smi;
            this.data = (OraBulkLoaderData)sdi;
            super.dispose(smi, sdi);
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    this.logError("Error while closing output", e);
                }
                this.output = null;
            }
            if (this.sqlldrProcess != null) {
                try {
                    int exitVal = this.sqlldrProcess.waitFor();
                    this.sqlldrProcess = null;
                    this.logBasic(BaseMessages.getString(PKG, (String)"OraBulkLoader.Log.ExitValueSqlldr", (String[])new String[]{"" + exitVal}));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    if (this.sqlldrProcess == null) break block14;
                    this.sqlldrProcess.destroy();
                }
            }
        }
        if (!this.preview && this.meta.isEraseFiles()) {
            FileObject fileObject = null;
            String method = this.meta.getLoadMethod();
            if ("AUTO_END".equals(method) && this.meta.getControlFile() != null) {
                try {
                    fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getControlFile()), (VariableSpace)this.getTransMeta());
                    fileObject.delete();
                    fileObject.close();
                }
                catch (Exception ex) {
                    this.logError("Error deleting control file '" + KettleVFS.getFilename((FileObject)fileObject) + "': " + ex.getMessage(), ex);
                }
            }
            if ("AUTO_END".equals(method) && this.meta.getDataFile() != null) {
                try {
                    fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getDataFile()), (VariableSpace)this.getTransMeta());
                    fileObject.delete();
                    fileObject.close();
                }
                catch (Exception ex) {
                    this.logError("Error deleting data file '" + KettleVFS.getFilename((FileObject)fileObject) + "': " + ex.getMessage(), ex);
                }
            }
            if ("MANUAL".equals(method)) {
                this.logBasic("Deletion of files is not compatible with 'manual load method'");
            }
        }
    }

    private final class StreamLogger
    extends Thread {
        private InputStream input;
        private String type;

        StreamLogger(InputStream is, String type) {
            this.input = is;
            this.type = type + ">";
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.input));
                while ((line = br.readLine()) != null) {
                    if (!OraBulkLoader.this.log.isBasic()) continue;
                    OraBulkLoader.this.logBasic(this.type + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

