/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.randomccnumber;

import java.util.Stack;
import java.util.Vector;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.randomccnumber.RandomCCNumberGeneratorMeta;

public class RandomCreditCardNumberGenerator {
    private static Class<?> PKG = RandomCCNumberGeneratorMeta.class;
    public static final int CARD_TYPE_AMEX = 0;
    public static final int CARD_TYPE_DINERS = 1;
    public static final int CARD_TYPE_DISCOVER = 2;
    public static final int CARD_TYPE_ENROUTE = 3;
    public static final int CARD_TYPE_JCB_15 = 4;
    public static final int CARD_TYPE_JCB_16 = 5;
    public static final int CARD_TYPE_MASTERCARD = 6;
    public static final int CARD_TYPE_VISA = 7;
    public static final int CARD_TYPE_VOYAGER = 8;
    public static final int CARD_TYPE_AIRPLUS = 9;
    public static final int CARD_TYPE_BANKCARD = 10;
    public static final int CARD_TYPE_MAESTRO = 11;
    public static final int CARD_TYPE_SOLO = 12;
    public static final int CARD_TYPE_SWITCH = 13;
    public static final int CARD_TYPE_LASER = 14;
    public static final String[] cardTypes = new String[]{"American Express", "Diners", "Discover", "En Route", "JCB1", "JCB2", "MasterCard", "Visa", "Voyager", "Airplus", "BankCard", "Maestro", "Solo", "Switch", "Laser"};
    private static final String[] VISA_PREFIX_LIST = new String[]{"4539", "4556", "4916", "4532", "4929", "40240071", "4485", "4716", "4"};
    private static final String[] MASTERCARD_PREFIX_LIST = new String[]{"51", "52", "53", "54", "55"};
    private static final String[] AMEX_PREFIX_LIST = new String[]{"34", "37"};
    private static final String[] DISCOVER_PREFIX_LIST = new String[]{"6011"};
    private static final String[] DINERS_PREFIX_LIST = new String[]{"300", "301", "302", "303", "36", "38"};
    private static final String[] ENROUTE_PREFIX_LIST = new String[]{"2014", "2149"};
    private static final String[] JCB_15_PREFIX_LIST = new String[]{"2100", "1800"};
    private static final String[] JCB_16_PREFIX_LIST = new String[]{"3088", "3096", "3112", "3158", "3337", "3528"};
    private static final String[] VOYAGER_PREFIX_LIST = new String[]{"8699"};
    private static final String[] AIRPLUS_PREFIX_LIST = new String[]{"192", "122"};
    private static final String[] BANKCARD_PREFIX_LIST = new String[]{"56"};
    private static final String[] MAESTRO_PREFIX_LIST = new String[]{"5020", "6"};
    private static final String[] SOLO_PREFIX_LIST = new String[]{"6334", "6767"};
    private static final String[] SWITCH_PREFIX_LIST = new String[]{"4903", "4905", "4911", "4936", "564182", "633110", "6333", "6759"};
    private static final String[] LASER_PREFIX_LIST = new String[]{"6304", "6706", "6771", "6709"};
    private static final int[] VISA_LENGTH_LIST = new int[]{13, 16};
    private static final int[] MASTERCARD_LENGTH_LIST = new int[]{16};
    private static final int[] AMEX_LENGTH_LIST = new int[]{15};
    private static final int[] DISCOVER_LENGTH_LIST = new int[]{16};
    private static final int[] DINERS_LENGTH_LIST = new int[]{14};
    private static final int[] ENROUTE_LENGTH_LIST = new int[]{15};
    private static final int[] JCB_15_LENGTH_LIST = new int[]{15};
    private static final int[] JCB_16_LENGTH_LIST = new int[]{16};
    private static final int[] VOYAGER_LENGTH_LIST = new int[]{15};
    private static final int[] AIRPLUS_LENGTH_LIST = new int[0];
    private static final int[] BANKCARD_LENGTH_LIST = new int[]{16};
    private static final int[] MAESTRO_LENGTH_LIST = new int[]{16};
    private static final int[] SOLO_LENGTH_LIST = new int[]{16, 18, 19};
    private static final int[] SWITCH_LENGTH_LIST = new int[]{16, 18, 19};
    private static final int[] LASER_LENGTH_LIST = new int[]{16, 17, 18, 19};

    public static int getCardType(String typeName) {
        if (typeName == null) {
            return 0;
        }
        for (int i = 0; i < cardTypes.length; ++i) {
            if (!cardTypes[i].equalsIgnoreCase(typeName)) continue;
            return i;
        }
        return 0;
    }

    public static String getCardName(int id) {
        return id > -1 && id < cardTypes.length ? cardTypes[id] : null;
    }

    private static String strrev(String str) {
        if (str == null) {
            return "";
        }
        String revstr = "";
        for (int i = str.length() - 1; i >= 0; --i) {
            revstr = revstr + str.charAt(i);
        }
        return revstr;
    }

    private static String completed_number(String prefix, int length) {
        String ccnumber = prefix;
        while (ccnumber.length() < length - 1) {
            ccnumber = ccnumber + new Double(Math.floor(Math.random() * 10.0)).intValue();
        }
        String reversedCCnumberString = RandomCreditCardNumberGenerator.strrev(ccnumber);
        Vector<Integer> reversedCCnumberList = new Vector<Integer>();
        for (int i = 0; i < reversedCCnumberString.length(); ++i) {
            reversedCCnumberList.add(new Integer(String.valueOf(reversedCCnumberString.charAt(i))));
        }
        int sum = 0;
        Integer[] reversedCCnumber = reversedCCnumberList.toArray(new Integer[reversedCCnumberList.size()]);
        for (int pos = 0; pos < length - 1; pos += 2) {
            int odd = reversedCCnumber[pos] * 2;
            if (odd > 9) {
                odd -= 9;
            }
            sum += odd;
            if (pos == length - 2) continue;
            sum += reversedCCnumber[pos + 1].intValue();
        }
        int checkdigit = new Double(((Math.floor(sum / 10) + 1.0) * 10.0 - (double)sum) % 10.0).intValue();
        ccnumber = ccnumber + checkdigit;
        return ccnumber;
    }

    private static String[] credit_card_number(String[] prefixList, int length, int howMany) {
        Stack<String> result = new Stack<String>();
        for (int i = 0; i < howMany; ++i) {
            int randomArrayIndex = (int)Math.floor(Math.random() * (double)prefixList.length);
            String ccnumber = prefixList[randomArrayIndex];
            result.push(RandomCreditCardNumberGenerator.completed_number(ccnumber, length));
        }
        return result.toArray(new String[result.size()]);
    }

    private static void checkLength(int cardType, int size, int[] lengths) throws KettleException {
        if (lengths.length == 0) {
            return;
        }
        for (int i = 0; i < lengths.length; ++i) {
            if (size != lengths[i]) continue;
            return;
        }
        throw new KettleException(BaseMessages.getString(PKG, (String)"RandomCreditCardNumbberGenerator.UnSupportedLength", (String[])new String[]{String.valueOf(size), RandomCreditCardNumberGenerator.getCardName(cardType)}));
    }

    public static String[] GenerateCreditCardNumbers(int cardType, int size, int howMany) throws KettleException {
        String[] cards = null;
        switch (cardType) {
            case 6: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, MASTERCARD_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(MASTERCARD_PREFIX_LIST, size, howMany);
                break;
            }
            case 0: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, AMEX_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(AMEX_PREFIX_LIST, size, howMany);
                break;
            }
            case 1: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, DINERS_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(DINERS_PREFIX_LIST, size, howMany);
                break;
            }
            case 2: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, DISCOVER_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(DISCOVER_PREFIX_LIST, size, howMany);
                break;
            }
            case 3: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, ENROUTE_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(ENROUTE_PREFIX_LIST, size, howMany);
                break;
            }
            case 4: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, JCB_15_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(JCB_15_PREFIX_LIST, size, howMany);
                break;
            }
            case 5: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, JCB_16_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(JCB_16_PREFIX_LIST, size, howMany);
                break;
            }
            case 7: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, VISA_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(VISA_PREFIX_LIST, size, howMany);
                break;
            }
            case 8: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, VOYAGER_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(VOYAGER_PREFIX_LIST, size, howMany);
                break;
            }
            case 9: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, AIRPLUS_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(AIRPLUS_PREFIX_LIST, size, howMany);
                break;
            }
            case 10: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, BANKCARD_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(BANKCARD_PREFIX_LIST, size, howMany);
                break;
            }
            case 11: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, MAESTRO_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(MAESTRO_PREFIX_LIST, size, howMany);
                break;
            }
            case 12: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, SOLO_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(SOLO_PREFIX_LIST, size, howMany);
                break;
            }
            case 13: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, SWITCH_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(SWITCH_PREFIX_LIST, size, howMany);
                break;
            }
            case 14: {
                RandomCreditCardNumberGenerator.checkLength(cardType, size, LASER_LENGTH_LIST);
                cards = RandomCreditCardNumberGenerator.credit_card_number(LASER_PREFIX_LIST, size, howMany);
                break;
            }
            default: {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RandomCreditCardNumbberGenerator.UnknownCardtype", (String[])new String[]{String.valueOf(cardType)}));
            }
        }
        return cards;
    }
}

