/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.samplerows;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.samplerows.SampleRowsData;
import org.pentaho.di.trans.steps.samplerows.SampleRowsMeta;

public class SampleRows
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SampleRowsMeta.class;
    private SampleRowsMeta meta;
    private SampleRowsData data;

    public SampleRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        int linesRead;
        this.meta = (SampleRowsMeta)smi;
        this.data = (SampleRowsData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            String realRange = this.environmentSubstitute(this.meta.getLinesRange());
            this.data.addlineField = !Const.isEmpty((String)this.environmentSubstitute(this.meta.getLineNumberField()));
            this.data.previousRowMeta = this.getInputRowMeta().clone();
            this.data.NrPrevFields = this.data.previousRowMeta.size();
            this.data.outputRowMeta = this.data.previousRowMeta;
            if (this.data.addlineField) {
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            }
            String[] rangePart = realRange.split(",");
            ImmutableRangeSet.Builder setBuilder = ImmutableRangeSet.builder();
            for (String part : rangePart) {
                if (part.matches("\\d+")) {
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"SampleRows.Log.RangeValue", (String[])new String[]{part}));
                    }
                    int vpart = Integer.valueOf(part);
                    setBuilder.add(Range.singleton((Comparable)Integer.valueOf(vpart)));
                    continue;
                }
                if (!part.matches("\\d+\\.\\.\\d+")) continue;
                String[] rangeMultiPart = part.split("\\.\\.");
                Integer start = Integer.valueOf(rangeMultiPart[0]);
                Integer end = Integer.valueOf(rangeMultiPart[1]);
                Range range = Range.closed((Comparable)start, (Comparable)end);
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SampleRows.Log.RangeValue", (Object[])new Object[]{range}));
                }
                setBuilder.add(range);
            }
            this.data.rangeSet = setBuilder.build();
        }
        if (this.data.addlineField) {
            this.data.outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            for (int i = 0; i < this.data.NrPrevFields; ++i) {
                this.data.outputRow[i] = r[i];
            }
        } else {
            this.data.outputRow = r;
        }
        if (this.data.rangeSet.contains((Comparable)Integer.valueOf(linesRead = (int)this.getLinesRead()))) {
            if (this.data.addlineField) {
                this.data.outputRow[this.data.NrPrevFields] = this.getLinesRead();
            }
            this.putRow(this.data.outputRowMeta, this.data.outputRow);
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"SampleRows.Log.LineNumber", (String[])new String[]{linesRead + " : " + this.getInputRowMeta().getString(r)}));
            }
        }
        if (this.data.rangeSet.isEmpty() || linesRead >= (Integer)this.data.rangeSet.span().upperEndpoint()) {
            this.setOutputDone();
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SampleRowsMeta)smi;
        this.data = (SampleRowsData)sdi;
        return super.init(smi, sdi);
    }
}

