/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sql;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sql.ExecSQLData;
import org.pentaho.di.trans.steps.sql.ExecSQLMeta;

public class ExecSQL
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ExecSQLMeta.class;
    private ExecSQLMeta meta;
    private ExecSQLData data;

    public ExecSQL(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public static final RowMetaAndData getResultRow(Result result, String upd, String ins, String del, String read) {
        ValueMeta meta;
        RowMetaAndData resultRow = new RowMetaAndData();
        if (upd != null && upd.length() > 0) {
            meta = new ValueMeta(upd, 5);
            meta.setLength(10, 0);
            resultRow.addValue((ValueMetaInterface)meta, (Object)new Long(result.getNrLinesUpdated()));
        }
        if (ins != null && ins.length() > 0) {
            meta = new ValueMeta(ins, 5);
            meta.setLength(10, 0);
            resultRow.addValue((ValueMetaInterface)meta, (Object)new Long(result.getNrLinesOutput()));
        }
        if (del != null && del.length() > 0) {
            meta = new ValueMeta(del, 5);
            meta.setLength(10, 0);
            resultRow.addValue((ValueMetaInterface)meta, (Object)new Long(result.getNrLinesDeleted()));
        }
        if (read != null && read.length() > 0) {
            meta = new ValueMeta(read, 5);
            meta.setLength(10, 0);
            resultRow.addValue((ValueMetaInterface)meta, (Object)new Long(result.getNrLinesRead()));
        }
        return resultRow;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block21: {
            String sql;
            this.meta = (ExecSQLMeta)smi;
            this.data = (ExecSQLData)sdi;
            if (!this.meta.isExecutedEachInputRow()) {
                RowMetaAndData resultRow = ExecSQL.getResultRow(this.data.result, this.meta.getUpdateField(), this.meta.getInsertField(), this.meta.getDeleteField(), this.meta.getReadField());
                this.putRow(resultRow.getRowMeta(), resultRow.getData());
                this.setOutputDone();
                return false;
            }
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.argumentIndexes = new int[this.meta.getArguments().length];
                for (int i = 0; i < this.meta.getArguments().length; ++i) {
                    this.data.argumentIndexes[i] = this.getInputRowMeta().indexOfValue(this.meta.getArguments()[i]);
                    if (this.data.argumentIndexes[i] < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"ExecSQL.Log.ErrorFindingField", (String[])new String[0]) + this.meta.getArguments()[i] + "]");
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"ExecSQL.Exception.CouldNotFindField", (String[])new String[]{this.meta.getArguments()[i]}));
                    }
                    if (!this.meta.isParams()) continue;
                    if (i == 0) {
                        this.data.paramsMeta = new RowMeta();
                    }
                    this.data.paramsMeta.addValueMeta(this.getInputRowMeta().getValueMeta(this.data.argumentIndexes[i]));
                }
                if (!this.meta.isParams()) {
                    this.data.markerPositions = new ArrayList<Integer>();
                    int len = this.data.sql.length();
                    for (int pos = len - 1; pos >= 0; --pos) {
                        if (this.data.sql.charAt(pos) != '?') continue;
                        this.data.markerPositions.add(pos);
                    }
                }
            }
            Object[] paramsData = null;
            if (this.meta.isParams()) {
                paramsData = new Object[this.data.argumentIndexes.length];
                sql = this.data.sql;
                for (int i = 0; i < this.data.argumentIndexes.length; ++i) {
                    paramsData[i] = row[this.data.argumentIndexes[i]];
                }
            } else {
                int numMarkers = this.data.markerPositions.size();
                if (numMarkers > 0) {
                    StringBuffer buf = new StringBuffer(this.data.sql);
                    for (int i = 0; i < numMarkers; ++i) {
                        int index = this.data.argumentIndexes[this.data.markerPositions.size() - i - 1];
                        ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(index);
                        Object valueData = row[index];
                        int pos = this.data.markerPositions.get(i);
                        String replaceValue = valueMeta.getString(valueData);
                        replaceValue = Const.NVL((String)replaceValue, (String)"");
                        if (this.meta.isQuoteString() && valueMeta.getType() == 2) {
                            replaceValue = this.meta.getDatabaseMeta().quoteSQLString(replaceValue);
                        }
                        buf.replace(pos, pos + 1, replaceValue);
                    }
                    sql = buf.toString();
                } else {
                    sql = this.data.sql;
                }
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"ExecSQL.Log.ExecutingSQLScript", (String[])new String[0]) + Const.CR + sql);
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                this.data.result = this.meta.isSingleStatement() ? this.data.db.execStatement(sql, this.data.paramsMeta, paramsData) : this.data.db.execStatements(sql, this.data.paramsMeta, paramsData);
                RowMetaAndData add = ExecSQL.getResultRow(this.data.result, this.meta.getUpdateField(), this.meta.getInsertField(), this.meta.getDeleteField(), this.meta.getReadField());
                row = RowDataUtil.addRowData((Object[])row, (int)this.getInputRowMeta().size(), (Object[])add.getData());
                if (!this.data.db.isAutoCommit()) {
                    this.data.db.commit();
                }
                this.putRow(this.data.outputRowMeta, row);
                if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ExecSQL.Log.LineNumber", (String[])new String[0]) + this.getLinesWritten());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"ExecSQL.Log.ErrorInStep", (String[])new String[0]), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block21;
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "ExecSQL001");
            }
        }
        return true;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLMeta)smi;
        this.data = (ExecSQLData)sdi;
        if (this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ExecSQL.Log.FinishingReadingQuery", (String[])new String[0]));
        }
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ExecSQLMeta)smi;
        this.data = (ExecSQLData)sdi;
        if (this.data.db != null && !this.data.isCanceled) {
            Database database = this.data.db;
            synchronized (database) {
                this.data.db.cancelQuery();
            }
            this.data.isCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLMeta)smi;
        this.data = (ExecSQLData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecSQL.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                return false;
            }
            this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExecSQL.Log.ConnectedToDB", (String[])new String[0]));
                }
                this.data.sql = this.meta.isReplaceVariables() ? this.environmentSubstitute(this.meta.getSql()) : this.meta.getSql();
                if (!this.meta.isExecutedEachInputRow()) {
                    this.data.result = this.meta.isSingleStatement() ? this.data.db.execStatement(this.data.sql) : this.data.db.execStatements(this.data.sql);
                    if (!this.data.db.isAutoCommit()) {
                        this.data.db.commit();
                    }
                }
                return true;
            }
            catch (KettleException e) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecSQL.Log.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }
}

