/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ssh;

import com.trilead.ssh2.Session;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ssh.SSHData;
import org.pentaho.di.trans.steps.ssh.SSHMeta;
import org.pentaho.di.trans.steps.ssh.SessionResult;

public class SSH
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SSHMeta.class;
    private SSHMeta meta;
    private SSHData data;

    public SSH(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        RowMetaInterface imeta;
        Object[] row;
        this.meta = (SSHMeta)smi;
        this.data = (SSHData)sdi;
        if (this.meta.isDynamicCommand()) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.data.nrInputFields = this.data.outputRowMeta.size();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.nrOutputFields = this.data.outputRowMeta.size();
                if (this.meta.isDynamicCommand()) {
                    if (Const.isEmpty((String)this.meta.getcommandfieldname())) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"SSH.Error.CommandFieldMissing", (String[])new String[0]));
                    }
                    this.data.indexOfCommand = this.data.outputRowMeta.indexOfValue(this.meta.getcommandfieldname());
                    if (this.data.indexOfCommand < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"SSH.Exception.CouldnotFindField", (String[])new String[]{this.meta.getcommandfieldname()}));
                    }
                }
            }
        } else if (!this.data.wroteOneRow) {
            row = new Object[]{};
            this.incrementLinesRead();
            this.data.wroteOneRow = true;
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = new RowMeta();
                this.data.nrInputFields = 0;
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.nrOutputFields = this.data.outputRowMeta.size();
                this.data.commands = this.environmentSubstitute(this.meta.getCommand());
            }
        } else {
            this.setOutputDone();
            return false;
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        Object[] rowData = new Object[this.data.nrOutputFields];
        for (int i = 0; i < this.data.nrInputFields; ++i) {
            rowData[i] = row[i];
        }
        int index = this.data.nrInputFields;
        Session session = null;
        try {
            if (this.meta.isDynamicCommand()) {
                this.data.commands = this.data.outputRowMeta.getString(row, this.data.indexOfCommand);
                if (Const.isEmpty((String)this.data.commands)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SSH.Error.MessageEmpty", (String[])new String[0]));
                }
            }
            session = this.data.conn.openSession();
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.SessionOpened", (String[])new String[0]));
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SSH.Log.RunningCommand", (String[])new String[]{this.data.commands}));
            }
            session.execCommand(this.data.commands);
            SessionResult sessionresult = new SessionResult(session);
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.CommandRunnedCommand", (String[])new String[]{this.data.commands, sessionresult.getStdOut(), sessionresult.getStdErr()}));
            }
            rowData[index++] = sessionresult.getStd();
            if (!Const.isEmpty((String)this.data.stdTypeField)) {
                rowData[index++] = sessionresult.isStdTypeErr();
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"SSH.Log.OutputLine", (String[])new String[]{this.data.outputRowMeta.getString(rowData)}));
            }
            this.putRow(this.data.outputRowMeta, rowData);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SSH.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
            }
        }
        catch (Exception e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                boolean bl = false;
                return bl;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "SSH001");
            }
        }
        finally {
            if (session != null) {
                session.close();
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.SessionClosed", (String[])new String[0]));
                }
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SSHMeta)smi;
        this.data = (SSHData)sdi;
        if (super.init(smi, sdi)) {
            String servername = this.environmentSubstitute(this.meta.getServerName());
            int nrPort = Const.toInt((String)this.environmentSubstitute(this.meta.getPort()), (int)22);
            String username = this.environmentSubstitute(this.meta.getuserName());
            String password = Utils.resolvePassword((VariableSpace)this.variables, (String)this.meta.getpassword());
            String keyFilename = this.environmentSubstitute(this.meta.getKeyFileName());
            String passphrase = this.environmentSubstitute(this.meta.getPassphrase());
            int timeOut = Const.toInt((String)this.environmentSubstitute(this.meta.getTimeOut()), (int)0);
            String proxyhost = this.environmentSubstitute(this.meta.getProxyHost());
            int proxyport = Const.toInt((String)this.environmentSubstitute(this.meta.getProxyPort()), (int)0);
            String proxyusername = this.environmentSubstitute(this.meta.getProxyUsername());
            String proxypassword = this.environmentSubstitute(this.meta.getProxyPassword());
            if (Const.isEmpty((String)servername)) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.MissingServerName", (String[])new String[0]));
            }
            if (Const.isEmpty((String)this.meta.getuserName())) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.Error.UserNamedMissing", (String[])new String[0]));
                return false;
            }
            this.data.stdOutField = this.environmentSubstitute(this.meta.getStdOutFieldName());
            if (Const.isEmpty((String)this.data.stdOutField)) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.Error.StdOutFieldNameMissing", (String[])new String[0]));
                return false;
            }
            this.data.stdTypeField = this.environmentSubstitute(this.meta.getStdErrFieldName());
            try {
                this.data.conn = SSHMeta.OpenConnection(servername, nrPort, username, password, this.meta.isusePrivateKey(), keyFilename, passphrase, timeOut, this, proxyhost, proxyport, proxyusername, proxypassword);
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.ConnectionOpened", (String[])new String[0]));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.Error.OpeningConnection", (String[])new String[]{e.getMessage()}));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SSHMeta)smi;
        this.data = (SSHData)sdi;
        if (this.data.conn != null) {
            this.data.conn.close();
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.ConnectionClosed", (String[])new String[0]));
            }
        }
        super.dispose(smi, sdi);
    }
}

