/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.switchcase;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.switchcase.SwitchCase;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseData;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseTarget;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SwitchCaseMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SwitchCaseMeta.class;
    private static final String XML_TAG_CASE_VALUES = "cases";
    private static final String XML_TAG_CASE_VALUE = "case";
    private String fieldname;
    private int caseValueType;
    private String caseValueFormat;
    private String caseValueDecimal;
    private String caseValueGroup;
    private List<SwitchCaseTarget> caseTargets;
    private String defaultTargetStepname;
    private StepMeta defaultTargetStep;
    private boolean isContains;
    private static StreamInterface newDefaultStream = new Stream(StreamInterface.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.Default.Description", (String[])new String[0]), StreamIcon.TARGET, null);
    private static StreamInterface newCaseTargetStream = new Stream(StreamInterface.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.NewCaseTarget.Description", (String[])new String[0]), StreamIcon.TARGET, null);

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate() {
        this.caseTargets = new ArrayList<SwitchCaseTarget>();
    }

    @Override
    public Object clone() {
        SwitchCaseMeta retval = (SwitchCaseMeta)super.clone();
        retval.allocate();
        try {
            for (int i = 0; i < this.caseTargets.size(); ++i) {
                retval.caseTargets.add((SwitchCaseTarget)this.caseTargets.get(i).clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(XMLHandler.addTagValue((String)"fieldname", (String)this.fieldname));
        retval.append(XMLHandler.addTagValue((String)"use_contains", (boolean)this.isContains));
        retval.append(XMLHandler.addTagValue((String)"case_value_type", (String)ValueMeta.getTypeDesc((int)this.caseValueType)));
        retval.append(XMLHandler.addTagValue((String)"case_value_format", (String)this.caseValueFormat));
        retval.append(XMLHandler.addTagValue((String)"case_value_decimal", (String)this.caseValueDecimal));
        retval.append(XMLHandler.addTagValue((String)"case_value_group", (String)this.caseValueGroup));
        retval.append(XMLHandler.addTagValue((String)"default_target_step", (String)(this.defaultTargetStep != null ? this.defaultTargetStep.getName() : this.defaultTargetStepname)));
        retval.append(XMLHandler.openTag((String)XML_TAG_CASE_VALUES));
        for (SwitchCaseTarget target : this.caseTargets) {
            retval.append(XMLHandler.openTag((String)XML_TAG_CASE_VALUE));
            retval.append(XMLHandler.addTagValue((String)"value", (String)(target.caseValue != null ? target.caseValue : "")));
            retval.append(XMLHandler.addTagValue((String)"target_step", (String)(target.caseTargetStep != null ? target.caseTargetStep.getName() : target.caseTargetStepname)));
            retval.append(XMLHandler.closeTag((String)XML_TAG_CASE_VALUE));
        }
        retval.append(XMLHandler.closeTag((String)XML_TAG_CASE_VALUES));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.fieldname = XMLHandler.getTagValue((Node)stepnode, (String)"fieldname");
            this.isContains = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_contains"));
            this.caseValueType = ValueMeta.getType((String)XMLHandler.getTagValue((Node)stepnode, (String)"case_value_type"));
            this.caseValueFormat = XMLHandler.getTagValue((Node)stepnode, (String)"case_value_format");
            this.caseValueDecimal = XMLHandler.getTagValue((Node)stepnode, (String)"case_value_decimal");
            this.caseValueGroup = XMLHandler.getTagValue((Node)stepnode, (String)"case_value_group");
            this.defaultTargetStepname = XMLHandler.getTagValue((Node)stepnode, (String)"default_target_step");
            Node casesNode = XMLHandler.getSubNode((Node)stepnode, (String)XML_TAG_CASE_VALUES);
            int nrCases = XMLHandler.countNodes((Node)casesNode, (String)XML_TAG_CASE_VALUE);
            this.allocate();
            for (int i = 0; i < nrCases; ++i) {
                Node caseNode = XMLHandler.getSubNodeByNr((Node)casesNode, (String)XML_TAG_CASE_VALUE, (int)i);
                SwitchCaseTarget target = new SwitchCaseTarget();
                target.caseValue = XMLHandler.getTagValue((Node)caseNode, (String)"value");
                target.caseTargetStepname = XMLHandler.getTagValue((Node)caseNode, (String)"target_step");
                this.caseTargets.add(target);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SwitchCaseMeta.Exception..UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.allocate();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.fieldname = rep.getStepAttributeString(id_step, "fieldname");
            this.isContains = rep.getStepAttributeBoolean(id_step, "use_contains");
            this.caseValueType = ValueMeta.getType((String)rep.getStepAttributeString(id_step, "case_value_type"));
            this.caseValueFormat = rep.getStepAttributeString(id_step, "case_value_format");
            this.caseValueDecimal = rep.getStepAttributeString(id_step, "case_value_decimal");
            this.caseValueGroup = rep.getStepAttributeString(id_step, "case_value_group");
            this.defaultTargetStepname = rep.getStepAttributeString(id_step, "default_target_step");
            int nrCases = rep.countNrStepAttributes(id_step, "case_value");
            this.allocate();
            for (int i = 0; i < nrCases; ++i) {
                SwitchCaseTarget target = new SwitchCaseTarget();
                target.caseValue = rep.getStepAttributeString(id_step, i, "case_value");
                target.caseTargetStepname = rep.getStepAttributeString(id_step, i, "case_target_step");
                this.caseTargets.add(target);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCaseMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "fieldname", this.fieldname);
            rep.saveStepAttribute(id_transformation, id_step, "use_contains", this.isContains);
            rep.saveStepAttribute(id_transformation, id_step, "case_value_type", ValueMeta.getTypeDesc((int)this.caseValueType));
            rep.saveStepAttribute(id_transformation, id_step, "case_value_format", this.caseValueFormat);
            rep.saveStepAttribute(id_transformation, id_step, "case_value_decimal", this.caseValueDecimal);
            rep.saveStepAttribute(id_transformation, id_step, "case_value_group", this.caseValueGroup);
            rep.saveStepAttribute(id_transformation, id_step, "default_target_step", this.defaultTargetStep != null ? this.defaultTargetStep.getName() : this.defaultTargetStepname);
            for (int i = 0; i < this.caseTargets.size(); ++i) {
                SwitchCaseTarget target = this.caseTargets.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "case_value", target.caseValue != null ? target.caseValue : "");
                rep.saveStepAttribute(id_transformation, id_step, i, "case_target_step", target.caseTargetStep != null ? target.caseTargetStep.getName() : target.caseTargetStepname);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCaseMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        StepIOMetaInterface ioMeta = this.getStepIOMeta();
        for (StreamInterface stream : ioMeta.getTargetStreams()) {
            SwitchCaseTarget target = (SwitchCaseTarget)stream.getSubject();
            if (target == null || target.caseTargetStep != null) continue;
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.TargetStepInvalid", (String[])new String[]{"false", target.caseTargetStepname}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = Const.isEmpty((String)this.fieldname) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.NoFieldSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.FieldSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SwitchCase(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SwitchCaseData();
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getCaseValueFormat() {
        return this.caseValueFormat;
    }

    public void setCaseValueFormat(String caseValueFormat) {
        this.caseValueFormat = caseValueFormat;
    }

    public String getCaseValueDecimal() {
        return this.caseValueDecimal;
    }

    public void setCaseValueDecimal(String caseValueDecimal) {
        this.caseValueDecimal = caseValueDecimal;
    }

    public String getCaseValueGroup() {
        return this.caseValueGroup;
    }

    public void setCaseValueGroup(String caseValueGroup) {
        this.caseValueGroup = caseValueGroup;
    }

    public int getCaseValueType() {
        return this.caseValueType;
    }

    public void setCaseValueType(int caseValueType) {
        this.caseValueType = caseValueType;
    }

    public String getDefaultTargetStepname() {
        return this.defaultTargetStepname;
    }

    public void setDefaultTargetStepname(String defaultTargetStepname) {
        this.defaultTargetStepname = defaultTargetStepname;
    }

    public StepMeta getDefaultTargetStep() {
        return this.defaultTargetStep;
    }

    public void setDefaultTargetStep(StepMeta defaultTargetStep) {
        this.defaultTargetStep = defaultTargetStep;
    }

    public boolean isContains() {
        return this.isContains;
    }

    public void setContains(boolean isContains) {
        this.isContains = isContains;
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, false, false, false, false, true);
            for (SwitchCaseTarget target : this.caseTargets) {
                Stream stream = new Stream(StreamInterface.StreamType.TARGET, target.caseTargetStep, BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.CaseTarget.Description", (String[])new String[]{Const.NVL((String)target.caseValue, (String)"")}), StreamIcon.TARGET, target);
                this.ioMeta.addStream(stream);
            }
            if (this.getDefaultTargetStep() != null) {
                this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, this.getDefaultTargetStep(), BaseMessages.getString(PKG, (String)"SwitchCaseMeta.TargetStream.Default.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            }
        }
        return this.ioMeta;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getTargetStreams()) {
            StepMeta stepMeta;
            SwitchCaseTarget target = (SwitchCaseTarget)stream.getSubject();
            target.caseTargetStep = stepMeta = StepMeta.findStep(steps, target.caseTargetStepname);
        }
        this.defaultTargetStep = StepMeta.findStep(steps, this.defaultTargetStepname);
        this.resetStepIoMeta();
    }

    @Override
    public List<StreamInterface> getOptionalStreams() {
        ArrayList<StreamInterface> list = new ArrayList<StreamInterface>();
        if (this.getDefaultTargetStep() == null) {
            list.add(newDefaultStream);
        }
        list.add(newCaseTargetStream);
        return list;
    }

    @Override
    public void handleStreamSelection(StreamInterface stream) {
        if (stream == newDefaultStream) {
            this.setDefaultTargetStep(stream.getStepMeta());
        }
        if (stream == newCaseTargetStream) {
            SwitchCaseTarget target = new SwitchCaseTarget();
            target.caseTargetStep = stream.getStepMeta();
            target.caseValue = stream.getStepMeta().getName();
            this.caseTargets.add(target);
        }
        List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
        for (int i = 0; i < targetStreams.size(); ++i) {
            if (stream != targetStreams.get(i)) continue;
            SwitchCaseTarget target = (SwitchCaseTarget)stream.getSubject();
            if (target == null) {
                this.setDefaultTargetStep(stream.getStepMeta());
                continue;
            }
            target.caseTargetStep = stream.getStepMeta();
        }
        this.resetStepIoMeta();
    }

    public List<SwitchCaseTarget> getCaseTargets() {
        return this.caseTargets;
    }

    public void setCaseTargets(List<SwitchCaseTarget> caseTargets) {
        this.caseTargets = caseTargets;
    }

    @Override
    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }
}

