/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableagilemart;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.TableManager;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableagilemart.AgileMartUtil;
import org.pentaho.di.trans.steps.tableagilemart.TableAgileMartMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutput;
import org.pentaho.di.trans.steps.tableoutput.TableOutputData;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;

public class TableAgileMart
extends TableOutput
implements TableManager {
    private static Class<?> PKG = TableAgileMartMeta.class;
    private String message = null;
    private long rowLimit = -1L;
    private long rowsWritten = -1L;
    private AgileMartUtil util = new AgileMartUtil();

    public TableAgileMart(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        boolean result = super.init(smi, sdi);
        this.rowsWritten = 0L;
        return result;
    }

    @Override
    public boolean adjustSchema() {
        block14: {
            TableOutputMeta meta = this.getMeta();
            TableOutputData data = this.getData();
            TransMeta transMeta = this.getTransMeta();
            StepMeta stepMeta = meta.getParentStepMeta();
            DBCache dbcache = transMeta.getDbCache();
            StringBuffer messageBuffer = new StringBuffer();
            try {
                RowMetaInterface prev = transMeta.getPrevStepFields(stepMeta.getName());
                if (this.log.isDetailed()) {
                    this.logDetailed("Attempting to auto adjust table structure");
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("getTransMeta: " + this.getTransMeta());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("getStepname: " + this.getStepname());
                }
                SQLStatement statement = meta.getSQLStatements(transMeta, stepMeta, prev, this.repository, this.metaStore);
                if (this.log.isDetailed()) {
                    this.logDetailed("Statement: " + statement);
                }
                if (this.log.isDetailed() && statement != null) {
                    this.logDetailed("Statement has SQL: " + statement.hasSQL());
                }
                if (statement != null && statement.hasSQL()) {
                    String sql = statement.getSQL();
                    if (this.log.isDetailed()) {
                        this.logDetailed("Trying: " + sql);
                    }
                    try {
                        this.log.logDetailed("Executing SQL: " + Const.CR + sql);
                        data.db.execStatement(sql);
                        if (dbcache != null) {
                            dbcache.clear(data.databaseMeta.getName());
                        }
                    }
                    catch (Exception dbe) {
                        String error = BaseMessages.getString(PKG, (String)"SQLEditor.Log.SQLExecError", (String[])new String[]{sql, dbe.toString()});
                        messageBuffer.append(error).append(Const.CR);
                        return false;
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed("Successfull: " + sql);
                    }
                    break block14;
                }
                if (statement.getError() == null) {
                    return true;
                }
                this.message = statement.getError();
                this.logError(statement.getError());
                return false;
            }
            catch (Exception e) {
                this.logError("An error ocurred trying to adjust the table schema", e);
            }
        }
        return true;
    }

    @Override
    protected Object[] writeToTable(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            int index = 0;
            List valueMetas = rowMeta.getValueMetaList();
            for (ValueMetaInterface valueMeta : valueMetas) {
                Object valueData = r[index];
                if (valueData != null && valueMeta.getType() == 2) {
                    String str = valueMeta.getString(valueData);
                    int len = valueMeta.getLength();
                    if (len < 1) {
                        len = 100;
                    }
                    if (str.length() > len) {
                        str = str.substring(0, len);
                    }
                    r[index] = str;
                }
                ++index;
            }
        }
        catch (Exception e) {
            throw new KettleException("Error serializing rows of data to the psql command", (Throwable)e);
        }
        return super.writeToTable(rowMeta, r);
    }

    @Override
    public boolean flush() {
        return false;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.rowLimit != -1L && this.rowsWritten >= this.rowLimit) {
            TableOutputMeta meta = (TableOutputMeta)smi;
            this.util.updateMetadata(meta, this.rowsWritten);
            throw new KettleException("Row limit exceeded");
        }
        boolean result = super.processRow(smi, sdi);
        if (result) {
            ++this.rowsWritten;
        } else {
            TableOutputMeta meta = (TableOutputMeta)smi;
            this.util.updateMetadata(meta, this.rowsWritten);
        }
        return result;
    }

    @Override
    public boolean dropTable() {
        TableOutputMeta meta = this.getMeta();
        TableOutputData data = this.getData();
        String schema = meta.getSchemaName();
        String table = meta.getTableName();
        if (schema != null && !schema.equals("")) {
            table = schema + "." + table;
        }
        String sql = "drop table " + table + ";";
        try {
            Result result = data.db.execStatement(sql);
            int status = result.getExitStatus();
            if (status == 0) {
                this.util.updateMetadata(meta, -1L);
            }
            return status == 0;
        }
        catch (KettleDatabaseException e) {
            this.logError("Could not drop table: " + table, e);
            this.message = "Could not drop table: " + table;
            return false;
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Override
    public void setTableName(String tableName) {
        this.getMeta().setTableName(tableName);
    }

    @Override
    public boolean truncateTable() {
        TableOutputMeta meta = this.getMeta();
        TableOutputData data = this.getData();
        try {
            data.db.truncateTable(this.environmentSubstitute(meta.getSchemaName()), this.environmentSubstitute(meta.getTableName()));
            this.util.updateMetadata(meta, -1L);
            return true;
        }
        catch (KettleDatabaseException e) {
            this.logError("Could not truncate table: " + meta.getTableName(), e);
            this.message = "Could not truncate table: " + meta.getTableName();
            return false;
        }
    }
}

