/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.validator;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.validator.Validation;
import org.pentaho.di.trans.steps.validator.Validator;
import org.pentaho.di.trans.steps.validator.ValidatorData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class ValidatorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ValidatorMeta.class;
    private List<Validation> validations;
    private boolean validatingAll;
    private boolean concatenatingErrors;
    private String concatenationSeparator;
    private static StreamInterface newValidation = new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"ValidatorMeta.NewValidation.Description", (String[])new String[0]), StreamIcon.INFO, null);

    public void allocate(int nrValidations) {
        this.validations = new ArrayList<Validation>(nrValidations);
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        int nrCalcs = XMLHandler.countNodes((Node)stepnode, (String)"validator_field");
        this.allocate(nrCalcs);
        this.validatingAll = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"validate_all"));
        this.concatenatingErrors = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"concat_errors"));
        this.concatenationSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"concat_separator");
        for (int i = 0; i < nrCalcs; ++i) {
            Node calcnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"validator_field", (int)i);
            this.validations.add(new Validation(calcnode));
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(XMLHandler.addTagValue((String)"validate_all", (boolean)this.validatingAll));
        retval.append(XMLHandler.addTagValue((String)"concat_errors", (boolean)this.concatenatingErrors));
        retval.append(XMLHandler.addTagValue((String)"concat_separator", (String)this.concatenationSeparator));
        for (int i = 0; i < this.validations.size(); ++i) {
            retval.append("       ").append(this.validations.get(i).getXML()).append(Const.CR);
        }
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ValidatorMeta m = (ValidatorMeta)obj;
            return this.getXML() == m.getXML();
        }
        return false;
    }

    @Override
    public Object clone() {
        ValidatorMeta retval = (ValidatorMeta)super.clone();
        if (this.validations != null) {
            int valSize = this.validations.size();
            retval.allocate(valSize);
            for (int i = 0; i < valSize; ++i) {
                retval.validations.add(this.validations.get(i).clone());
            }
        } else {
            retval.allocate(0);
        }
        return retval;
    }

    @Override
    public void setDefault() {
        this.validations = new ArrayList<Validation>();
        this.concatenationSeparator = "|";
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        int nrValidationFields = rep.countNrStepAttributes(id_step, "validator_field_name");
        this.allocate(nrValidationFields);
        this.validatingAll = rep.getStepAttributeBoolean(id_step, "validate_all");
        this.concatenatingErrors = rep.getStepAttributeBoolean(id_step, "concat_errors");
        this.concatenationSeparator = rep.getStepAttributeString(id_step, "concat_separator");
        for (int i = 0; i < nrValidationFields; ++i) {
            this.validations.add(new Validation(rep, id_step, i));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "validate_all", this.validatingAll);
        rep.saveStepAttribute(id_transformation, id_step, "concat_errors", this.concatenatingErrors);
        rep.saveStepAttribute(id_transformation, id_step, "concat_separator", this.concatenationSeparator);
        for (int i = 0; i < this.validations.size(); ++i) {
            this.validations.get(i).saveRep(rep, metaStore, id_transformation, id_step, i);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"ValidatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValidatorMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValidatorMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ValidatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Validator(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ValidatorData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public List<Validation> getValidations() {
        return this.validations;
    }

    public void setValidations(List<Validation> validations) {
        this.validations = validations;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public boolean isValidatingAll() {
        return this.validatingAll;
    }

    public void setValidatingAll(boolean validatingAll) {
        this.validatingAll = validatingAll;
    }

    public boolean isConcatenatingErrors() {
        return this.concatenatingErrors;
    }

    public void setConcatenatingErrors(boolean concatenatingErrors) {
        this.concatenatingErrors = concatenatingErrors;
    }

    public String getConcatenationSeparator() {
        return this.concatenationSeparator;
    }

    public void setConcatenationSeparator(String concatenationSeparator) {
        this.concatenationSeparator = concatenationSeparator;
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, true, false);
            for (Validation validation : this.validations) {
                Stream stream = new Stream(StreamInterface.StreamType.INFO, validation.getSourcingStep(), BaseMessages.getString(PKG, (String)"ValidatorMeta.InfoStream.ValidationInput.Description", (String[])new String[]{Const.NVL((String)validation.getName(), (String)"")}), StreamIcon.INFO, validation);
                this.ioMeta.addStream(stream);
            }
        }
        return this.ioMeta;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getInfoStreams()) {
            Validation validation = (Validation)stream.getSubject();
            StepMeta stepMeta = StepMeta.findStep(steps, validation.getSourcingStepName());
            validation.setSourcingStep(stepMeta);
        }
        this.resetStepIoMeta();
    }

    @Override
    public List<StreamInterface> getOptionalStreams() {
        ArrayList<StreamInterface> list = new ArrayList<StreamInterface>();
        list.add(newValidation);
        return list;
    }

    @Override
    public void handleStreamSelection(StreamInterface stream) {
        List<StreamInterface> streams = this.getStepIOMeta().getInfoStreams();
        for (int i = 0; i < this.validations.size(); ++i) {
            this.validations.get(i).setSourcingStep(streams.get(i).getStepMeta());
        }
        if (stream == newValidation) {
            Validation validation = new Validation();
            validation.setName(stream.getStepname());
            validation.setSourcingStep(stream.getStepMeta());
            validation.setSourcingValues(true);
            this.validations.add(validation);
        }
        this.resetStepIoMeta();
    }
}

