/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobAdapter;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteDelegationHandler;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.WebResult;

@Deprecated
public class AddJobServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = -6850701762586992604L;
    public static final String CONTEXT_PATH = "/kettle/addJob";

    public AddJobServlet() {
    }

    public AddJobServlet(JobMap jobMap, SocketRepository socketRepository) {
        super(jobMap, socketRepository);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Addition of job requested");
        }
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        if (this.log.isDetailed()) {
            this.logDetailed("Encoding: " + request.getCharacterEncoding());
        }
        if (useXML) {
            response.setContentType("text/xml");
            out.print(XMLHandler.getXMLHeader());
        } else {
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD><TITLE>Add job</TITLE></HEAD>");
            out.println("<BODY>");
        }
        response.setStatus(200);
        try {
            int c;
            StringBuffer xml = new StringBuffer();
            while ((c = in.read()) != -1) {
                xml.append((char)c);
            }
            JobConfiguration jobConfiguration = JobConfiguration.fromXML(xml.toString());
            JobMeta jobMeta = jobConfiguration.getJobMeta();
            JobExecutionConfiguration jobExecutionConfiguration = jobConfiguration.getJobExecutionConfiguration();
            jobMeta.setLogLevel(jobExecutionConfiguration.getLogLevel());
            jobMeta.injectVariables(jobExecutionConfiguration.getVariables());
            final Repository repository = jobConfiguration.getJobExecutionConfiguration().getRepository();
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(jobExecutionConfiguration.getLogLevel());
            Job job = new Job(repository, jobMeta, (LoggingObjectInterface)servletLoggingObject);
            job.initializeVariablesFrom(null);
            job.getJobMeta().setInternalKettleVariables(job);
            job.injectVariables(jobConfiguration.getJobExecutionConfiguration().getVariables());
            job.setArguments(jobExecutionConfiguration.getArgumentStrings());
            job.copyParametersFrom(jobMeta);
            job.clearParameters();
            String[] parameterNames = job.listParameters();
            for (int idx = 0; idx < parameterNames.length; ++idx) {
                String thisValue = jobExecutionConfiguration.getParams().get(parameterNames[idx]);
                if (Const.isEmpty((String)thisValue)) continue;
                jobMeta.setParameterValue(parameterNames[idx], thisValue);
            }
            jobMeta.activateParameters();
            String startCopyName = jobExecutionConfiguration.getStartCopyName();
            if (startCopyName != null && !startCopyName.isEmpty()) {
                int startCopyNr = jobExecutionConfiguration.getStartCopyNr();
                JobEntryCopy startJobEntryCopy = jobMeta.findJobEntry(startCopyName, startCopyNr, false);
                job.setStartJobEntryCopy(startJobEntryCopy);
            }
            job.setSocketRepository(this.getSocketRepository());
            if (jobExecutionConfiguration.isExpandingRemoteJob()) {
                job.addDelegationListener(new CarteDelegationHandler(this.getTransformationMap(), this.getJobMap()));
            }
            this.getJobMap().addJob(job.getJobname(), carteObjectId, job, jobConfiguration);
            if (repository != null) {
                job.addJobListener(new JobAdapter(){

                    @Override
                    public void jobFinished(Job job) {
                        repository.disconnect();
                    }
                });
            }
            String message = "Job '" + job.getJobname() + "' was added to the list with id " + carteObjectId;
            if (useXML) {
                out.println(new WebResult("OK", message, carteObjectId));
            } else {
                out.println("<H1>" + message + "</H1>");
                out.println("<p><a href=\"" + this.convertContextPath("/kettle/jobStatus") + "?name=" + job.getJobname() + "&id=" + carteObjectId + "\">Go to the job status page</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    protected String[] getAllArgumentStrings(Map<String, String> arguments) {
        if (arguments == null || arguments.size() == 0) {
            return null;
        }
        Object[] argNames = arguments.keySet().toArray(new String[arguments.size()]);
        Arrays.sort(argNames);
        String[] values = new String[argNames.length];
        for (int i = 0; i < argNames.length; ++i) {
            values[i] = arguments.get(argNames[i]);
        }
        return values;
    }

    public String toString() {
        return "Add Job";
    }

    @Override
    public String getService() {
        return "/kettle/addJob (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

