/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.service.core;

import com.qqt.service.core.HttpRequest;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpRequest
implements HttpRequest {
    private static Logger log = LoggerFactory.getLogger(AbstractHttpRequest.class);
    protected CloseableHttpClient httpclient = null;
    protected String url;
    protected String namespace;
    protected String methodName;
    protected Map<String, String> headers;
    protected String urlParams;
    protected String jsonParam;
    protected String xmlParam;
    protected Map<String, String> pairParams;
    protected int connectionRequestTimeout = 30000;
    protected int connectTimeout = 30000;
    protected int socketTimeout = 30000;

    @Override
    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public void setNamespace(String ns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMethodName(String methodName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUrl(String url) {
        if (StringUtils.isEmpty((String)"url")) {
            throw new NullPointerException("url is null");
        }
        this.url = url.trim();
    }

    @Override
    public void setUrlParams(Map<String, String> params) throws UnsupportedEncodingException {
        if (params != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                sb.append("&").append(entry.getKey()).append("=");
                sb.append(URLEncoder.encode(entry.getValue().toString(), "utf-8"));
            }
            this.urlParams = sb.toString();
        }
    }

    @Override
    public void setJsonParams(String params) {
        this.jsonParam = params;
    }

    @Override
    public void setXmlParams(String params) {
        this.xmlParam = params;
    }

    @Override
    public void setPairParams(Map<String, String> params) {
        this.pairParams = params;
    }

    @Override
    public void addHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public <T> HttpCallbackResultVO<T> execute(Class<T> clazz) {
        HttpCallbackResultVO callbackResult = new HttpCallbackResultVO();
        this.httpclient = HttpClients.createDefault();
        if (log.isInfoEnabled()) {
            log.info("--> request urlParams is {}", (Object)this.urlParams);
            log.info("--> request jsonParams is {}", (Object)this.jsonParam);
            log.info("--> request pairParams is {}", this.pairParams);
        }
        return callbackResult;
    }

    protected void setConfig(HttpRequestBase httpRequest) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).setSocketTimeout(this.socketTimeout).build();
        httpRequest.setConfig(config);
    }

    protected void addHeaders(HttpRequestBase httpRequest) {
        if (this.headers != null && this.headers.size() > 0) {
            log.info("--> request headers is {}", this.headers);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                httpRequest.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    protected String addUrlParamsToAddress() {
        if (this.url == null) {
            throw new RuntimeException("request url is null.");
        }
        if (this.urlParams == null || this.urlParams.trim().length() < 1) {
            return this.url;
        }
        this.url = this.url.contains("?") ? this.url + this.urlParams : this.url + this.urlParams.replaceFirst("&", "?");
        return this.url;
    }

    protected <T> void setCommonCallbackResult(HttpResponse response, HttpCallbackResultVO<T> callbackResult) {
        int status = response.getStatusLine().getStatusCode();
        callbackResult.setStatus(status);
        String reasonPhrase = response.getStatusLine().getReasonPhrase();
        callbackResult.setReasonPhrase(reasonPhrase);
        HttpEntity responseEntity = response.getEntity();
        ContentType contentType = ContentType.get((HttpEntity)responseEntity);
        if (contentType != null) {
            Charset charset = contentType.getCharset();
            callbackResult.setCharset(charset == null ? null : charset.name());
            callbackResult.setMimeType(contentType.getMimeType());
        }
    }
}

