/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.service.core;

import com.qqt.service.core.HttpGetRequest;
import com.qqt.service.core.HttpPostRequest;
import com.qqt.service.core.HttpRequest;
import com.qqt.service.core.RequestWay;
import com.qqt.service.core.ServiceType;
import com.qqt.service.core.SoapServiceRequest;

public class HttpClientFactory {
    public static HttpRequest createRequest(ServiceType sevice, RequestWay way) {
        if (sevice == null) {
            throw new NullPointerException("service type is null");
        }
        if (way == null) {
            throw new NullPointerException("request way is null");
        }
        switch (sevice) {
            case SOAP: {
                return HttpClientFactory.createSoapRequest();
            }
            case RESTFUL: {
                switch (way) {
                    case POST: {
                        return HttpClientFactory.createPostRequest();
                    }
                    case GET: {
                        return HttpClientFactory.createGetRequest();
                    }
                }
                throw new RuntimeException("not suport current request way of " + way.toString());
            }
        }
        throw new RuntimeException("not suport current service type of " + way.toString());
    }

    public static HttpRequest createPostRequest() {
        return new HttpPostRequest();
    }

    public static HttpRequest createGetRequest() {
        return new HttpGetRequest();
    }

    public static HttpRequest createSoapRequest() {
        return new SoapServiceRequest();
    }
}

