/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.service.core;

import com.qqt.service.core.AbstractHttpRequest;
import com.qqt.service.vo.HttpCallbackResultVO;
import com.qqt.utils.JsonUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPostRequest
extends AbstractHttpRequest {
    private static Logger log = LoggerFactory.getLogger(HttpPostRequest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> HttpCallbackResultVO<T> execute(final Class<T> clazz) {
        final HttpCallbackResultVO<Object> callbackResult = super.execute(clazz);
        Object response = null;
        try {
            String url = this.addUrlParamsToAddress();
            HttpPost httpPost = new HttpPost(url);
            this.setConfig((HttpRequestBase)httpPost);
            this.addHeaders((HttpRequestBase)httpPost);
            HttpEntity requestEntity = this.getRequestHttpEntity();
            if (requestEntity != null) {
                httpPost.setEntity(requestEntity);
            }
            ResponseHandler responseHandler = new ResponseHandler<T>(){

                public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    String responseBody;
                    HttpPostRequest.this.setCommonCallbackResult(response, callbackResult);
                    HttpEntity responseEntity = response.getEntity();
                    String string = responseBody = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity, (Charset)Charset.forName("utf-8")) : null;
                    if (log.isInfoEnabled()) {
                        log.info("----------------------------------------");
                        log.info("--> responseBody : {}", (Object)responseBody);
                    }
                    Header[] headers = response.getAllHeaders();
                    callbackResult.setHeaders(headers);
                    if ("String".equals(clazz.getSimpleName())) {
                        callbackResult.setResponse(responseBody);
                        String t = responseBody;
                        return t;
                    }
                    if ("application/json".equals(callbackResult.getMimeType())) {
                        Object t = JsonUtil.convertValue((String)responseBody, (Class)clazz);
                        return t;
                    }
                    throw new RuntimeException("\u8be5MimeType\u8fd8\u6ca1\u6709\u89e3\u6790");
                }
            };
            Object responseBody = this.httpclient.execute((HttpUriRequest)httpPost, responseHandler);
            callbackResult.setResult(responseBody);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            log.error(e.getLocalizedMessage());
            callbackResult.setError(e.getLocalizedMessage());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            log.error(e.getLocalizedMessage());
            callbackResult.setError(e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getLocalizedMessage());
            callbackResult.setError(e.getLocalizedMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                this.httpclient.close();
            }
            catch (IOException e) {
                response = null;
                e.printStackTrace();
                log.error(e.getLocalizedMessage());
            }
        }
        return callbackResult;
    }

    private HttpEntity getRequestHttpEntity() throws UnsupportedEncodingException {
        if (this.pairParams != null && this.pairParams.size() > 0) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (Map.Entry entry : this.pairParams.entrySet()) {
                nvps.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
            }
            return new UrlEncodedFormEntity(nvps);
        }
        if (this.jsonParam != null && this.jsonParam.trim().length() > 1) {
            return new StringEntity(this.jsonParam, ContentType.APPLICATION_JSON);
        }
        return null;
    }
}

