/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.service.core;

import com.qqt.service.core.AbstractHttpRequest;
import com.qqt.service.util.SoapXmlUtil;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.charset.Charset;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.common.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapServiceRequest
extends AbstractHttpRequest {
    private static Logger log = LoggerFactory.getLogger(SoapServiceRequest.class);

    @Override
    public void setNamespace(String ns) {
        this.namespace = ns;
    }

    @Override
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public void setXmlParams(String params) {
        this.xmlParam = params;
    }

    private String getNameSpace() {
        if (!StringUtils.isEmpty((String)this.namespace)) {
            return this.namespace;
        }
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            if (this.headers != null) {
                for (Map.Entry entry : this.headers.entrySet()) {
                    if (!"Authorization".equals(entry.getKey())) continue;
                    String val1 = (String)entry.getValue();
                    String encodingPasswd = val1.replace("Basic ", "");
                    byte[] bytes = Base64.decodeBase64((String)encodingPasswd.trim());
                    final String[] ap = new String(bytes).split(":");
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(ap[0], ap[1].toCharArray());
                        }
                    });
                }
            }
            Definition definition = reader.readWSDL(this.url);
            this.setNamespace(definition.getNamespace("tns"));
            return this.namespace;
        }
        catch (WSDLException e) {
            e.printStackTrace();
            log.error("--> get soap namespace by wsdl error. detail is", (Object)e.getLocalizedMessage());
            throw new RuntimeException("soap webservice namespace is null.");
        }
    }

    @Override
    public <T> HttpCallbackResultVO<T> execute(final Class<T> clazz) {
        final HttpCallbackResultVO<Object> callbackResult = super.execute(clazz);
        Object response = null;
        try {
            HttpPost httpPost = new HttpPost(this.url);
            System.out.println("\u8bf7\u6c42url\uff1a" + this.url);
            this.setConfig((HttpRequestBase)httpPost);
            this.addHeaders((HttpRequestBase)httpPost);
            HttpEntity requestEntity = this.getRequestHttpEntity();
            if (requestEntity != null) {
                httpPost.setEntity(requestEntity);
            }
            ResponseHandler responseHandler = new ResponseHandler<T>(){

                public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    SoapServiceRequest.this.setCommonCallbackResult(response, callbackResult);
                    HttpEntity responseEntity = response.getEntity();
                    String responseBody = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity, (Charset)Charset.forName("utf-8")) : null;
                    callbackResult.setResponse(responseBody);
                    if (log.isInfoEnabled()) {
                        log.info("--------------------------------------------------");
                        log.info("--> responseBody : {}", (Object)responseBody);
                    }
                    log.info("--> status = {}", (Object)callbackResult.getStatus());
                    if (callbackResult.getStatus() < 200 || callbackResult.getStatus() > 299) {
                        log.error("--> error detail is {}", (Object)responseBody);
                        callbackResult.setError(responseBody);
                        String responseBody2 = responseBody;
                        return responseBody2;
                    }
                    if ("String".equals(clazz.getSimpleName())) {
                        callbackResult.setResponse(responseBody);
                        String responseBody2 = responseBody;
                        return responseBody2;
                    }
                    Object t = null;
                    try {
                        t = SoapXmlUtil.xml2Bean(clazz, responseBody, SoapServiceRequest.this.methodName, SoapServiceRequest.this.getNameSpace());
                    }
                    catch (JAXBException e) {
                        e.printStackTrace();
                        log.error(e.getLocalizedMessage());
                        callbackResult.setError(e.getLocalizedMessage());
                    }
                    return t;
                }
            };
            Object responseBody = this.httpclient.execute((HttpUriRequest)httpPost, responseHandler);
            callbackResult.setResult(responseBody);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getLocalizedMessage());
            callbackResult.setError(e.getLocalizedMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                this.httpclient.close();
            }
            catch (IOException e) {
                response = null;
                e.printStackTrace();
                log.error(e.getLocalizedMessage());
            }
        }
        return callbackResult;
    }

    private HttpEntity getRequestHttpEntity() throws UnsupportedEncodingException {
        StringBuilder soapRequestData = new StringBuilder();
        soapRequestData.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        soapRequestData.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:zlp=\"" + this.getNameSpace() + "\">" + "<soapenv:Header/>");
        soapRequestData.append("<soapenv:Body>");
        soapRequestData.append("<zlp:" + this.methodName + ">");
        log.info("--> begin\u8bf7\u6c42\u53c2\u6570");
        if (!StringUtils.isEmpty((String)this.xmlParam)) {
            if (log.isInfoEnabled()) {
                log.info("--> request xmlParam = {}", (Object)this.xmlParam);
            }
            soapRequestData.append(this.xmlParam);
        } else if (this.pairParams != null) {
            for (Map.Entry entry : this.pairParams.entrySet()) {
                String key = (String)entry.getKey();
                log.info("<{}>{}</{}>", new Object[]{key, entry.getValue(), key});
                soapRequestData.append("<" + key + ">" + (String)entry.getValue() + "</" + key + ">");
            }
        }
        log.info("--> end\u8bf7\u6c42\u53c2\u6570");
        soapRequestData.append("</zlp:" + this.methodName + ">");
        soapRequestData.append("</soapenv:Body>");
        soapRequestData.append("</soapenv:Envelope>");
        String requestData = soapRequestData.toString();
        if (log.isInfoEnabled()) {
            log.info("--> request data is {}", (Object)requestData);
        }
        byte[] b = requestData.getBytes("UTF-8");
        EntityBuilder entityBuilder = EntityBuilder.create();
        entityBuilder.setContentType(ContentType.APPLICATION_JSON);
        HttpEntity entity = entityBuilder.setBinary(b).build();
        return entity;
    }
}

