/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import top.jfunc.json.Json;
import top.jfunc.json.JsonException;

public abstract class BaseJson<T extends Json> {
    private boolean isStrict = true;
    private boolean isTolerant = true;

    public boolean isStrict() {
        return this.isStrict;
    }

    public T setStrict(boolean isStrict) {
        this.isStrict = isStrict;
        return (T)((Json)((Object)this));
    }

    public boolean isTolerant() {
        return this.isTolerant;
    }

    public T setTolerant(boolean isTolerant) {
        this.isTolerant = isTolerant;
        return (T)((Json)((Object)this));
    }

    protected void assertKey(String key) {
        if (null == key) {
            throw new IllegalArgumentException("key \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected <R> R checkNullValue(String key, R o) {
        if (null == o) {
            if (this.isStrict()) {
                throw new JsonException("\u4e0d\u5b58\u5728key->" + key);
            }
            return null;
        }
        return o;
    }

    protected <R> R checkNullValue(int index, R o) {
        if (null == o) {
            if (this.isStrict()) {
                throw new JsonException("\u4e0d\u5b58\u5728->[ " + index + " ]");
            }
            return null;
        }
        return o;
    }

    protected void assertIndex(int index, int size) {
        if ((index < 0 || index >= size) && this.isStrict()) {
            throw new JsonException(new ArrayIndexOutOfBoundsException("index must between 0 and " + size));
        }
    }
}

