/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import top.jfunc.json.JsonObject;
import top.jfunc.json.impl.BaseJson;
import top.jfunc.json.impl.ValueCompatible;

public abstract class BaseMapJSONObject
extends BaseJson<BaseMapJSONObject>
implements JsonObject {
    protected Map<String, Object> map;

    public BaseMapJSONObject(Map<String, Object> map) {
        this.map = map;
    }

    public BaseMapJSONObject() {
        this.map = new HashMap<String, Object>();
    }

    public BaseMapJSONObject(String jsonString) {
        this.map = this.str2Map(jsonString);
    }

    protected abstract Map<String, Object> str2Map(String var1);

    @Override
    public Map<String, Object> unwrap() {
        return this.map;
    }

    @Override
    public Object get(String key) {
        this.assertKey(key);
        return this.checkNullValue(key, this.map.get(key));
    }

    @Override
    public Object get(String key, Object defaultObject) {
        this.assertKey(key);
        Object temp = this.map.get(key);
        return null == temp ? defaultObject : temp;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String defaultValue) {
        this.assertKey(key);
        boolean has = this.map.containsKey(key);
        if (!has) {
            return this.checkNullValue(key, defaultValue);
        }
        Object value = this.map.get(key);
        String temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, String.class) : (String)value;
        return temp;
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        this.assertKey(key);
        boolean has = this.map.containsKey(key);
        if (!has) {
            return this.checkNullValue(key, defaultValue);
        }
        Object value = this.map.get(key);
        Boolean temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Boolean.class) : (Boolean)value;
        return temp;
    }

    @Override
    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        this.assertKey(key);
        boolean has = this.map.containsKey(key);
        if (!has) {
            return this.checkNullValue(key, defaultValue);
        }
        Object value = this.map.get(key);
        Integer temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Integer.class) : (Integer)value;
        return temp;
    }

    @Override
    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        this.assertKey(key);
        boolean has = this.map.containsKey(key);
        if (!has) {
            return this.checkNullValue(key, defaultValue);
        }
        Object value = this.map.get(key);
        Long temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Long.class) : (Long)value;
        return temp;
    }

    @Override
    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        this.assertKey(key);
        boolean has = this.map.containsKey(key);
        if (!has) {
            return this.checkNullValue(key, defaultValue);
        }
        Object value = this.map.get(key);
        Float temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Float.class) : (Float)value;
        return temp;
    }

    @Override
    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        this.assertKey(key);
        boolean has = this.map.containsKey(key);
        if (!has) {
            return this.checkNullValue(key, defaultValue);
        }
        Object value = this.map.get(key);
        Double temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, Double.class) : (Double)value;
        return temp;
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, null);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        this.assertKey(key);
        boolean has = this.map.containsKey(key);
        if (!has) {
            return this.checkNullValue(key, defaultValue);
        }
        Object value = this.map.get(key);
        BigInteger temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, BigInteger.class) : (BigInteger)value;
        return temp;
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        this.assertKey(key);
        boolean has = this.map.containsKey(key);
        if (!has) {
            return this.checkNullValue(key, defaultValue);
        }
        Object value = this.map.get(key);
        BigDecimal temp = this.isTolerant() ? ValueCompatible.compatibleValue(value, BigDecimal.class) : (BigDecimal)value;
        return temp;
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        Object o = this.map.get(key);
        return (T)o;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public JsonObject put(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public JsonObject putAll(Map<? extends String, ?> m) {
        this.map.putAll(m);
        return this;
    }

    @Override
    public JsonObject clear() {
        this.map.clear();
        return this;
    }

    @Override
    public JsonObject fromMap(Map<String, Object> map) {
        this.map = map;
        return this;
    }

    @Override
    public Object remove(String key) {
        return this.map.remove(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }
}

