/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.ioc.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.ioc.store.BeanInfo;
import vip.justlive.oxygen.ioc.store.BeanStore;

public class DefaultBeanStore
implements BeanStore {
    private final Set<Object> beans = new HashSet<Object>(32);
    private final ConcurrentMap<Class<?>, List<BeanInfo>> beanClassMap = new ConcurrentHashMap(32);
    private final ConcurrentMap<String, Object> beanNameMap = new ConcurrentHashMap<String, Object>(32);

    @Override
    public void addBean(String name, Object bean, int order) {
        if (this.beans.add(bean)) {
            Object oldVal = this.beanNameMap.putIfAbsent(name, bean);
            if (oldVal != null) {
                throw Exceptions.fail((String)String.format("[%s]\u540d\u79f0[%s]\u5df2\u88ab[%s]\u5360\u7528", bean, name, oldVal));
            }
            BeanInfo beanInfo = new BeanInfo(name, bean, order);
            this.margeSuperClass(beanInfo);
        }
    }

    @Override
    public Object getBean(String name) {
        return this.beanNameMap.get(name);
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        List beanInfos = (List)this.beanClassMap.get(clazz);
        if (beanInfos == null) {
            return null;
        }
        Collections.sort(beanInfos);
        BeanInfo beanInfo = (BeanInfo)beanInfos.get(0);
        if (beanInfos.size() > 1 && beanInfo.getOrder() == Integer.MAX_VALUE) {
            throw Exceptions.fail((String)String.format("\u5b58\u5728\u591a\u4e2a\u8be5\u7c7b\u578b\u7684bean [%s]", beanInfos));
        }
        return clazz.cast(beanInfo.getBean());
    }

    @Override
    public <T> T getBean(String name, Class<T> clazz) {
        return clazz.cast(this.getBean(name));
    }

    @Override
    public Map<String, Object> getBeanMap(Class<?> clazz) {
        List beanInfos = (List)this.beanClassMap.get(clazz);
        if (beanInfos == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(beanInfos.size());
        beanInfos.forEach(beanInfo -> map.put(beanInfo.getName(), beanInfo.getBean()));
        return map;
    }

    @Override
    public <T> Map<String, T> getCastBeanMap(Class<T> clazz) {
        List beanInfos = (List)this.beanClassMap.get(clazz);
        if (beanInfos == null) {
            return null;
        }
        HashMap map = new HashMap(beanInfos.size());
        beanInfos.forEach(beanInfo -> map.put(beanInfo.getName(), clazz.cast(beanInfo.getBean())));
        return map;
    }

    @Override
    public <T> List<T> getBeanList(Class<T> clazz) {
        List beanInfos = (List)this.beanClassMap.get(clazz);
        ArrayList<T> list = new ArrayList<T>();
        if (beanInfos == null) {
            return list;
        }
        for (BeanInfo beanInfo : beanInfos) {
            list.add(clazz.cast(beanInfo.getBean()));
        }
        return list;
    }

    @Override
    public Collection<Object> getBeans() {
        return Collections.unmodifiableCollection(this.beans);
    }

    @Override
    public Set<String> getBeanNames() {
        return this.beanNameMap.keySet();
    }

    @Override
    public void clean() {
        this.beanClassMap.clear();
        this.beanNameMap.clear();
        this.beans.clear();
    }

    private void setBean(Class<?> clazz, BeanInfo beanInfo) {
        this.beanClassMap.computeIfAbsent(clazz, k -> new LinkedList()).add(beanInfo);
    }

    private void margeSuperClass(BeanInfo beanInfo) {
        Class<?> clazz = beanInfo.getBean().getClass();
        do {
            this.setBean(clazz, beanInfo);
            this.mergeInterface(clazz, beanInfo);
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
    }

    private void mergeInterface(Class<?> clazz, BeanInfo beanInfo) {
        Class<?>[] interfaces;
        for (Class<?> inter : interfaces = clazz.getInterfaces()) {
            if (inter.getName().startsWith("java")) continue;
            this.setBean(inter, beanInfo);
        }
    }
}

