/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import xyz.erupt.core.cache.EruptCache;

public class EruptCacheLRU<V>
extends LinkedHashMap<String, ExpireNode<V>>
implements EruptCache<V> {
    private final int capacity;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public EruptCacheLRU(int capacity) {
        super((int)Math.ceil((double)capacity / 0.75) + 1, 0.75f, true);
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(String key, V v, long ttl) {
        long expireTime = ttl > 0L ? System.currentTimeMillis() + ttl : Long.MAX_VALUE;
        this.lock.writeLock().lock();
        try {
            this.put(key, new ExpireNode<V>(expireTime, v));
            V v2 = v;
            return v2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(String key) {
        ExpireNode expireNode;
        this.lock.readLock().lock();
        try {
            expireNode = (ExpireNode)super.get(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (expireNode == null) {
            return null;
        }
        if (expireNode.expire < System.currentTimeMillis()) {
            try {
                this.lock.writeLock().lock();
                super.remove(key);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return null;
        }
        expireNode.setExpire(expireNode.getExpire() + 100L);
        return expireNode.value;
    }

    @Override
    public void expire(String key, long ttl) {
        ((ExpireNode)super.get(key)).setExpire(System.currentTimeMillis() + ttl);
    }

    @Override
    public Long getExpire(String key) {
        return ((ExpireNode)super.get((Object)key)).expire - System.currentTimeMillis();
    }

    @Override
    public void delete(String key) {
        try {
            this.lock.writeLock().lock();
            super.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, ExpireNode<V>> eldest) {
        if (this.size() > this.capacity) {
            this.clean();
        }
        return this.size() > this.capacity;
    }

    @Override
    public ExpireNode<V> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean() {
        try {
            this.lock.writeLock().lock();
            Iterator iterator = super.entrySet().iterator();
            long now = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (((ExpireNode)next.getValue()).expire >= now) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static class ExpireNode<V> {
        private long expire;
        private V value;

        ExpireNode(long expire, V value) {
            this.expire = expire;
            this.value = value;
        }

        @Generated
        public long getExpire() {
            return this.expire;
        }

        @Generated
        public V getValue() {
            return this.value;
        }

        @Generated
        public void setExpire(long expire) {
            this.expire = expire;
        }

        @Generated
        public void setValue(V value) {
            this.value = value;
        }
    }
}

