/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.fun.AutoCompleteHandler;
import xyz.erupt.annotation.fun.ChoiceTrigger;
import xyz.erupt.annotation.fun.CodeEditHintHandler;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.annotation.sub_field.sub_edit.AutoCompleteType;
import xyz.erupt.annotation.sub_field.sub_edit.ChoiceType;
import xyz.erupt.annotation.sub_field.sub_edit.CodeEditorType;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;

@RestController
@RequestMapping(value={"/erupt-api/comp"})
public class EruptComponentController {
    @PostMapping(value={"/auto-complete/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public List<Object> autoCompleteValue(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field, @RequestParam(value="val") String val, @RequestBody(required=false) Map<String, Object> formData) {
        EruptFieldModel fieldModel = EruptCoreService.getErupt(eruptName).getEruptFieldMap().get(field);
        AutoCompleteType autoCompleteType = fieldModel.getEruptField().edit().autoCompleteType();
        if (val.length() < autoCompleteType.triggerLength()) {
            throw new EruptWebApiRuntimeException("char length must >= " + autoCompleteType.triggerLength());
        }
        try {
            return ((AutoCompleteHandler)EruptSpringUtil.getBean(autoCompleteType.handler())).completeHandler(formData, val, autoCompleteType.param());
        }
        catch (Exception e) {
            throw new EruptApiErrorTip(e.getMessage(), EruptApiModel.PromptWay.MESSAGE);
        }
    }

    @GetMapping(value={"/choice-item/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public List<VLModel> choiceItem(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        EruptFieldModel fieldModel = eruptModel.getEruptFieldMap().get(field);
        return EruptUtil.getChoiceList(eruptModel, fieldModel.getEruptField().edit());
    }

    @PostMapping(value={"/choice-item-filter/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public List<VLModel> choiceFilter(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field, @RequestBody Map<String, Object> formData) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        EruptFieldModel fieldModel = eruptModel.getEruptFieldMap().get(field);
        return EruptUtil.getChoiceListFilter(eruptModel, fieldModel.getEruptField().edit(), formData);
    }

    @GetMapping(value={"/choice-trigger/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public Map<String, Object> choiceTrigger(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field, @RequestParam(value="val") Object val) {
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        EruptFieldModel fieldModel = eruptModel.getEruptFieldMap().get(field);
        ChoiceType choiceType = fieldModel.getEruptField().edit().choiceType();
        if (choiceType.trigger().isInterface()) {
            return Collections.emptyMap();
        }
        return ((ChoiceTrigger)EruptSpringUtil.getBean(choiceType.trigger())).trigger(val, choiceType.triggerParams());
    }

    @GetMapping(value={"/tags-item/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public List<String> tagsItem(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field) {
        EruptFieldModel fieldModel = EruptCoreService.getErupt(eruptName).getEruptFieldMap().get(field);
        return EruptUtil.getTagList(fieldModel.getEruptField().edit().tagsType());
    }

    @GetMapping(value={"/code-edit-hints/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public List<String> codeEditHints(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field) {
        EruptFieldModel fieldModel = EruptCoreService.getErupt(eruptName).getEruptFieldMap().get(field);
        CodeEditorType codeEditType = fieldModel.getEruptField().edit().codeEditType();
        return ((CodeEditHintHandler)EruptSpringUtil.getBean(codeEditType.hint())).hint(codeEditType.hintParams());
    }
}

